/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.runner.DispatcherRunner;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherResourceManagerComponent
implements AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherResourceManagerComponent.class);
    @Nonnull
    private final DispatcherRunner dispatcherRunner;
    @Nonnull
    private final ResourceManagerService resourceManagerService;
    @Nonnull
    private final LeaderRetrievalService dispatcherLeaderRetrievalService;
    @Nonnull
    private final LeaderRetrievalService resourceManagerRetrievalService;
    @Nonnull
    private final AutoCloseableAsync webMonitorEndpoint;
    private final CompletableFuture<Void> terminationFuture;
    private final CompletableFuture<ApplicationStatus> shutDownFuture;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final FatalErrorHandler fatalErrorHandler;

    DispatcherResourceManagerComponent(@Nonnull DispatcherRunner dispatcherRunner, @Nonnull ResourceManagerService resourceManagerService, @Nonnull LeaderRetrievalService dispatcherLeaderRetrievalService, @Nonnull LeaderRetrievalService resourceManagerRetrievalService, @Nonnull AutoCloseableAsync webMonitorEndpoint, @Nonnull FatalErrorHandler fatalErrorHandler) {
        this.dispatcherRunner = dispatcherRunner;
        this.resourceManagerService = resourceManagerService;
        this.dispatcherLeaderRetrievalService = dispatcherLeaderRetrievalService;
        this.resourceManagerRetrievalService = resourceManagerRetrievalService;
        this.webMonitorEndpoint = webMonitorEndpoint;
        this.fatalErrorHandler = fatalErrorHandler;
        this.terminationFuture = new CompletableFuture();
        this.shutDownFuture = new CompletableFuture();
        this.registerShutDownFuture();
        this.handleUnexpectedResourceManagerTermination();
    }

    private void handleUnexpectedResourceManagerTermination() {
        this.resourceManagerService.getTerminationFuture().whenComplete((ignored, throwable) -> {
            if (this.isRunning.get()) {
                this.fatalErrorHandler.onFatalError((Throwable)new FlinkException("Unexpected termination of ResourceManager.", throwable));
            }
        });
    }

    private void registerShutDownFuture() {
        FutureUtils.forward(this.dispatcherRunner.getShutDownFuture(), this.shutDownFuture);
    }

    public final CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.shutDownFuture;
    }

    public CompletableFuture<Void> deregisterApplicationAndClose(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        if (this.isRunning.compareAndSet(true, false)) {
            CompletableFuture<Void> closeWebMonitorAndDeregisterAppFuture = FutureUtils.composeAfterwards(this.webMonitorEndpoint.closeAsync(), () -> this.deregisterApplication(applicationStatus, diagnostics));
            return FutureUtils.composeAfterwards(closeWebMonitorAndDeregisterAppFuture, this::closeAsyncInternal);
        }
        return this.terminationFuture;
    }

    private CompletableFuture<Void> deregisterApplication(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        ResourceManagerGateway selfGateway = this.resourceManagerService.getGateway();
        return selfGateway.deregisterApplication(applicationStatus, diagnostics).thenApply(ack -> null);
    }

    private CompletableFuture<Void> closeAsyncInternal() {
        LOG.info("Closing components.");
        Exception exception = null;
        ArrayList terminationFutures = new ArrayList(3);
        try {
            this.dispatcherLeaderRetrievalService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
        }
        try {
            this.resourceManagerRetrievalService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        terminationFutures.add(this.dispatcherRunner.closeAsync());
        terminationFutures.add(this.resourceManagerService.closeAsync());
        if (exception != null) {
            terminationFutures.add(FutureUtils.completedExceptionally(exception));
        }
        FutureUtils.ConjunctFuture<Void> componentTerminationFuture = FutureUtils.completeAll(terminationFutures);
        componentTerminationFuture.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.terminationFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.terminationFuture.complete((Void)aVoid);
            }
        });
        return this.terminationFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        return this.deregisterApplicationAndClose(ApplicationStatus.CANCELED, "DispatcherResourceManagerComponent has been closed.");
    }

    static interface ResourceManagerService
    extends AutoCloseableAsync {
        public ResourceManagerGateway getGateway();

        public CompletableFuture<Void> getTerminationFuture();
    }
}

