/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;

public class IntermediateResultPartition {
    private final IntermediateResult totalResult;
    private final ExecutionVertex producer;
    private final int partitionNumber;
    private final IntermediateResultPartitionID partitionId;
    private List<List<ExecutionEdge>> consumers;
    private boolean hasDataProduced = false;

    public IntermediateResultPartition(IntermediateResult totalResult, ExecutionVertex producer, int partitionNumber) {
        this.totalResult = totalResult;
        this.producer = producer;
        this.partitionNumber = partitionNumber;
        this.consumers = new ArrayList<List<ExecutionEdge>>(0);
        this.partitionId = new IntermediateResultPartitionID(totalResult.getId(), partitionNumber);
    }

    public ExecutionVertex getProducer() {
        return this.producer;
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public IntermediateResult getIntermediateResult() {
        return this.totalResult;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getResultType() {
        return this.totalResult.getResultType();
    }

    public List<List<ExecutionEdge>> getConsumers() {
        return this.consumers;
    }

    public void markDataProduced() {
        this.hasDataProduced = true;
    }

    public boolean isConsumable() {
        if (this.getResultType().isPipelined()) {
            return this.hasDataProduced;
        }
        return this.totalResult.areAllPartitionsFinished();
    }

    void resetForNewExecution() {
        if (this.getResultType().isBlocking() && this.hasDataProduced) {
            this.totalResult.incrementNumberOfRunningProducersAndGetRemaining();
        }
        this.hasDataProduced = false;
    }

    int addConsumerGroup() {
        int pos = this.consumers.size();
        if (pos != 0) {
            throw new RuntimeException("Currently, each intermediate result can only have one consumer.");
        }
        this.consumers.add(new ArrayList());
        return pos;
    }

    void addConsumer(ExecutionEdge edge, int consumerNumber) {
        this.consumers.get(consumerNumber).add(edge);
    }

    boolean markFinished() {
        if (!this.getResultType().isBlocking()) {
            throw new IllegalStateException("Tried to mark a non-blocking result partition as finished");
        }
        this.hasDataProduced = true;
        int refCnt = this.totalResult.decrementNumberOfRunningProducersAndGetRemaining();
        if (refCnt == 0) {
            return true;
        }
        if (refCnt < 0) {
            throw new IllegalStateException("Decremented number of unfinished producers below 0. This is most likely a bug in the execution state/intermediate result partition management.");
        }
        return false;
    }
}

