/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionedFile;
import org.apache.flink.runtime.io.network.partition.PartitionedFileReader;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SortMergeResultPartition;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class SortMergeSubpartitionReader
implements ResultSubpartitionView,
BufferRecycler {
    private static final int NUM_READ_BUFFERS = 2;
    private final SortMergeResultPartition partition;
    private final BufferAvailabilityListener availabilityListener;
    private final Queue<MemorySegment> readBuffers = new ArrayDeque<MemorySegment>();
    private final Queue<Buffer> buffersRead = new ArrayDeque<Buffer>();
    private final PartitionedFileReader fileReader;
    private int dataBufferBacklog;
    private boolean isReleased;
    private int sequenceNumber;

    public SortMergeSubpartitionReader(int subpartitionIndex, int dataBufferBacklog, int bufferSize, SortMergeResultPartition partition, BufferAvailabilityListener listener, PartitionedFile partitionedFile) throws IOException {
        this.partition = (SortMergeResultPartition)Preconditions.checkNotNull((Object)partition);
        this.availabilityListener = (BufferAvailabilityListener)Preconditions.checkNotNull((Object)listener);
        this.dataBufferBacklog = dataBufferBacklog;
        for (int i = 0; i < 2; ++i) {
            this.readBuffers.add(MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)bufferSize, null));
        }
        this.fileReader = new PartitionedFileReader(partitionedFile, subpartitionIndex);
        try {
            this.readBuffers();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((AutoCloseable)this.fileReader);
            throw throwable;
        }
    }

    @Override
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() {
        Buffer lookAhead;
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Reader is already released.");
        Buffer buffer = this.buffersRead.poll();
        if (buffer == null) {
            return null;
        }
        if (buffer.isBuffer()) {
            --this.dataBufferBacklog;
        }
        return ResultSubpartition.BufferAndBacklog.fromBufferAndLookahead(buffer, (lookAhead = this.buffersRead.peek()) == null ? Buffer.DataType.NONE : lookAhead.getDataType(), this.dataBufferBacklog, this.sequenceNumber++);
    }

    void readBuffers() throws IOException {
        MemorySegment segment;
        while ((segment = this.readBuffers.poll()) != null) {
            Buffer buffer = this.fileReader.readBuffer(segment, this);
            if (buffer == null) {
                this.readBuffers.add(segment);
                break;
            }
            this.buffersRead.add(buffer);
        }
    }

    @Override
    public void notifyDataAvailable() {
        if (!this.buffersRead.isEmpty()) {
            this.availabilityListener.notifyDataAvailable();
        }
    }

    @Override
    public void recycle(MemorySegment segment) {
        if (!this.isReleased) {
            this.readBuffers.add(segment);
        }
        if (!this.isReleased && this.readBuffers.size() == 2) {
            try {
                this.readBuffers();
            }
            catch (IOException exception) {
                ExceptionUtils.rethrow((Throwable)exception, (String)"Failed to read next buffer.");
            }
            this.notifyDataAvailable();
        }
    }

    @Override
    public void releaseAllResources() {
        this.isReleased = true;
        this.buffersRead.clear();
        this.readBuffers.clear();
        IOUtils.closeQuietly((AutoCloseable)this.fileReader);
        this.partition.releaseReader(this);
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    @Override
    public void resumeConsumption() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    public Throwable getFailureCause() {
        return null;
    }

    @Override
    public boolean isAvailable(int numCreditsAvailable) {
        if (numCreditsAvailable > 0) {
            return !this.buffersRead.isEmpty();
        }
        return !this.buffersRead.isEmpty() && !this.buffersRead.peek().isBuffer();
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return 0;
    }
}

