/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class ResourceProfileInfo
implements ResponseBody,
Serializable {
    private static final long serialVersionUID = 2286586486998901098L;
    public static final String FIELD_NAME_CPU = "cpuCores";
    public static final String FIELD_NAME_TASK_HEAP = "taskHeapMemory";
    public static final String FIELD_NAME_TASK_OFFHEAP = "taskOffHeapMemory";
    public static final String FIELD_NAME_MANAGED = "managedMemory";
    public static final String FIELD_NAME_NETWORK = "networkMemory";
    public static final String FIELD_NAME_EXTENDED = "extendedResources";
    @JsonProperty(value="cpuCores")
    private final double cpu;
    @JsonProperty(value="taskHeapMemory")
    private final int taskHeapMB;
    @JsonProperty(value="taskOffHeapMemory")
    private final int taskOffHeapMB;
    @JsonProperty(value="managedMemory")
    private final int managedMB;
    @JsonProperty(value="networkMemory")
    private final int networkMB;
    @JsonProperty(value="extendedResources")
    private final Map<String, Double> extendedResources;

    @JsonCreator
    public ResourceProfileInfo(@JsonProperty(value="cpuCores") double cpu, @JsonProperty(value="taskHeapMemory") int taskHeapMB, @JsonProperty(value="taskOffHeapMemory") int taskOffHeapMB, @JsonProperty(value="managedMemory") int managedMB, @JsonProperty(value="networkMemory") int networkMB, @JsonProperty(value="extendedResources") Map<String, Double> extendedResources) {
        this.cpu = cpu;
        this.taskHeapMB = taskHeapMB;
        this.taskOffHeapMB = taskOffHeapMB;
        this.managedMB = managedMB;
        this.networkMB = networkMB;
        this.extendedResources = extendedResources;
    }

    private ResourceProfileInfo(ResourceProfile resourceProfile) {
        this(resourceProfile.getCpuCores().getValue().doubleValue(), resourceProfile.getTaskHeapMemory().getMebiBytes(), resourceProfile.getTaskOffHeapMemory().getMebiBytes(), resourceProfile.getManagedMemory().getMebiBytes(), resourceProfile.getNetworkMemory().getMebiBytes(), ResourceProfileInfo.getExetendedResources(resourceProfile.getExtendedResources()));
    }

    private ResourceProfileInfo() {
        this(-1.0, -1, -1, -1, -1, Collections.emptyMap());
    }

    public static ResourceProfileInfo fromResrouceProfile(ResourceProfile resourceProfile) {
        return resourceProfile.equals(ResourceProfile.UNKNOWN) ? new ResourceProfileInfo() : new ResourceProfileInfo(resourceProfile);
    }

    private static Map<String, Double> getExetendedResources(Map<String, Resource> exetendedResources) {
        return exetendedResources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Resource)e.getValue()).getValue().doubleValue()));
    }

    public double getCpu() {
        return this.cpu;
    }

    public int getTaskHeapMB() {
        return this.taskHeapMB;
    }

    public int getTaskOffHeapMB() {
        return this.taskOffHeapMB;
    }

    public int getManagedMB() {
        return this.managedMB;
    }

    public int getNetworkMB() {
        return this.networkMB;
    }

    public Map<String, Double> getExtendedResources() {
        return Collections.unmodifiableMap(this.extendedResources);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceProfileInfo that = (ResourceProfileInfo)o;
        return this.cpu == that.cpu && this.taskHeapMB == that.taskHeapMB && this.taskOffHeapMB == that.taskOffHeapMB && this.managedMB == that.managedMB && this.networkMB == that.networkMB && Objects.equals(this.extendedResources, that.extendedResources);
    }

    public int hashCode() {
        return Objects.hash(this.cpu, this.taskHeapMB, this.taskOffHeapMB, this.managedMB, this.networkMB, this.extendedResources);
    }
}

