/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class UseArgumentTypeStrategy
implements TypeStrategy {
    private final int pos;

    public UseArgumentTypeStrategy(int pos) {
        Preconditions.checkArgument((pos >= 0 ? 1 : 0) != 0);
        this.pos = pos;
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (this.pos >= argumentDataTypes.size()) {
            return Optional.empty();
        }
        return Optional.of(argumentDataTypes.get(this.pos));
    }
}

