/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.flink.FlinkVersion;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.table.planner.utils.JsonTestUtils;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class CompiledPlanITCase
extends JsonPlanTestBase {
    private static final List<String> DATA = Arrays.asList("1,1,hi", "2,1,hello", "3,2,hello world");
    private static final String[] COLUMNS_DEFINITION = new String[]{"a bigint", "b int", "c varchar"};

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        String srcTableDdl = "CREATE TABLE MyTable (\n" + String.join((CharSequence)",", COLUMNS_DEFINITION) + ") with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tableEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n" + String.join((CharSequence)",", COLUMNS_DEFINITION) + ") with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tableEnv.executeSql(sinkTableDdl);
    }

    @Test
    public void testCompilePlanSql() throws IOException {
        CompiledPlan compiledPlan = this.tableEnv.compilePlanSql("INSERT INTO MySink SELECT * FROM MyTable");
        String expected = TableTestUtil.readFromResource("/jsonplan/testGetJsonPlan.out");
        Assertions.assertThat((String)TableTestUtil.replaceExecNodeId(TableTestUtil.replaceFlinkVersion(TableTestUtil.getFormattedJson(compiledPlan.asJsonString())))).isEqualTo(TableTestUtil.replaceExecNodeId(TableTestUtil.replaceFlinkVersion(TableTestUtil.getFormattedJson(expected))));
    }

    @Test
    public void testExecutePlanSql() throws Exception {
        File sinkPath = this.createSourceSinkTables();
        this.tableEnv.compilePlanSql("INSERT INTO sink SELECT * FROM src").execute().await();
        this.assertResult(DATA, sinkPath);
    }

    @Test
    public void testExecutePlanTable() throws Exception {
        File sinkPath = this.createSourceSinkTables();
        this.tableEnv.from("src").select(new Expression[]{Expressions.$((String)"*")}).insertInto("sink").compilePlan().execute().await();
        this.assertResult(DATA, sinkPath);
    }

    @Test
    public void testCompileWriteToFileAndThenExecuteSql() throws Exception {
        Path planPath = Paths.get(URI.create(this.getTempDirPath("plan")).getPath(), "plan.json");
        FileUtils.createParentDirectories((File)planPath.toFile());
        File sinkPath = this.createSourceSinkTables();
        CompiledPlan plan = this.tableEnv.compilePlanSql("INSERT INTO sink SELECT * FROM src");
        plan.writeToFile(planPath);
        this.tableEnv.executeSql(String.format("EXECUTE PLAN '%s'", planPath.toAbsolutePath())).await();
        this.assertResult(DATA, sinkPath);
    }

    @Test
    public void testCompilePlan() throws Exception {
        Path planPath = Paths.get(URI.create(this.getTempDirPath("plan")).getPath(), "plan.json").toAbsolutePath();
        FileUtils.createParentDirectories((File)planPath.toFile());
        File sinkPath = this.createSourceSinkTables();
        TableResult tableResult = this.tableEnv.executeSql(String.format("COMPILE PLAN '%s' FOR INSERT INTO sink SELECT * FROM src", planPath));
        Assertions.assertThat((Object)tableResult).isEqualTo((Object)TableResultInternal.TABLE_RESULT_OK);
        Assertions.assertThat((File)planPath.toFile()).exists();
        Assertions.assertThatThrownBy(() -> this.tableEnv.executeSql(String.format("COMPILE PLAN '%s' FOR INSERT INTO sink SELECT * FROM src", planPath))).satisfies(FlinkAssertions.anyCauseMatches(TableException.class, (String)"Cannot overwrite the plan file"));
        this.tableEnv.executeSql(String.format("EXECUTE PLAN '%s'", planPath)).await();
        this.assertResult(DATA, sinkPath);
    }

    @Test
    public void testCompilePlanWithStatementSet() throws Exception {
        Path planPath = Paths.get(URI.create(this.getTempDirPath("plan")).getPath(), "plan.json").toAbsolutePath();
        FileUtils.createParentDirectories((File)planPath.toFile());
        this.createTestCsvSourceTable("src", DATA, COLUMNS_DEFINITION);
        File sinkAPath = this.createTestCsvSinkTable("sinkA", COLUMNS_DEFINITION);
        File sinkBPath = this.createTestCsvSinkTable("sinkB", COLUMNS_DEFINITION);
        TableResult tableResult = this.tableEnv.executeSql(String.format("COMPILE PLAN '%s' FOR STATEMENT SET BEGIN INSERT INTO sinkA SELECT * FROM src;INSERT INTO sinkB SELECT a + 1, b + 1, CONCAT(c, '-something') FROM src;END", planPath));
        Assertions.assertThat((Object)tableResult).isEqualTo((Object)TableResultInternal.TABLE_RESULT_OK);
        Assertions.assertThat((File)planPath.toFile()).exists();
        this.tableEnv.executeSql(String.format("EXECUTE PLAN '%s'", planPath)).await();
        this.assertResult(DATA, sinkAPath);
        this.assertResult(Arrays.asList("2,2,hi-something", "3,2,hello-something", "4,3,hello world-something"), sinkBPath);
    }

    @Test
    public void testCompilePlanIfNotExists() throws Exception {
        Path planPath = Paths.get(URI.create(this.getTempDirPath("plan")).getPath(), "plan.json").toAbsolutePath();
        FileUtils.createParentDirectories((File)planPath.toFile());
        File sinkPath = this.createSourceSinkTables();
        TableResult tableResult = this.tableEnv.executeSql(String.format("COMPILE PLAN '%s' IF NOT EXISTS FOR INSERT INTO sink SELECT * FROM src", planPath));
        Assertions.assertThat((Object)tableResult).isEqualTo((Object)TableResultInternal.TABLE_RESULT_OK);
        Assertions.assertThat((File)planPath.toFile()).exists();
        Assertions.assertThat((Object)this.tableEnv.executeSql(String.format("COMPILE PLAN '%s' IF NOT EXISTS FOR INSERT INTO sink SELECT a + 1, b + 1, CONCAT(c, '-something') FROM src", planPath))).isEqualTo((Object)TableResultInternal.TABLE_RESULT_OK);
        this.tableEnv.executeSql(String.format("EXECUTE PLAN '%s'", planPath)).await();
        this.assertResult(DATA, sinkPath);
    }

    @Test
    public void testCompilePlanOverwrite() throws Exception {
        this.tableEnv.getConfig().set(TableConfigOptions.PLAN_FORCE_RECOMPILE, (Object)true);
        Path planPath = Paths.get(URI.create(this.getTempDirPath("plan")).getPath(), "plan.json").toAbsolutePath();
        FileUtils.createParentDirectories((File)planPath.toFile());
        List<String> expectedData = Arrays.asList("2,2,hi-something", "3,2,hello-something", "4,3,hello world-something");
        File sinkPath = this.createSourceSinkTables();
        TableResult tableResult = this.tableEnv.executeSql(String.format("COMPILE PLAN '%s' FOR INSERT INTO sink SELECT * FROM src", planPath));
        Assertions.assertThat((Object)tableResult).isEqualTo((Object)TableResultInternal.TABLE_RESULT_OK);
        Assertions.assertThat((File)planPath.toFile()).exists();
        Assertions.assertThat((Object)this.tableEnv.executeSql(String.format("COMPILE PLAN '%s' FOR INSERT INTO sink SELECT a + 1, b + 1, CONCAT(c, '-something') FROM src", planPath))).isEqualTo((Object)TableResultInternal.TABLE_RESULT_OK);
        this.tableEnv.executeSql(String.format("EXECUTE PLAN '%s'", planPath)).await();
        this.assertResult(expectedData, sinkPath);
    }

    @Test
    public void testCompileAndExecutePlan() throws Exception {
        Path planPath = Paths.get(URI.create(this.getTempDirPath("plan")).getPath(), "plan.json").toAbsolutePath();
        FileUtils.createParentDirectories((File)planPath.toFile());
        File sinkPath = this.createSourceSinkTables();
        this.tableEnv.executeSql(String.format("COMPILE AND EXECUTE PLAN '%s' FOR INSERT INTO sink SELECT * FROM src", planPath)).await();
        Assertions.assertThat((File)planPath.toFile()).exists();
        this.assertResult(DATA, sinkPath);
    }

    @Test
    public void testCompileAndExecutePlanWithStatementSet() throws Exception {
        Path planPath = Paths.get(URI.create(this.getTempDirPath("plan")).getPath(), "plan.json").toAbsolutePath();
        FileUtils.createParentDirectories((File)planPath.toFile());
        this.createTestCsvSourceTable("src", DATA, COLUMNS_DEFINITION);
        File sinkAPath = this.createTestCsvSinkTable("sinkA", COLUMNS_DEFINITION);
        File sinkBPath = this.createTestCsvSinkTable("sinkB", COLUMNS_DEFINITION);
        this.tableEnv.executeSql(String.format("COMPILE AND EXECUTE PLAN '%s' FOR STATEMENT SET BEGIN INSERT INTO sinkA SELECT * FROM src;INSERT INTO sinkB SELECT a + 1, b + 1, CONCAT(c, '-something') FROM src;END", planPath)).await();
        Assertions.assertThat((File)planPath.toFile()).exists();
        this.assertResult(DATA, sinkAPath);
        this.assertResult(Arrays.asList("2,2,hi-something", "3,2,hello-something", "4,3,hello world-something"), sinkBPath);
    }

    @Test
    public void testExplainPlan() throws IOException {
        String planFromResources = JsonTestUtils.setFlinkVersion(JsonTestUtils.readFromResource("/jsonplan/testGetJsonPlan.out"), FlinkVersion.current()).toString();
        String actual = this.tableEnv.loadPlan(PlanReference.fromJsonString((String)planFromResources)).explain(new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN});
        String expected = TableTestUtil.readFromResource("/explain/testExplainJsonPlan.out");
        Assertions.assertThat((String)TableTestUtil.replaceNodeIdInOperator(TableTestUtil.replaceStreamNodeId(actual))).isEqualTo(expected);
    }

    @Test
    public void testPersistedConfigOption() throws Exception {
        Path planPath = Paths.get(URI.create(this.getTempDirPath("plan")).getPath(), "plan.json");
        FileUtils.createParentDirectories((File)planPath.toFile());
        List<String> data = Stream.concat(DATA.stream(), Stream.of("4,2,This string is long", "5,3,This is an even longer string")).collect(Collectors.toList());
        String[] sinkColumnDefinitions = new String[]{"a bigint", "b int", "c varchar(11)"};
        this.createTestCsvSourceTable("src", data, COLUMNS_DEFINITION);
        File sinkPath = this.createTestCsvSinkTable("sink", sinkColumnDefinitions);
        this.tableEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_SINK_TYPE_LENGTH_ENFORCER, (Object)ExecutionConfigOptions.TypeLengthEnforcer.TRIM_PAD);
        CompiledPlan plan = this.tableEnv.compilePlanSql("INSERT INTO sink SELECT * FROM src");
        this.tableEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_SINK_TYPE_LENGTH_ENFORCER, (Object)ExecutionConfigOptions.TypeLengthEnforcer.IGNORE);
        plan.execute().await();
        List<String> expected = Stream.concat(DATA.stream(), Stream.of("4,2,This string", "5,3,This is an ")).collect(Collectors.toList());
        this.assertResult(expected, sinkPath);
    }

    @Test
    public void testBatchMode() {
        this.tableEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inBatchMode());
        String srcTableDdl = "CREATE TABLE src (\n  a bigint\n) with (\n  'connector' = 'values',\n  'bounded' = 'true')";
        this.tableEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE sink (\n  a bigint\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tableEnv.executeSql(sinkTableDdl);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tableEnv.compilePlanSql("INSERT INTO sink SELECT * FROM src")).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The compiled plan feature is not supported in batch mode.");
    }

    private File createSourceSinkTables() throws IOException {
        this.createTestCsvSourceTable("src", DATA, COLUMNS_DEFINITION);
        return this.createTestCsvSinkTable("sink", COLUMNS_DEFINITION);
    }
}

