/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class EnvironmentTest {
    @Test
    public void testPassingExecutionParameters() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        tEnv.getConfig().addConfiguration(new Configuration().set(CoreOptions.DEFAULT_PARALLELISM, (Object)128).set(PipelineOptions.AUTO_WATERMARK_INTERVAL, (Object)Duration.ofMillis(800L)).set(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL, (Object)Duration.ofSeconds(30L)));
        tEnv.createTemporaryView("test", (DataStream)env.fromElements((Object[])new Integer[]{1, 2, 3}));
        Table table = tEnv.sqlQuery("SELECT * FROM test");
        tEnv.toAppendStream(table, Row.class);
        Assert.assertEquals((long)128L, (long)env.getParallelism());
        Assert.assertEquals((long)800L, (long)env.getConfig().getAutoWatermarkInterval());
        Assert.assertEquals((long)30000L, (long)env.getCheckpointConfig().getCheckpointInterval());
    }

    @Test
    public void testEnvironmentSettings() throws ExecutionException, InterruptedException {
        Configuration conf = new Configuration();
        conf.set(TableConfigOptions.TABLE_CATALOG_NAME, (Object)"myCatalog");
        EnvironmentSettings settings = EnvironmentSettings.newInstance().withConfiguration(conf).build();
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)settings);
        Assertions.assertThat((String)((String)tEnv.getConfig().get(TableConfigOptions.TABLE_CATALOG_NAME))).isEqualTo("myCatalog");
        Assertions.assertThat((String)tEnv.getCurrentCatalog()).isEqualTo("myCatalog");
        StreamTableEnvironment stEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)settings);
        Assertions.assertThat((String)((String)stEnv.getConfig().get(TableConfigOptions.TABLE_CATALOG_NAME))).isEqualTo("myCatalog");
        stEnv.getConfig().set(TableConfigOptions.TABLE_CATALOG_NAME, TableConfigOptions.TABLE_CATALOG_NAME.defaultValue());
        Assertions.assertThat((String)stEnv.getCurrentCatalog()).isEqualTo("myCatalog");
    }
}

