/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003'\u0019\tA\u0001^3ti&\u0011Q\u0003\u0005\u0002\u0011\u0003\n\u001cHO]1diR+7\u000f\u001e\"bg\u0016D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\ri\u0006\u0014G.Z#om:\u000bW.\u001a\t\u00033\tr!A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0005ua\u0011A\u0002\u001fs_>$hHC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tc$\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0011\u0012aa\u0015;sS:<'BA\u0011\u001f\u0011!1\u0003A!A!\u0002\u00139\u0013aC5t'R\u0014X-Y7j]\u001e\u0004\"\u0001K\u0015\u000e\u0003yI!A\u000b\u0010\u0003\u000f\t{w\u000e\\3b]\")A\u0006\u0001C\u0001[\u00051A(\u001b8jiz\"2A\f\u00192!\ty\u0003!D\u0001\u0003\u0011\u001592\u00061\u0001\u0019\u0011\u001513\u00061\u0001(\u0011\u001d\u0019\u0004A1A\u0005\u0002Q\n\u0011#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8o+\u0005)\u0004C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0015\u0011X\u000f\\3t\u0015\tQ$\"A\u0003kk:LG/\u0003\u0002=o\t\tR\t\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8\t\ry\u0002\u0001\u0015!\u00036\u0003I)\u0007\u0010]3di\u0016$W\t_2faRLwN\u001c\u0011\t\u000b\u0001\u0003A\u0011\u0001\u001b\u0002\rQD'o\\<oQ\ty$\t\u0005\u0002D\t6\t\u0011(\u0003\u0002Fs\t!!+\u001e7f\u0011\u001d9\u0005A1A\u0005\n!\u000b1b\u0018;f[B4u\u000e\u001c3feV\t\u0011\n\u0005\u00027\u0015&\u00111j\u000e\u0002\u0010)\u0016l\u0007o\u001c:bef4u\u000e\u001c3fe\"1Q\n\u0001Q\u0001\n%\u000bAb\u0018;f[B4u\u000e\u001c3fe\u0002BQa\u0014\u0001\u0005\u0002!\u000b!\u0002^3na\u001a{G\u000eZ3sQ\tq%\tC\u0005S\u0001\u0001\u0007\t\u0019!C\u0001'\u0006!A/\u00128w+\u0005!\u0006CA\u0018V\u0013\t1&A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"I\u0001\f\u0001a\u0001\u0002\u0004%\t!W\u0001\ti\u0016sgo\u0018\u0013fcR\u0011!,\u0018\t\u0003QmK!\u0001\u0018\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b=^\u000b\t\u00111\u0001U\u0003\rAH%\r\u0005\nA\u0002\u0001\r\u0011!Q!\nQ\u000bQ\u0001^#om\u0002BqA\u0019\u0001C\u0002\u0013%1-\u0001\u0005tKR$\u0018N\\4t+\u0005!\u0007CA\u0018f\u0013\t1'AA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000f\u0003\u0004i\u0001\u0001\u0006I\u0001Z\u0001\ng\u0016$H/\u001b8hg\u0002BQA\u001b\u0001\u0005\u0002-\fQa]3ukB$\u0012A\u0017\u0015\u0003S6\u0004\"a\u00118\n\u0005=L$A\u0002\"fM>\u0014X\rC\u0003r\u0001\u0011\u00051.A\u0006uKN$X\t_3dkR,\u0007F\u00019t!\t\u0019E/\u0003\u0002vs\t!A+Z:u\u0011\u00159\b\u0001\"\u0001l\u0003Q!Xm\u001d;D_2dWm\u0019;XSRD7\t\\8tK\"\u0012ao\u001d\u0005\u0006u\u0002!\ta[\u0001\u001di\u0016\u001cH/\u0012=fGV$XmV5uQV\u0003H-\u0019;f\u0007\"\fgnZ3tQ\tI8\u000fC\u0003~\u0001\u0011\u00051.A\u000euKN$8i\u001c7mK\u000e$x+\u001b;i\u001bVdG/\u001b*poRLW.\u001a\u0015\u0003yNDs\u0001AA\u0001\u0003\u001b\ty\u0001\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9!O\u0001\u0007eVtg.\u001a:\n\t\u0005-\u0011Q\u0001\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\"O\u0001\beVtg.\u001a:t\u0013\u0011\tY\"!\u0006\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u000f\u001d\tyB\u0001E\u0001\u0003C\t1\u0002V1cY\u0016LEkQ1tKB\u0019q&a\t\u0007\r\u0005\u0011\u0001\u0012AA\u0013'\u0011\t\u0019#a\n\u0011\u0007!\nI#C\u0002\u0002,y\u0011a!\u00118z%\u00164\u0007b\u0002\u0017\u0002$\u0011\u0005\u0011q\u0006\u000b\u0003\u0003CA\u0001\"a\r\u0002$\u0011\u0005\u0011QG\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA\u001c!\u0019\tI$!\u0011\u0002F5\u0011\u00111\b\u0006\u0004#\u0005u\"BAA \u0003\u0011Q\u0017M^1\n\t\u0005\r\u00131\b\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0007BA$\u0003#\u0002R\u0001KA%\u0003\u001bJ1!a\u0013\u001f\u0005\u0015\t%O]1z!\u0011\ty%!\u0015\r\u0001\u0011a\u00111KA\u0019\u0003\u0003\u0005\tQ!\u0001\u0002V\t\u0019q\fJ\u0019\u0012\t\u0005]\u0013Q\f\t\u0004Q\u0005e\u0013bAA.=\t9aj\u001c;iS:<\u0007c\u0001\u0015\u0002`%\u0019\u0011\u0011\r\u0010\u0003\u0007\u0005s\u0017\u0010\u000b\u0005\u00022\u0005\u0015\u00141OA;!\u0011\t9'!\u001c\u000f\t\u0005M\u0011\u0011N\u0005\u0005\u0003W\n)\"A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0003_\n\tH\u0001\u0006QCJ\fW.\u001a;feNTA!a\u001b\u0002\u0016\u0005!a.Y7fC\t\t9(\u0001\t|auT\u0014n]*ue\u0016\fW.P>2{\u0002")
public class TableITCase
extends AbstractTestBase {
    private final String tableEnvName;
    private final boolean isStreaming;
    private final ExpectedException expectedException;
    private final TemporaryFolder _tempFolder;
    private TableEnvironment tEnv;
    private final EnvironmentSettings settings;

    @Parameterized.Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableITCase$.MODULE$.parameters();
    }

    public ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    @Before
    public void setup() {
        String string = this.tableEnvName;
        if ("TableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("StreamTableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append("unsupported tableEnvName: ").append(this.tableEnvName).toString());
        }
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
    }

    @Test
    public void testExecute() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        Table table = this.tEnv().sqlQuery(query);
        TableResult tableResult = table.execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        tableResult.await();
        CloseableIterator it = tableResult.collect();
        List actual = CollectionUtil.iteratorToList((Iterator)it);
        it.close();
        actual.sort(new Comparator<Row>(null){

            public Comparator<Row> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Row> thenComparing(Comparator<? super Row> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Row> thenComparingInt(ToIntFunction<? super Row> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Row> thenComparingLong(ToLongFunction<? super Row> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Row> thenComparingDouble(ToDoubleFunction<? super Row> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCollectWithClose() {
        block2: {
            Some jobStatus;
            Some some;
            String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
            Table table = this.tEnv().sqlQuery(query);
            TableResult tableResult = table.execute();
            Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
            Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
            CloseableIterator it = tableResult.collect();
            it.close();
            try {
                some = new Some(((JobClient)tableResult.getJobClient().get()).getJobStatus().get());
            }
            catch (Throwable throwable) {
                some = jobStatus = None$.MODULE$;
            }
            if (!jobStatus.isDefined()) break block2;
            Assert.assertNotEquals((Object)JobStatus.RUNNING, (Object)jobStatus.get());
        }
    }

    @Test
    public void testExecuteWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = this.isStreaming ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCollectWithMultiRowtime() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE MyTableWithRowtime1 (\n                      |  ts AS TO_TIMESTAMP_LTZ(id, 3),\n                      |  WATERMARK FOR ts AS ts - INTERVAL '1' MINUTE)\n                      |LIKE MyTable")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE MyTableWithRowtime2 (\n                      |  ts AS TO_TIMESTAMP_LTZ(id, 3),\n                      |  WATERMARK FOR ts AS ts - INTERVAL '1' MINUTE)\n                      |LIKE MyTable")).stripMargin());
        TableResult tableResult = this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                        |SELECT MyTableWithRowtime1.ts, MyTableWithRowtime2.ts\n                        |FROM MyTableWithRowtime1, MyTableWithRowtime2\n                        |WHERE\n                        |  MyTableWithRowtime1.first = MyTableWithRowtime2.first AND\n                        |  MyTableWithRowtime1.ts = MyTableWithRowtime2.ts")).stripMargin());
        IndexedSeq expected = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 8).map((Function1 & Serializable & scala.Serializable)i -> TableITCase.$anonfun$testCollectWithMultiRowtime$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.containsInAnyOrder((Object[])((Object[])expected.toArray(ClassTag$.MODULE$.apply(Row.class)))));
    }

    public static final /* synthetic */ Row $anonfun$testCollectWithMultiRowtime$1(int i) {
        return Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{Instant.ofEpochMilli(i), Instant.ofEpochMilli(i)});
    }

    public TableITCase(String tableEnvName, boolean isStreaming) {
        this.tableEnvName = tableEnvName;
        this.isStreaming = isStreaming;
        this.expectedException = ExpectedException.none();
        this._tempFolder = new TemporaryFolder();
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

