/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.IOException;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatementSetImplTest {
    TableEnvironmentInternal tableEnv;

    @Before
    public void setup() {
        this.tableEnv = (TableEnvironmentInternal)TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
    }

    @Test
    public void testGetJsonPlan() throws IOException {
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tableEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tableEnv.executeSql(sinkTableDdl);
        StatementSet stmtSet = this.tableEnv.createStatementSet();
        stmtSet.addInsertSql("INSERT INTO MySink SELECT * FROM MyTable");
        String jsonPlan = stmtSet.compilePlan().asJsonString();
        String actual = TableTestUtil.readFromResource("/jsonplan/testGetJsonPlan.out");
        Assert.assertEquals((Object)TableTestUtil.getFormattedJson(TableTestUtil.replaceExecNodeId(TableTestUtil.replaceFlinkVersion(TableTestUtil.getFormattedJson(jsonPlan)))), (Object)TableTestUtil.getFormattedJson(TableTestUtil.replaceExecNodeId(TableTestUtil.getFormattedJson(actual))));
    }
}

