/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.stream.sql.validation;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.api.stream.sql.validation.MatchRecognizeValidationTest$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.utils.ScalaStreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001'\taR*\u0019;dQJ+7m\\4oSj,g+\u00197jI\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u0013)\t1!\u00199j\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012!B;uS2\u001c(BA\r\u000b\u0003\u001d\u0001H.\u00198oKJL!a\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\u0015M$(/Z1n+RLG.F\u0001%!\t)R%\u0003\u0002'-\tA2kY1mCN#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r!\u0002\u0001\u0015!\u0003%\u0003-\u0019HO]3b[V#\u0018\u000e\u001c\u0011\t\u000b)\u0002A\u0011A\u0016\u00021Q,7\u000f^'bi\u000eD'k\\<uS6,\u0017J\\*fY\u0016\u001cG\u000fF\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011)f.\u001b;)\t%\u001a\u0014H\u000f\t\u0003i]j\u0011!\u000e\u0006\u0003mA\tQA[;oSRL!\u0001O\u001b\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\n1\b\u0005\u0002={5\t\u0001\"\u0003\u0002?\u0011\t\u0019b+\u00197jI\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\")\u0001\t\u0001C\u0001W\u0005IB/Z:u\u001b\u0006$8\r\u001b)s_\u000e$\u0018.\\3J]N+G.Z2uQ\u0011y4'\u000f\u001e\t\u000b\r\u0003A\u0011A\u0016\u00025Q,7\u000f^*peR\u0004&o\\2fgNLgn\u001a+j[\u0016$Um]2)\u0005\t\u001b\u0004\"\u0002$\u0001\t\u0003Y\u0013\u0001\n;fgR\u001cvN\u001d;Qe>\u001cWm]:j]\u001e$\u0016.\\3TK\u000e|g\u000eZ1ss\u001aKW\r\u001c3)\u0005\u0015\u001b\u0004\"B%\u0001\t\u0003Y\u0013a\u0004;fgR\u001cvN\u001d;O_>\u0013H-\u001a:)\u0005!\u001b\u0004\"\u0002'\u0001\t\u0003Y\u0013!\u000b;fgR,\u0006\u000fZ1uKNLe.\u00169tiJ,\u0017-\\(qKJ\fGo\u001c:O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002Lg!)q\n\u0001C\u0001W\u0005!D/Z:u\u0003\u001e<'/Z4bi\u0016\u001cxJ\\'vYRL\u0007\u000f\\3QCR$XM\u001d8WCJL\u0017M\u00197fg:{GoU;qa>\u0014H/\u001a3)\u00059\u001b\u0004\"\u0002*\u0001\t\u0003Y\u0013a\u000f;fgR\fum\u001a:fO\u0006$Xm](o\u001bVdG/\u001b9mKB\u000bG\u000f^3s]Z\u000b'/[1cY\u0016\u001chj\u001c;TkB\u0004xN\u001d;fI&sW\u000bR!Hg\"\u0012\u0011k\r\u0005\u0006+\u0002!\taK\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/\u001b8h\u00036\u0014\u0017nZ;pkN\u001cu\u000e\\;n]ND#\u0001V\u001a\t\u000ba\u0003A\u0011A\u0016\u0002/Q,7\u000f^'bi\u000eD\u0007+\u001f;i_:4UO\\2uS>t\u0007FA,4\u0011\u0015Y\u0006\u0001\"\u0001,\u0003M!Xm\u001d;BY2\u0014vn^:QKJl\u0015\r^2iQ\tQ6\u0007C\u0003_\u0001\u0011\u00051&\u0001\u0016uKN$xI]3fIf\fV/\u00198uS\u001aLWM]!u)\",WI\u001c3Jg:{GoU;qa>\u0014H/\u001a3)\u0005u\u001b\u0004\"B1\u0001\t\u0003Y\u0013\u0001\r;fgR\u0004\u0016\r\u001e;fe:\u001c\bK]8ek\u000eLgnZ#naRLX*\u0019;dQ\u0016\u001c\u0018I]3O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002ag!)A\r\u0001C\u0001W\u0005!C/Z:u\t&\u001cH/\u001b8di\u0006;wM]3hCRLwN\\:O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002dg\u0001")
public class MatchRecognizeValidationTest
extends TableTestBase {
    private final ScalaStreamTableTestUtil streamUtil = this.scalaStreamTestUtil();

    private ScalaStreamTableTestUtil streamUtil() {
        return this.streamUtil;
    }

    @Test(expected=ValidationException.class)
    public void testMatchRowtimeInSelect() {
        String sql = "SELECT MATCH_ROWTIME() FROM MyTable";
        this.streamUtil().verifyExplain(sql);
    }

    @Test(expected=ValidationException.class)
    public void testMatchProctimeInSelect() {
        String sql = "SELECT MATCH_PROCTIME() FROM MyTable";
        this.streamUtil().verifyExplain(sql);
    }

    @Test
    public void testSortProcessingTimeDesc() {
        this.thrown().expectMessage("Primary sort order of a streaming table must be ascending on time.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime DESC\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testSortProcessingTimeSecondaryField() {
        this.thrown().expectMessage("You must specify either rowtime or proctime for order by as the first one.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY price, proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testSortNoOrder() {
        this.thrown().expectMessage("You must specify either rowtime or proctime for order by.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testUpdatesInUpstreamOperatorNotSupported() {
        this.thrown().expectMessage("Match Recognize doesn't support consuming update changes which is produced by node GroupAggregate(");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM (SELECT DISTINCT * FROM Ticker)\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  ONE ROW PER MATCH\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toRetractStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testAggregatesOnMultiplePatternVariablesNotSupported() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("SQL validation failed.");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    SUM(A.price + B.tax) AS taxedPrice\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS A.symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testAggregatesOnMultiplePatternVariablesNotSupportedInUDAGs() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Aggregation must be applied to a single pattern variable");
        this.streamUtil().addFunction("weightedAvg", new JavaUserDefinedAggFunctions.WeightedAvg(), BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    weightedAvg(A.price, B.tax) AS weightedAvg\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS A.symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testValidatingAmbiguousColumns() {
        this.thrown().expectMessage("Columns ambiguously defined: {symbol, price}");
        this.thrown().expect(ValidationException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  PARTITION BY symbol, price\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS symbol,\n         |    A.price AS price\n         |  PATTERN (A)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testMatchPythonFunction() {
        this.thrown().expectMessage("Python Function can not be used in MATCH_RECOGNIZE for now.");
        this.thrown().expect(TableException.class);
        this.streamUtil().addFunction("pyFunc", new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sql = new StringOps(Predef$.MODULE$.augmentString("SELECT T.aa as ta\n        |FROM MyTable\n        |MATCH_RECOGNIZE (\n        |  ORDER BY proctime\n        |  MEASURES\n        |    A.a as aa,\n        |    pyFunc(1,2) as bb\n        |  PATTERN (A B)\n        |  DEFINE\n        |    A AS a = 1,\n        |    B AS b = 'b'\n        |) AS T")).stripMargin();
        this.streamUtil().verifyExplain(sql);
    }

    @Test
    public void testAllRowsPerMatch() {
        this.thrown().expectMessage("All rows per match mode is not supported yet.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  ALL ROWS PER MATCH\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testGreedyQuantifierAtTheEndIsNotSupported() {
        this.thrown().expectMessage("Greedy quantifiers are not allowed as the last element of a Pattern yet. Finish your pattern with either a simple variable or reluctant quantifier.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A B+)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testPatternsProducingEmptyMatchesAreNotSupported() {
        this.thrown().expectMessage("Patterns that can produce empty matches are not supported. There must be at least one non-optional state.");
        this.thrown().expect(TableException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    A.symbol AS aSymbol\n         |  PATTERN (A*)\n         |  DEFINE\n         |    A AS symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    @Test
    public void testDistinctAggregationsNotSupported() {
        this.thrown().expect(ValidationException.class);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM Ticker\n         |MATCH_RECOGNIZE (\n         |  ORDER BY proctime\n         |  MEASURES\n         |    COUNT(DISTINCT A.price) AS price\n         |  PATTERN (A B)\n         |  DEFINE\n         |    A AS A.symbol = 'a'\n         |) AS T\n         |")).stripMargin();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.streamUtil().tableEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
    }

    public MatchRecognizeValidationTest() {
        this.streamUtil().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple3<Object, String, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Timestamp>>(this, fieldSerializers){

                    public Tuple3<Object, String, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.stream.sql.validation.MatchRecognizeValidationTest$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.streamUtil().addDataStream("Ticker", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "symbol")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tstamp")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "price")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "tax")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime()}), new CaseClassTypeInfo<Tuple4<String, Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, Object>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.api.stream.sql.validation.MatchRecognizeValidationTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.streamUtil().addFunction("ToMillis", new UserDefinedFunctionTestUtils.ToMillis());
    }
}

