/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CatalogITCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testCreateCatalog() {
        String name = "c1";
        TableEnvironment tableEnv = this.getTableEnvironment();
        String ddl = String.format("create catalog %s with('type'='%s')", name, "generic_in_memory");
        tableEnv.executeSql(ddl);
        Assert.assertTrue((boolean)tableEnv.getCatalog(name).isPresent());
        Assert.assertTrue((boolean)(tableEnv.getCatalog(name).get() instanceof GenericInMemoryCatalog));
    }

    @Test
    public void testDropCatalog() {
        String name = "c1";
        TableEnvironment tableEnv = this.getTableEnvironment();
        String ddl = String.format("create catalog %s with('type'='%s')", name, "generic_in_memory");
        tableEnv.executeSql(ddl);
        Assert.assertTrue((boolean)tableEnv.getCatalog(name).isPresent());
        ddl = String.format("drop catalog %s", name);
        tableEnv.executeSql(ddl);
        Assert.assertFalse((boolean)tableEnv.getCatalog(name).isPresent());
    }

    @Test
    public void testCreateLegacyCatalogFromUserClassLoader() throws Exception {
        String className = "UserCatalogFactory";
        URLClassLoader classLoader = ClassLoaderUtils.withRoot((File)this.temporaryFolder.newFolder()).addResource("META-INF/services/org.apache.flink.table.factories.TableFactory", "UserCatalogFactory").addClass("UserCatalogFactory", "import org.apache.flink.table.catalog.GenericInMemoryCatalog;\nimport org.apache.flink.table.factories.CatalogFactory;\nimport java.util.Collections;\nimport org.apache.flink.table.catalog.Catalog;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\n\tpublic class UserCatalogFactory implements CatalogFactory {\n\t\t@Override\n\t\tpublic Catalog createCatalog(\n\t\t\t\tString name,\n\t\t\t\tMap<String, String> properties) {\n\t\t\treturn new GenericInMemoryCatalog(name);\n\t\t}\n\n\t\t@Override\n\t\tpublic Map<String, String> requiredContext() {\n\t\t\tHashMap<String, String> hashMap = new HashMap<>();\n\t\t\thashMap.put(\"type\", \"userCatalog\");\n\t\t\treturn hashMap;\n\t\t}\n\n\t\t@Override\n\t\tpublic List<String> supportedProperties() {\n\t\t\treturn Collections.emptyList();\n\t\t}\n\t}").build();
        try (TemporaryClassLoaderContext context = TemporaryClassLoaderContext.of((ClassLoader)classLoader);){
            TableEnvironment tableEnvironment = this.getTableEnvironment();
            tableEnvironment.executeSql("CREATE CATALOG cat WITH ('type'='userCatalog')");
            Assert.assertTrue((boolean)tableEnvironment.getCatalog("cat").isPresent());
        }
    }

    @Test
    public void testCreateCatalogFromUserClassLoader() throws Exception {
        String className = "UserCatalogFactory";
        URLClassLoader classLoader = ClassLoaderUtils.withRoot((File)this.temporaryFolder.newFolder()).addResource("META-INF/services/org.apache.flink.table.factories.Factory", "UserCatalogFactory").addClass("UserCatalogFactory", "import org.apache.flink.configuration.ConfigOption;\nimport org.apache.flink.table.catalog.Catalog;\nimport org.apache.flink.table.catalog.GenericInMemoryCatalog;\nimport org.apache.flink.table.factories.CatalogFactory;\n\nimport java.util.Collections;\nimport java.util.Set;\n\npublic class UserCatalogFactory implements CatalogFactory {\n    @Override\n    public Catalog createCatalog(Context context) {\n        return new GenericInMemoryCatalog(context.getName());\n    }\n\n    @Override\n    public String factoryIdentifier() {\n        return \"userCatalog\";\n    }\n\n    @Override\n    public Set<ConfigOption<?>> requiredOptions() {\n        return Collections.emptySet();\n    }\n\n    @Override\n    public Set<ConfigOption<?>> optionalOptions() {\n        return Collections.emptySet();\n    }\n}").build();
        try (TemporaryClassLoaderContext context = TemporaryClassLoaderContext.of((ClassLoader)classLoader);){
            TableEnvironment tableEnvironment = this.getTableEnvironment();
            tableEnvironment.executeSql("CREATE CATALOG cat WITH ('type'='userCatalog')");
            Assert.assertTrue((boolean)tableEnvironment.getCatalog("cat").isPresent());
        }
    }

    @Test
    public void testGetTablesFromGivenCatalogDatabase() throws Exception {
        GenericInMemoryCatalog c1 = new GenericInMemoryCatalog("c1", "default");
        GenericInMemoryCatalog c2 = new GenericInMemoryCatalog("c2", "d2");
        CatalogManager catalogManager = CatalogManagerMocks.preparedCatalogManager().defaultCatalog("c2", (Catalog)c2).build();
        catalogManager.registerCatalog("c1", (Catalog)c1);
        CatalogTable catalogTable = CatalogTable.of((Schema)Schema.newBuilder().build(), null, new ArrayList(), new HashMap());
        c1.createDatabase("d1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), null), true);
        c1.createTable(new ObjectPath("d1", "t1"), (CatalogBaseTable)catalogTable, true);
        c2.createTable(new ObjectPath(catalogManager.getCurrentDatabase(), "t2"), (CatalogBaseTable)catalogTable, true);
        Assertions.assertThat((String)catalogManager.getCurrentCatalog()).isEqualTo("c2");
        Assertions.assertThat((String)catalogManager.getCurrentDatabase()).isEqualTo("d2");
        Assertions.assertThat((Collection)catalogManager.listTables()).containsExactlyInAnyOrder((Object[])new String[]{"t2"});
        Assertions.assertThat((Collection)catalogManager.listTables("c1", "d1")).containsExactlyInAnyOrder((Object[])new String[]{"t1"});
    }

    private TableEnvironment getTableEnvironment() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        return StreamTableEnvironment.create((StreamExecutionEnvironment)env, (EnvironmentSettings)settings);
    }
}

