/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Tumble;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JavaCatalogTableTest
extends TableTestBase {
    @Parameterized.Parameter
    public boolean isStreamingMode;

    @Parameterized.Parameters(name="streamingMode = {0}")
    public static Collection<Boolean> parameters() {
        return Arrays.asList(true, false);
    }

    private TableTestUtil getTestUtil() {
        if (this.isStreamingMode) {
            return this.streamTestUtil(new TableConfig());
        }
        return this.batchTestUtil(new TableConfig());
    }

    @Test
    public void testResolvingSchemaOfCustomCatalogTableSql() throws Exception {
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        GenericInMemoryCatalog genericInMemoryCatalog = new GenericInMemoryCatalog("in-memory");
        genericInMemoryCatalog.createTable(new ObjectPath("default", "testTable"), (CatalogBaseTable)new CustomCatalogTable(this.isStreamingMode), false);
        tableEnvironment.registerCatalog("testCatalog", (Catalog)genericInMemoryCatalog);
        tableEnvironment.executeSql("CREATE VIEW testTable2 AS SELECT * FROM testCatalog.`default`.testTable");
        testUtil.verifyExecPlan("SELECT COUNT(*) FROM testTable2 GROUP BY TUMBLE(rowtime, INTERVAL '10' MINUTE)");
    }

    @Test
    public void testResolvingSchemaOfCustomCatalogTableTableApi() throws Exception {
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        GenericInMemoryCatalog genericInMemoryCatalog = new GenericInMemoryCatalog("in-memory");
        genericInMemoryCatalog.createTable(new ObjectPath("default", "testTable"), (CatalogBaseTable)new CustomCatalogTable(this.isStreamingMode), false);
        tableEnvironment.registerCatalog("testCatalog", (Catalog)genericInMemoryCatalog);
        Table table = tableEnvironment.from("testCatalog.`default`.testTable").window((GroupWindow)Tumble.over((Expression)((Expression)Expressions.lit((Object)10).minute())).on((Expression)Expressions.$((String)"rowtime")).as("w")).groupBy(new Expression[]{Expressions.$((String)"w")}).select(new Expression[]{(Expression)Expressions.lit((Object)1).count()});
        testUtil.verifyExecPlan(table);
    }

    @Test
    public void testResolvingProctimeOfCustomTableSql() throws Exception {
        if (!this.isStreamingMode) {
            return;
        }
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        GenericInMemoryCatalog genericInMemoryCatalog = new GenericInMemoryCatalog("in-memory");
        genericInMemoryCatalog.createTable(new ObjectPath("default", "testTable"), (CatalogBaseTable)new CustomCatalogTable(this.isStreamingMode), false);
        tableEnvironment.registerCatalog("testCatalog", (Catalog)genericInMemoryCatalog);
        testUtil.verifyExecPlan("SELECT COUNT(*) FROM testCatalog.`default`.testTable GROUP BY TUMBLE(proctime, INTERVAL '10' MINUTE)");
    }

    @Test
    public void testResolvingProctimeOfCustomTableTableApi() throws Exception {
        if (!this.isStreamingMode) {
            return;
        }
        TableTestUtil testUtil = this.getTestUtil();
        TableEnvironment tableEnvironment = testUtil.getTableEnv();
        GenericInMemoryCatalog genericInMemoryCatalog = new GenericInMemoryCatalog("in-memory");
        genericInMemoryCatalog.createTable(new ObjectPath("default", "testTable"), (CatalogBaseTable)new CustomCatalogTable(this.isStreamingMode), false);
        tableEnvironment.registerCatalog("testCatalog", (Catalog)genericInMemoryCatalog);
        Table table = tableEnvironment.from("testCatalog.`default`.testTable").window((GroupWindow)Tumble.over((Expression)((Expression)Expressions.lit((Object)10).minute())).on((Expression)Expressions.$((String)"proctime")).as("w")).groupBy(new Expression[]{Expressions.$((String)"w")}).select(new Expression[]{(Expression)Expressions.lit((Object)1).count()});
        testUtil.verifyExecPlan(table);
    }

    private static class CustomCatalogTable
    implements CatalogTable {
        private final boolean isStreamingMode;

        private CustomCatalogTable(boolean isStreamingMode) {
            this.isStreamingMode = isStreamingMode;
        }

        public boolean isPartitioned() {
            return false;
        }

        public List<String> getPartitionKeys() {
            return Collections.emptyList();
        }

        public CatalogTable copy(Map<String, String> options) {
            return this;
        }

        public Map<String, String> toProperties() {
            return Collections.emptyMap();
        }

        public Map<String, String> getOptions() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("connector", "values");
            map.put("bounded", Boolean.toString(!this.isStreamingMode));
            return map;
        }

        public TableSchema getSchema() {
            return TableSchema.builder().field("count", DataTypes.BIGINT()).field("rowtime", DataTypes.TIMESTAMP((int)3)).field("proctime", DataTypes.TIMESTAMP((int)3), "proctime()").watermark("rowtime", "rowtime - INTERVAL '5' SECONDS", DataTypes.TIMESTAMP()).build();
        }

        public String getComment() {
            return null;
        }

        public CatalogBaseTable copy() {
            return this;
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getDetailedDescription() {
            return Optional.empty();
        }
    }
}

