/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverter;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenTest$;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator$;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.WatermarkGenerator;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u0001=\u0011QdV1uKJl\u0017M]6HK:,'/\u0019;pe\u000e{G-Z$f]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tqaY8eK\u001e,gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002+U\u001cX\rR3gS:,GmQ8ogR\u0014Xo\u0019;peB\u0011\u0011#G\u0005\u00035I\u0011qAQ8pY\u0016\fg\u000eC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0003=\u0001\u0002\"a\b\u0001\u000e\u0003\tAQaF\u000eA\u0002aAqA\t\u0001C\u0002\u0013\u00051%\u0001\u0004d_:4\u0017nZ\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\u0011qEB\u0001\u0004CBL\u0017BA\u0015'\u0005-!\u0016M\u00197f\u0007>tg-[4\t\r-\u0002\u0001\u0015!\u0003%\u0003\u001d\u0019wN\u001c4jO\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0007n_\u0012,H.Z'b]\u0006<WM]\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\u0011!GB\u0001\u0007[>$W\u000f\\3\n\u0005Q\n$!D'pIVdW-T1oC\u001e,'\u000f\u0003\u00047\u0001\u0001\u0006IaL\u0001\u000f[>$W\u000f\\3NC:\fw-\u001a:!\u0011\u001dA\u0004A1A\u0005\u0002e\nabY1uC2|w-T1oC\u001e,'/F\u0001;!\tYd(D\u0001=\u0015\tid!A\u0004dCR\fGn\\4\n\u0005}b$AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001e\u0002\u001f\r\fG/\u00197pO6\u000bg.Y4fe\u0002Bqa\u0011\u0001C\u0002\u0013\u0005A)A\bgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h+\u0005)\u0005CA\u001eG\u0013\t9EHA\bGk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h\u0011\u0019I\u0005\u0001)A\u0005\u000b\u0006\u0001b-\u001e8di&|gnQ1uC2|w\r\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u00039\u0001H.\u00198oKJ\u001cuN\u001c;fqR,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0012\t!\u0002Z3mK\u001e\fG/[8o\u0013\t\u0011vJ\u0001\bQY\u0006tg.\u001a:D_:$X\r\u001f;\t\rQ\u0003\u0001\u0015!\u0003N\u0003=\u0001H.\u00198oKJ\u001cuN\u001c;fqR\u0004\u0003bB\u0003\u0001\u0005\u0004%\tAV\u000b\u0002/B\u0011\u0001lW\u0007\u00023*\u0011!\fB\u0001\bG\u0006d7-\u001b;f\u0013\ta\u0016L\u0001\tGY&t7\u000e\u00157b]:,'/S7qY\"1a\f\u0001Q\u0001\n]\u000b\u0001\u0002\u001d7b]:,'\u000f\t\u0005\u0006A\u0002!\tAV\u0001\u000bO\u0016$\b\u000b\\1o]\u0016\u0014\bb\u00022\u0001\u0005\u0004%\taY\u0001\u0005I\u0006$\u0018-F\u0001e!\r)'\u000e\\\u0007\u0002M*\u0011q\r[\u0001\nS6lW\u000f^1cY\u0016T!!\u001b\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002lM\n!A*[:u!\tiw.D\u0001o\u0015\t\u0011g!\u0003\u0002q]\nqq)\u001a8fe&\u001c'k\\<ECR\f\u0007B\u0002:\u0001A\u0003%A-A\u0003eCR\f\u0007\u0005C\u0003u\u0001\u0011\u0005Q/\u0001\fuKN$\u0018i]2f]\u0012LgnZ,bi\u0016\u0014X.\u0019:l)\u00051\bCA\tx\u0013\tA(C\u0001\u0003V]&$\bFA:{!\tYh0D\u0001}\u0015\tiH\"A\u0003kk:LG/\u0003\u0002\u0000y\n!A+Z:u\u0011\u0019\t\u0019\u0001\u0001C\u0001k\u0006qB/Z:u\u0005>,h\u000eZ3e\u001fV$xJZ(sI\u0016\u0014x+\u0019;fe6\f'o\u001b\u0015\u0004\u0003\u0003Q\bBBA\u0005\u0001\u0011\u0005Q/A\u000fuKN$H*Z4bGf\u001cUo\u001d;p[&TX\rZ,bi\u0016\u0014X.\u0019:lQ\r\t9A\u001f\u0005\u0007\u0003\u001f\u0001A\u0011A;\u0002/Q,7\u000f^\"vgR|W.\u001b>fI^\u000bG/\u001a:nCJ\\\u0007fAA\u0007u\"9\u0011q\u0002\u0001\u0005\n\u0005UAc\u0001<\u0002\u0018!9\u0011\u0011DA\n\u0001\u0004A\u0012\u0001C5t\u0019\u0016<\u0017mY=\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 \u0005Qr-\u001a8fe\u0006$XmV1uKJl\u0017M]6HK:,'/\u0019;peR1\u0011\u0011EA\u0019\u0003\u0017\u0002B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#A\u0005hK:,'/\u0019;fI*\u0019\u00111\u0006\u0004\u0002\u000fI,h\u000e^5nK&!\u0011qFA\u0013\u0005I9\u0016\r^3s[\u0006\u00148nR3oKJ\fGo\u001c:\t\u0011\u0005M\u00121\u0004a\u0001\u0003k\tA!\u001a=qeB!\u0011qGA#\u001d\u0011\tI$!\u0011\u0011\u0007\u0005m\"#\u0004\u0002\u0002>)\u0019\u0011q\b\b\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019EE\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r#\u0003\u0003\u0004\u0018\u00037\u0001\r\u0001\u0007\u0015\b\u0001\u0005=\u00131LA/!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+y\u00061!/\u001e8oKJLA!!\u0017\u0002T\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA0!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3y\u00069!/\u001e8oKJ\u001c\u0018\u0002BA5\u0003G\u0012Q\u0002U1sC6,G/\u001a:ju\u0016$waBA7\u0005!\u0005\u0011qN\u0001\u001e/\u0006$XM]7be.<UM\\3sCR|'oQ8eK\u001e+g\u000eV3tiB\u0019q$!\u001d\u0007\r\u0005\u0011\u0001\u0012AA:'\r\t\t\b\u0005\u0005\b9\u0005ED\u0011AA<)\t\ty\u0007\u0003\u0005\u0002|\u0005ED\u0011AA?\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0003\u0003\u007f\u0002R!!!\u0002\fbi!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\u0005kRLGN\u0003\u0002\u0002\n\u0006!!.\u0019<b\u0013\u0011\ti)a!\u0003\u0015\r{G\u000e\\3di&|g\u000e\u000b\u0005\u0002z\u0005E\u0015qTAQ!\u0011\t\u0019*!'\u000f\t\u0005\u0005\u0014QS\u0005\u0005\u0003/\u000b\u0019'A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u00037\u000biJ\u0001\u0006QCJ\fW.\u001a;feNTA!a&\u0002d\u0005!a.Y7fC\t\t\u0019+A\rvg\u0016$UMZ5oK\u0012\u001cuN\\:ueV\u001cGo\u001c:>wBj\b")
public class WatermarkGeneratorCodeGenTest {
    private final boolean useDefinedConstructor;
    private final TableConfig config;
    private final ModuleManager moduleManager;
    private final CatalogManager catalogManager;
    private final FunctionCatalog functionCatalog;
    private final PlannerContext plannerContext;
    private final FlinkPlannerImpl planner;
    private final List<GenericRowData> data;

    @Parameterized.Parameters(name="useDefinedConstructor={0}")
    public static Collection<Object> parameters() {
        return WatermarkGeneratorCodeGenTest$.MODULE$.parameters();
    }

    public TableConfig config() {
        return this.config;
    }

    public ModuleManager moduleManager() {
        return this.moduleManager;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    public PlannerContext plannerContext() {
        return this.plannerContext;
    }

    public FlinkPlannerImpl planner() {
        return this.planner;
    }

    public FlinkPlannerImpl getPlanner() {
        return this.planner();
    }

    public List<GenericRowData> data() {
        return this.data;
    }

    @Test
    public void testAscendingWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '0.001' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)999L, (List)new .colon.colon(null, (List)new .colon.colon((Object)2999L, (List)new .colon.colon((Object)4999L, (List)new .colon.colon((Object)3999L, (List)new .colon.colon((Object)5999L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
    }

    @Test
    public void testBoundedOutOfOrderWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '5' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)-4000L, (List)new .colon.colon(null, (List)new .colon.colon((Object)-2000L, (List)new .colon.colon((Object)0L, (List)new .colon.colon((Object)-1000L, (List)new .colon.colon((Object)1000L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
    }

    @Test
    public void testLegacyCustomizedWatermark() {
        this.testCustomizedWatermark(true);
    }

    @Test
    public void testCustomizedWatermark() {
        this.testCustomizedWatermark(false);
    }

    private void testCustomizedWatermark(boolean isLegacy) {
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        if (isLegacy) {
            this.functionCatalog().registerTempCatalogScalarFunction(ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"myFunc"), (ScalarFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        } else {
            this.functionCatalog().registerTemporaryCatalogFunction(UnresolvedIdentifier.of((String[])new String[]{CatalogManagerMocks.DEFAULT_CATALOG, CatalogManagerMocks.DEFAULT_DATABASE, "myFunc"}), (FunctionDefinition)new JavaUserDefinedScalarFunctions.JavaFunc5(), false);
        }
        WatermarkGenerator generator = this.generateWatermarkGenerator("myFunc(ts, `offset`)", this.useDefinedConstructor);
        if (!this.useDefinedConstructor) {
            generator.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 1));
        }
        generator.open(new Configuration());
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        generator.close();
        .colon.colon expected = new .colon.colon((Object)995L, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)4997L, (List)new .colon.colon((Object)3990L, (List)new .colon.colon((Object)5992L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
        Assert.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.openCalled);
        Assert.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled);
    }

    private WatermarkGenerator generateWatermarkGenerator(String expr, boolean useDefinedConstructor) {
        WatermarkGenerator watermarkGenerator;
        RelDataType tableRowType = this.plannerContext().getTypeFactory().buildRelNodeRowType((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "offset"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalType[]{new TimestampType(3), new IntType()})));
        RowType rowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(tableRowType);
        SqlExprToRexConverter converter = ((FlinkContext)this.planner().createToRelContext().getCluster().getPlanner().getContext().unwrap(FlinkContext.class)).getSqlExprToRexConverterFactory().create(tableRowType, null);
        RexNode rexNode = converter.convertToRexNode(expr);
        if (useDefinedConstructor) {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator(new TableConfig(), rowType, rexNode, Option$.MODULE$.apply((Object)"context"));
            Object[] newReferences = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(generated.getReferences())).$colon$plus((Object)new WatermarkGeneratorSupplier.Context(null){

                public MetricGroup getMetricGroup() {
                    return null;
                }
            }, ClassTag$.MODULE$.Object());
            watermarkGenerator = (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader(), new Object[]{newReferences});
        } else {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator(new TableConfig(), rowType, rexNode, WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator$default$4());
            watermarkGenerator = (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader());
        }
        return watermarkGenerator;
    }

    public WatermarkGeneratorCodeGenTest(boolean useDefinedConstructor) {
        this.useDefinedConstructor = useDefinedConstructor;
        this.config = new TableConfig();
        this.moduleManager = new ModuleManager();
        this.catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        this.functionCatalog = new FunctionCatalog((ReadableConfig)this.config(), this.catalogManager(), this.moduleManager());
        this.plannerContext = new PlannerContext(false, this.config(), this.moduleManager(), this.functionCatalog(), this.catalogManager(), CalciteSchemaBuilder.asRootSchema((Schema)new CatalogManagerCalciteSchema(this.catalogManager(), false)), Collections.singletonList(ConventionTraitDef.INSTANCE));
        this.planner = this.plannerContext().createFlinkPlanner(this.catalogManager().getCurrentCatalog(), this.catalogManager().getCurrentDatabase());
        this.data = new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)1000L), 5}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{null, 4}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)3000L), null}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)5000L), 3}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)4000L), 10}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)6000L), 8}), (List)Nil$.MODULE$))))));
    }
}

