/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.table.api.SqlParserEOFException;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class ParserImplTest {
    private final boolean isStreamingMode = false;
    private final TableConfig tableConfig = new TableConfig();
    private final Catalog catalog = new GenericInMemoryCatalog("MockCatalog", "default");
    private final CatalogManager catalogManager = CatalogManagerMocks.preparedCatalogManager().defaultCatalog("builtin", this.catalog).build();
    private final ModuleManager moduleManager = new ModuleManager();
    private final FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)this.tableConfig, this.catalogManager, this.moduleManager);
    private final PlannerContext plannerContext = new PlannerContext(true, this.tableConfig, this.moduleManager, this.functionCatalog, this.catalogManager, CalciteSchemaBuilder.asRootSchema((Schema)new CatalogManagerCalciteSchema(this.catalogManager, false)), new ArrayList());
    private final Supplier<FlinkPlannerImpl> plannerSupplier = () -> this.plannerContext.createFlinkPlanner(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase());
    private final Parser parser = new ParserImpl(this.catalogManager, this.plannerSupplier, () -> this.plannerSupplier.get().parser(), this.plannerContext.getSqlExprToRexConverterFactory());
    private static final List<TestSpec> TEST_SPECS = Arrays.asList(TestSpec.forStatement("ClEaR").summary("CLEAR"), TestSpec.forStatement("hElP").summary("HELP"), TestSpec.forStatement("qUIT").summary("QUIT"), TestSpec.forStatement("ExIT").summary("QUIT"), TestSpec.forStatement("REsEt").summary("RESET"), TestSpec.forStatement("REsEt execution.runtime-type").summary("RESET execution.runtime-type"), TestSpec.forStatement("   SEt ").summary("SET"), TestSpec.forStatement("SET execution.runtime-type=batch").summary("SET execution.runtime-type=batch"), TestSpec.forStatement("SET pipeline.jars = /path/to/test-_-jar.jar").summary("SET pipeline.jars=/path/to/test-_-jar.jar"), TestSpec.forStatement("USE test.db1").summary("USE test.db1"), TestSpec.forStatement("SHOW tables").summary("SHOW TABLES"), TestSpec.forStatement("SET pipeline.name = 'test name'").summary("SET pipeline.name=test name"), TestSpec.forStatement("SET pipeline.name = ' '").summary("SET pipeline.name= "), TestSpec.forStatement("SET execution.runtime-type=").error("SQL parse failed. Encountered \"execution\" at line 1, column 5"));

    @Test
    public void testParseLegalStatements() {
        for (TestSpec spec : TEST_SPECS) {
            if (spec.expectedSummary != null) {
                Operation op = (Operation)this.parser.parse(spec.statement).get(0);
                Assert.assertEquals((Object)spec.expectedSummary, (Object)op.asSummaryString());
            }
            if (spec.expectedError == null) continue;
            CommonTestUtils.assertThrows((String)spec.expectedError, SqlParserException.class, () -> this.parser.parse(spec.statement));
        }
    }

    @Test
    public void testPartialParse() {
        Assertions.assertThatThrownBy(() -> this.parser.parse("select A From")).isInstanceOf(SqlParserEOFException.class);
    }

    @Test
    public void testPartialParseWithStatementSet() {
        Assertions.assertThatThrownBy(() -> this.parser.parse("Execute Statement Set Begin insert into A select * from B")).isInstanceOf(SqlParserEOFException.class);
    }

    @Test
    public void testCompletionTest() {
        this.verifySqlCompletion("QU", 1, new String[]{"QUIT"});
        this.verifySqlCompletion("SE", 1, new String[]{"SET"});
        this.verifySqlCompletion("", 0, new String[]{"CLEAR", "HELP", "EXIT", "QUIT", "RESET", "SET"});
        this.verifySqlCompletion("SELECT a fram b", 10, new String[]{"FETCH", "FROM"});
    }

    private void verifySqlCompletion(String statement, int position, String[] expectedHints) {
        Object[] hints = this.parser.getCompletionHints(statement, position);
        Assert.assertArrayEquals((Object[])expectedHints, (Object[])hints);
    }

    static class TestSpec {
        private final String statement;
        @Nullable
        private String expectedSummary;
        @Nullable
        private String expectedError;

        private TestSpec(String statement) {
            this.statement = statement;
        }

        static TestSpec forStatement(String statement) {
            return new TestSpec(statement);
        }

        TestSpec summary(String expectedSummary) {
            this.expectedSummary = expectedSummary;
            return this;
        }

        TestSpec error(String expectedError) {
            this.expectedError = expectedError;
            return this;
        }
    }
}

