/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ScalarOperatorsTestBase;
import org.junit.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001\u001f\t\u00192kY1mCJ|\u0005/\u001a:bi>\u00148\u000fV3ti*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0002\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"aF*dC2\f'o\u00149fe\u0006$xN]:UKN$()Y:f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004uKN$\u0018J\u001c\u000b\u0002=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t!QK\\5uQ\tYR\u0005\u0005\u0002'S5\tqE\u0003\u0002)\u0019\u0005)!.\u001e8ji&\u0011!f\n\u0002\u0005)\u0016\u001cH\u000fC\u0003-\u0001\u0011\u0005Q$A\nuKN$8i\\7qCJ,w\n]3sCR|'\u000f\u000b\u0002,K!)q\u0006\u0001C\u0001;\u0005!B/Z:u\u001fRDWM]#yaJ,7o]5p]ND#AL\u0013\t\u000bI\u0002A\u0011A\u000f\u0002%Q,7\u000f^+oCJL\b\u000b\\;t\u001b&tWo\u001d\u0015\u0003c\u0015BQ!\u000e\u0001\u0005\u0002u\t1\u0005^3tiR+W\u000e]8sC2$\u0016\u0010]3FcV\fGn]*ue&tw\rT5uKJ\fG\u000e\u000b\u00025K!)\u0001\b\u0001C\u0001;\u0005\u0001C/Z:u)\u0016l\u0007o\u001c:bYRK\b/Z#rk\u0006d7o\u0015;sS:<G+\u001f9fQ\t9T\u0005C\u0003<\u0001\u0011\u0005Q$A\u0006uKN$HK]=DCN$\bF\u0001\u001e&\u0001")
public class ScalarOperatorsTest
extends ScalarOperatorsTestBase {
    @Test
    public void testIn() {
        this.testSqlApi("f2 IN (1, 2, 42)", "TRUE");
        this.testSqlApi("CAST (f0 AS DECIMAL) IN (42.0, 2.00, 3.01, 1.000000)", "TRUE");
        this.testSqlApi("f10 IN ('This is a test String.', 'String', 'Hello world', 'Comment#1')", "TRUE");
        this.testSqlApi("f14 IN ('This is a test String.', 'String', 'Hello world')", "NULL");
        this.testSqlApi("f15 IN (DATE '1996-11-10')", "TRUE");
        this.testSqlApi("f15 IN (DATE '1996-11-10', DATE '1996-11-11')", "TRUE");
        this.testSqlApi("f7 IN (f16, f17)", "TRUE");
    }

    @Test
    public void testCompareOperator() {
        this.testSqlApi("f18 > f19", "TRUE");
        this.testSqlApi("f18 >= f19", "TRUE");
        this.testSqlApi("f18 < f19", "FALSE");
        this.testSqlApi("f18 <= f19", "FALSE");
        this.testSqlApi("f18 = f18", "TRUE");
        this.testSqlApi("f19 < f20", "TRUE");
        this.testSqlApi("x'68656C6C6F20636F6465' < x'68656C6C6F2063617374'", "FALSE");
        this.testSqlApi("x'68656C6C6F20636F6465' > x'68656C6C6F2063617374'", "TRUE");
    }

    @Test
    public void testOtherExpressions() {
        this.testSqlApi("CASE WHEN f13.f1 IS NULL THEN 'a' ELSE 'b' END", "a");
        this.testSqlApi("CASE WHEN f13.f1 IS NOT NULL THEN 'a' ELSE 'b' END", "b");
        this.testSqlApi("f13 IS NULL", "FALSE");
        this.testSqlApi("f13 IS NOT NULL", "TRUE");
        this.testSqlApi("f13.f0 IS NULL", "FALSE");
        this.testSqlApi("f13.f0 IS NOT NULL", "TRUE");
        this.testSqlApi("f13.f1 IS NULL", "TRUE");
        this.testSqlApi("f13.f1 IS NOT NULL", "FALSE");
        this.testSqlApi("true", "TRUE");
        this.testSqlApi("fAlse", "FALSE");
        this.testSqlApi("tRuE", "TRUE");
        this.testSqlApi("CASE 11 WHEN 1 THEN 'a' ELSE 'b' END", "b");
        this.testSqlApi("CASE 2 WHEN 1 THEN 'a' ELSE 'b' END", "b");
        this.testSqlApi("CASE 1 WHEN 1, 2 THEN '1 or 2' WHEN 2 THEN 'not possible' WHEN 3, 2 THEN '3' ELSE 'none of the above' END", "1 or 2");
        this.testSqlApi("CASE 2 WHEN 1, 2 THEN '1 or 2' WHEN 2 THEN 'not possible' WHEN 3, 2 THEN '3' ELSE 'none of the above' END", "1 or 2");
        this.testSqlApi("CASE 3 WHEN 1, 2 THEN '1 or 2' WHEN 2 THEN 'not possible' WHEN 3, 2 THEN '3' ELSE 'none of the above' END", "3");
        this.testSqlApi("CASE 4 WHEN 1, 2 THEN '1 or 2' WHEN 2 THEN 'not possible' WHEN 3, 2 THEN '3' ELSE 'none of the above' END", "none of the above");
        this.testSqlApi("CASE WHEN 'a'='a' THEN 1 END", "1");
        this.testSqlApi("CASE 2 WHEN 1 THEN 'a' WHEN 2 THEN 'bcd' END", "bcd");
        this.testSqlApi("CASE 1 WHEN 1 THEN 'a' WHEN 2 THEN 'bcd' END", "a");
        this.testSqlApi("CASE f2 WHEN 1 THEN 11 WHEN 2 THEN 4 ELSE NULL END", "11");
        this.testSqlApi("CASE f7 WHEN 1 THEN 11 WHEN 2 THEN 4 ELSE NULL END", "NULL");
        this.testSqlApi("CASE 42 WHEN 1 THEN 'a' WHEN 2 THEN 'bcd' END", "NULL");
        this.testSqlApi("CASE 1 WHEN 1 THEN true WHEN 2 THEN false ELSE NULL END", "TRUE");
        this.testSqlApi("IF(true, TRY_CAST ('non-numeric' AS BIGINT), 0)", "NULL");
    }

    @Test
    public void testUnaryPlusMinus() {
        this.testSqlApi("-f0", "-1");
        this.testSqlApi("+f0", "1");
        this.testSqlApi("-f1", "-1");
        this.testSqlApi("+f1", "1");
        this.testSqlApi("-f2", "-1");
        this.testSqlApi("+f2", "1");
        this.testSqlApi("-f3", "-1");
        this.testSqlApi("+f3", "1");
        this.testSqlApi("-f4", "-1.0");
        this.testSqlApi("+f4", "1.0");
        this.testSqlApi("-f5", "-1.0");
        this.testSqlApi("+f5", "1.0");
        this.testSqlApi("-f17", "-10.0");
        this.testSqlApi("+f17", "10.0");
    }

    @Test
    public void testTemporalTypeEqualsStringLiteral() {
        this.testSqlApi("f15 = '1996-11-10'", "TRUE");
        this.testSqlApi("f15 = '1996-11-11'", "FALSE");
        this.testSqlApi("'1996-11-10' = f15", "TRUE");
        this.testSqlApi("'1996-11-11' = f15", "FALSE");
        this.testSqlApi("f21 = '12:34:56'", "TRUE");
        this.testSqlApi("f21 = '13:34:56'", "FALSE");
        this.testSqlApi("'12:34:56' = f21", "TRUE");
        this.testSqlApi("'13:34:56' = f21", "FALSE");
        this.testSqlApi("f22 = '1996-11-10 12:34:56'", "TRUE");
        this.testSqlApi("f22 = '1996-11-10 12:34:57'", "FALSE");
        this.testSqlApi("f22 = cast(null as string)", "NULL");
        this.testSqlApi("'1996-11-10 12:34:56' = f22", "TRUE");
        this.testSqlApi("'1996-11-10 12:34:57' = f22", "FALSE");
        this.testSqlApi("cast(null as string) = f22", "NULL");
    }

    @Test
    public void testTemporalTypeEqualsStringType() {
        this.testSqlApi("f15 = date_format(cast(f15 as timestamp), 'yyyy-MM-dd')", "TRUE");
        this.testSqlApi("f15 = date_format(cast(f15 as timestamp) + interval '1' day, 'yyyy-MM-dd')", "FALSE");
        this.testSqlApi("f15 = uuid()", "NULL");
        this.testSqlApi("date_format(cast(f15 as timestamp), 'yyyy-MM-dd') = f15", "TRUE");
        this.testSqlApi("date_format(cast(f15 as timestamp) + interval '1' day, 'yyyy-MM-dd') = f15", "FALSE");
        this.testSqlApi("uuid() = f15", "NULL");
        this.testSqlApi("f21 = date_format(cast(f21 as timestamp), 'HH:mm:ss')", "TRUE");
        this.testSqlApi("f21 = date_format(cast(f21 as timestamp) + interval '1' hour, 'HH:mm:ss')", "FALSE");
        this.testSqlApi("f21 = uuid()", "NULL");
        this.testSqlApi("date_format(cast(f21 as timestamp), 'HH:mm:ss') = f21", "TRUE");
        this.testSqlApi("date_format(cast(f21 as timestamp) + interval '1' hour, 'HH:mm:ss') = f21", "FALSE");
        this.testSqlApi("uuid() = f21", "NULL");
        this.testSqlApi("f22 = date_format(f22, 'yyyy-MM-dd HH:mm:ss')", "TRUE");
        this.testSqlApi("f22 = date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss')", "FALSE");
        this.testSqlApi("f22 = uuid()", "NULL");
        this.testSqlApi("date_format(f22, 'yyyy-MM-dd HH:mm:ss') = f22", "TRUE");
        this.testSqlApi("date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss') = f22", "FALSE");
        this.testSqlApi("uuid() = f22", "NULL");
        this.testSqlApi("cast(f22 as timestamp_ltz) = date_format(f22, 'yyyy-MM-dd HH:mm:ss')", "TRUE");
        this.testSqlApi("cast(f22 as timestamp_ltz) = date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss')", "FALSE");
        this.testSqlApi("cast(f22 as timestamp_ltz) = uuid()", "NULL");
        this.testSqlApi("date_format(f22, 'yyyy-MM-dd HH:mm:ss') = cast(f22 as timestamp_ltz)", "TRUE");
        this.testSqlApi("date_format(f22 + interval '1' second, 'yyyy-MM-dd HH:mm:ss') = cast(f22 as timestamp_ltz)", "FALSE");
        this.testSqlApi("uuid() = cast(f22 as timestamp_ltz)", "NULL");
    }

    @Test
    public void testTryCast() {
        this.testAllApis((Expression)package$.MODULE$.LiteralStringExpression("non-numeric").tryCast(DataTypes.BIGINT()), "TRY_CAST ('non-numeric' AS BIGINT)", "NULL");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f10")).tryCast(DataTypes.BIGINT()), "TRY_CAST (f10 AS BIGINT)", "NULL");
    }
}

