/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\t\t2+\u001d7FqB\u0014Xm]:j_:$Vm\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\t\u0019\"!A\u0003vi&d7/\u0003\u0002\u0016%\t\u0011R\t\u001f9sKN\u001c\u0018n\u001c8UKN$()Y:f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0003\u001d\u0001\u0011\u0005Q$A\fuKN$8i\\7qCJL7o\u001c8Gk:\u001cG/[8ogR\ta\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0003V]&$\bFA\u000e&!\t1\u0013&D\u0001(\u0015\tAC\"A\u0003kk:LG/\u0003\u0002+O\t!A+Z:u\u0011\u0015a\u0003\u0001\"\u0001\u001e\u0003Q!Xm\u001d;M_\u001eL7-\u00197Gk:\u001cG/[8og\"\u00121&\n\u0005\u0006_\u0001!\t!H\u0001\u0018i\u0016\u001cH/\u0011:ji\"lW\r^5d\rVt7\r^5p]ND#AL\u0013\t\u000bI\u0002A\u0011A\u000f\u0002'Q,7\u000f\u001e#jm&$WMR;oGRLwN\\:)\u0005E*\u0003\"B\u001b\u0001\t\u0003i\u0012a\u0005;fgR\u001cFO]5oO\u001a+hn\u0019;j_:\u001c\bF\u0001\u001b&\u0011\u0015A\u0004\u0001\"\u0001\u001e\u0003a!Xm\u001d;D_:$\u0017\u000e^5p]\u0006dg)\u001e8di&|gn\u001d\u0015\u0003o\u0015BQa\u000f\u0001\u0005\u0002u\t1\u0004^3tiRK\b/Z\"p]Z,'o]5p]\u001a+hn\u0019;j_:\u001c\bF\u0001\u001e&\u0011\u0015q\u0004\u0001\"\u0001\u001e\u0003u!Xm\u001d;WC2,XmQ8ogR\u0014Xo\u0019;pe\u001a+hn\u0019;j_:\u001c\bFA\u001f&\u0011\u0015\t\u0005\u0001\"\u0001\u001e\u0003U!Xm\u001d;ECR,G+[7f\rVt7\r^5p]ND#\u0001Q\u0013\t\u000b\u0011\u0003A\u0011A\u000f\u0002%Q,7\u000f^!se\u0006Lh)\u001e8di&|gn\u001d\u0015\u0003\u0007\u0016BQa\u0012\u0001\u0005\u0002u\t\u0011\u0003^3ti\"\u000b7\u000f\u001b$v]\u000e$\u0018n\u001c8tQ\t1U\u0005C\u0003K\u0001\u0011\u0005Q$A\tuKN$h*\u001e7mC\ndWmQ1tKND#!S\u0013\t\u000b5\u0003A\u0011\t(\u0002\u0011Q,7\u000f\u001e#bi\u0006,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%\"\tQ\u0001^=qKNL!\u0001V)\u0003\u0007I{w\u000fC\u0003W\u0001\u0011\u0005s+\u0001\u0005usB,\u0017J\u001c4p+\u0005A\u0006CA-a\u001b\u0005Q&BA.]\u0003%!\u0018\u0010]3vi&d7O\u0003\u0002^=\u0006!!.\u0019<b\u0015\ty\u0006\"A\u0002ba&L!!\u0019.\u0003\u0017I{w\u000fV=qK&sgm\u001c")
public class SqlExpressionTest
extends ExpressionTestBase {
    @Test
    public void testComparisonFunctions() {
        this.testSqlApi("1 = 1", "TRUE");
        this.testSqlApi("1 <> 1", "FALSE");
        this.testSqlApi("5 > 2", "TRUE");
        this.testSqlApi("2 >= 2", "TRUE");
        this.testSqlApi("5 < 2", "FALSE");
        this.testSqlApi("2 <= 2", "TRUE");
        this.testSqlApi("x'0c' <= x'0b'", "FALSE");
        this.testSqlApi("x'0c' > x'0b'", "TRUE");
        this.testSqlApi("x'0c' = x'0c'", "TRUE");
        this.testSqlApi("x'0c' <> x'0c'", "FALSE");
        this.testSqlApi("1 IS NULL", "FALSE");
        this.testSqlApi("1 IS NOT NULL", "TRUE");
        this.testSqlApi("NULLIF(1,1) IS DISTINCT FROM NULLIF(1,1)", "FALSE");
        this.testSqlApi("NULLIF(1,1) IS NOT DISTINCT FROM NULLIF(1,1)", "TRUE");
        this.testSqlApi("NULLIF(1,1) IS NOT DISTINCT FROM NULLIF(1,1)", "TRUE");
        this.testSqlApi("12 BETWEEN 11 AND 13", "TRUE");
        this.testSqlApi("12 BETWEEN ASYMMETRIC 13 AND 11", "FALSE");
        this.testSqlApi("12 BETWEEN SYMMETRIC 13 AND 11", "TRUE");
        this.testSqlApi("12 NOT BETWEEN 11 AND 13", "FALSE");
        this.testSqlApi("12 NOT BETWEEN ASYMMETRIC 13 AND 11", "TRUE");
        this.testSqlApi("12 NOT BETWEEN SYMMETRIC 13 AND 11", "FALSE");
        this.testSqlApi("'TEST' LIKE '%EST'", "TRUE");
        this.testSqlApi("'%EST' LIKE '.%EST' ESCAPE '.'", "TRUE");
        this.testSqlApi("'TEST' NOT LIKE '%EST'", "FALSE");
        this.testSqlApi("'%EST' NOT LIKE '.%EST' ESCAPE '.'", "FALSE");
        this.testSqlApi("'TEST' SIMILAR TO '.EST'", "TRUE");
        this.testSqlApi("'TEST' NOT SIMILAR TO '.EST'", "FALSE");
        this.testSqlApi("'TEST' IN ('west', 'TEST', 'rest')", "TRUE");
        this.testSqlApi("'TEST' IN ('west', 'rest')", "FALSE");
        this.testSqlApi("'TEST' NOT IN ('west', 'TEST', 'rest')", "FALSE");
        this.testSqlApi("'TEST' NOT IN ('west', 'rest')", "TRUE");
    }

    @Test
    public void testLogicalFunctions() {
        this.testSqlApi("TRUE OR FALSE", "TRUE");
        this.testSqlApi("TRUE AND FALSE", "FALSE");
        this.testSqlApi("NOT TRUE", "FALSE");
        this.testSqlApi("TRUE IS FALSE", "FALSE");
        this.testSqlApi("TRUE IS NOT FALSE", "TRUE");
        this.testSqlApi("TRUE IS TRUE", "TRUE");
        this.testSqlApi("TRUE IS NOT TRUE", "FALSE");
        this.testSqlApi("NULLIF(TRUE,TRUE) IS UNKNOWN", "TRUE");
        this.testSqlApi("NULLIF(TRUE,TRUE) IS NOT UNKNOWN", "FALSE");
    }

    @Test
    public void testArithmeticFunctions() {
        this.testSqlApi("+5", "5");
        this.testSqlApi("-5", "-5");
        this.testSqlApi("5+5", "10");
        this.testSqlApi("5-5", "0");
        this.testSqlApi("5*5", "25");
        this.testSqlApi("5/5", "1");
        this.testSqlApi("5%2", "1");
        this.testSqlApi("POWER(5, 5)", "3125.0");
        this.testSqlApi("ABS(-5)", "5");
        this.testSqlApi("MOD(-26, 5)", "-1");
        this.testSqlApi("SQRT(4)", "2.0");
        this.testSqlApi("LN(1)", "0.0");
        this.testSqlApi("LOG10(1)", "0.0");
        this.testSqlApi("EXP(0)", "1.0");
        this.testSqlApi("CEIL(2.5)", "3");
        this.testSqlApi("CEILING(2.5)", "3");
        this.testSqlApi("FLOOR(2.5)", "2");
        this.testSqlApi("SIN(2.5)", "0.5984721441039564");
        this.testSqlApi("SINH(2.5)", "6.0502044810397875");
        this.testSqlApi("COS(2.5)", "-0.8011436155469337");
        this.testSqlApi("TAN(2.5)", "-0.7470222972386603");
        this.testSqlApi("COT(2.5)", "-1.3386481283041514");
        this.testSqlApi("ASIN(0.5)", "0.5235987755982989");
        this.testSqlApi("ACOS(0.5)", "1.0471975511965979");
        this.testSqlApi("ATAN(0.5)", "0.4636476090008061");
        this.testSqlApi("ATAN2(0.5, 0.5)", "0.7853981633974483");
        this.testSqlApi("COSH(2.5)", "6.132289479663686");
        this.testSqlApi("TANH(2.5)", "0.9866142981514303");
        this.testSqlApi("DEGREES(0.5)", "28.64788975654116");
        this.testSqlApi("RADIANS(0.5)", "0.008726646259971648");
        this.testSqlApi("SIGN(-1.1)", "-1.0");
        this.testSqlApi("ROUND(-12.345, 2)", "-12.35");
        this.testSqlApi("PI()", "3.141592653589793");
        this.testSqlApi("E()", "2.718281828459045");
        this.testSqlApi("truncate(42.345)", "42");
        this.testSqlApi("truncate(cast(42.345 as decimal(5, 3)), 2)", "42.34");
    }

    @Test
    public void testDivideFunctions() {
        this.testSqlApi("1.0/8.0", "0.125000");
        this.testSqlApi("2.0/3.0", "0.666667");
        this.testSqlApi("-2/3.0", "-0.666667");
        this.testSqlApi("2.0/(-3)", "-0.666666666667");
        this.testSqlApi("-7.9/2", "-3.950000000000");
        String divisorZeroException = "Division by zero";
        this.testExpectedSqlException("1/cast(0.00 as decimal)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0.00 as double)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0.00 as float)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0 as tinyint)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0 as smallint)", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/0", divisorZeroException, ArithmeticException.class);
        this.testExpectedSqlException("1/cast(0 as bigint)", divisorZeroException, ArithmeticException.class);
    }

    @Test
    public void testStringFunctions() {
        this.testSqlApi("'test' || 'string'", "teststring");
        this.testSqlApi("CHAR_LENGTH('string')", "6");
        this.testSqlApi("CHARACTER_LENGTH('string')", "6");
        this.testSqlApi("UPPER('string')", "STRING");
        this.testSqlApi("LOWER('STRING')", "string");
        this.testSqlApi("POSITION('STR' IN 'STRING')", "1");
        this.testSqlApi("TRIM(BOTH ' STRING ')", "STRING");
        this.testSqlApi("TRIM(LEADING 'x' FROM 'xxxxSTRINGxxxx')", "STRINGxxxx");
        this.testSqlApi("TRIM(TRAILING 'x' FROM 'xxxxSTRINGxxxx')", "xxxxSTRING");
        this.testSqlApi("OVERLAY('This is a old string' PLACING 'new' FROM 11 FOR 3)", "This is a new string");
        this.testSqlApi("SUBSTRING('hello world', 2)", "ello world");
        this.testSqlApi("SUBSTRING('hello world', 2, 3)", "ell");
        this.testSqlApi("SUBSTRING('hello world', 2, 300)", "ello world");
        this.testSqlApi("SUBSTR('hello world', 2, 3)", "ell");
        this.testSqlApi("SUBSTR('hello world', 2)", "ello world");
        this.testSqlApi("SUBSTR('hello world', 2, 300)", "ello world");
        this.testSqlApi("SUBSTR('hello world', 0, 3)", "hel");
        this.testSqlApi("INITCAP('hello world')", "Hello World");
        this.testSqlApi("REGEXP_REPLACE('foobar', 'oo|ar', '')", "fb");
        this.testSqlApi("REGEXP_EXTRACT('foothebar', 'foo(.*?)(bar)', 2)", "bar");
        this.testSqlApi("REPEAT('This is a test String.', 2)", "This is a test String.This is a test String.");
        this.testSqlApi("REPLACE('hello world', 'world', 'flink')", "hello flink");
    }

    @Test
    public void testConditionalFunctions() {
        this.testSqlApi("CASE 2 WHEN 1, 2 THEN 2 ELSE 3 END", "2");
        this.testSqlApi("CASE WHEN 1 = 2 THEN 2 WHEN 1 = 1 THEN 3 ELSE 3 END", "3");
        this.testSqlApi("NULLIF(1, 1)", "NULL");
        this.testSqlApi("COALESCE(NULL, 5)", "5");
    }

    @Test
    public void testTypeConversionFunctions() {
        this.testSqlApi("CAST(2 AS DOUBLE)", "2.0");
    }

    @Test
    public void testValueConstructorFunctions() {
        this.testSqlApi("ROW('hello world', 12)", "(hello world, 12)");
        this.testSqlApi("('hello world', 12)", "(hello world, 12)");
        this.testSqlApi("('foo', ('bar', 12))", "(foo, (bar, 12))");
        this.testSqlApi("ARRAY[TRUE, FALSE][2]", "FALSE");
        this.testSqlApi("ARRAY[TRUE, TRUE]", "[TRUE, TRUE]");
        this.testSqlApi("MAP['k1', 'v1', 'k2', 'v2']['k2']", "v2");
        this.testSqlApi("MAP['k1', CAST(true AS VARCHAR(256)), 'k2', 'foo']['k1']", "TRUE");
    }

    @Test
    public void testDateTimeFunctions() {
        this.testSqlApi("DATE '1990-10-14'", "1990-10-14");
        this.testSqlApi("TIME '12:12:12'", "12:12:12");
        this.testSqlApi("TIMESTAMP '1990-10-14 12:12:12.123'", "1990-10-14 12:12:12.123");
        this.testSqlApi("INTERVAL '10 00:00:00.004' DAY TO SECOND", "+10 00:00:00.004");
        this.testSqlApi("INTERVAL '10 00:12' DAY TO MINUTE", "+10 00:12:00.000");
        this.testSqlApi("INTERVAL '2-10' YEAR TO MONTH", "+2-10");
        this.testSqlApi("EXTRACT(DAY FROM DATE '1990-12-01')", "1");
        this.testSqlApi("EXTRACT(DAY FROM INTERVAL '19 12:10:10.123' DAY TO SECOND(3))", "19");
        this.testSqlApi("FLOOR(TIME '12:44:31' TO MINUTE)", "12:44:00");
        this.testSqlApi("CEIL(TIME '12:44:31' TO MINUTE)", "12:45:00");
        this.testSqlApi("QUARTER(DATE '2016-04-12')", "2");
        this.testSqlApi("(TIME '2:55:00', INTERVAL '1' HOUR) OVERLAPS (TIME '3:30:00', INTERVAL '2' HOUR)", "TRUE");
    }

    @Test
    public void testArrayFunctions() {
        this.testSqlApi("CARDINALITY(ARRAY[TRUE, TRUE, FALSE])", "3");
        this.testSqlApi("ELEMENT(ARRAY['HELLO WORLD'])", "HELLO WORLD");
    }

    @Test
    public void testHashFunctions() {
        this.testSqlApi("MD5('')", "d41d8cd98f00b204e9800998ecf8427e");
        this.testSqlApi("MD5('test')", "098f6bcd4621d373cade4e832627b4f6");
        this.testSqlApi("SHA1('')", "da39a3ee5e6b4b0d3255bfef95601890afd80709");
        this.testSqlApi("SHA1('test')", "a94a8fe5ccb19ba61c4c0873d391e987982fbbd3");
        this.testSqlApi("SHA224('')", "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f");
        this.testSqlApi("SHA2('', 224)", "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f");
        this.testSqlApi("SHA224('test')", "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809");
        this.testSqlApi("SHA2('test', 224)", "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809");
        this.testSqlApi("SHA256('')", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        this.testSqlApi("SHA2('', 256)", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        this.testSqlApi("SHA256('test')", "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08");
        this.testSqlApi("SHA2('test', 256)", "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08");
        this.testSqlApi("SHA384('')", "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b");
        this.testSqlApi("SHA2('', 384)", "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b");
        this.testSqlApi("SHA384('test')", "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9");
        this.testSqlApi("SHA2('test', 384)", "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9");
        this.testSqlApi("SHA512('')", "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e");
        this.testSqlApi("SHA2('',512)", "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e");
        this.testSqlApi("SHA512('test')", "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff");
        this.testSqlApi("SHA2('test',512)", "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff");
        this.testSqlApi("MD5(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA1(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA224(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA256(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA384(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA512(CAST(NULL AS VARCHAR))", "NULL");
        this.testSqlApi("SHA2(CAST(NULL AS VARCHAR), 256)", "NULL");
    }

    @Test
    public void testNullableCases() {
        this.testSqlApi("TO_BASE64(FROM_BASE64(cast(NUll as varchar)))", this.nullable());
        this.testSqlApi("FROM_BASE64(cast(NUll as varchar))", this.nullable());
    }

    @Override
    public Row testData() {
        return new Row(0);
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo(new TypeInformation[0]);
    }
}

