/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Arrays;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.plan.metadata.MetadataTestUtil;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionConverterTest {
    private final TableConfig tableConfig = new TableConfig();
    private final CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
    private final ModuleManager moduleManager = new ModuleManager();
    private final PlannerContext plannerContext = new PlannerContext(false, this.tableConfig, this.moduleManager, new FunctionCatalog((ReadableConfig)this.tableConfig, this.catalogManager, this.moduleManager), this.catalogManager, CalciteSchema.from((SchemaPlus)MetadataTestUtil.initRootSchema()), Arrays.asList(ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef.INSTANCE(), RelCollationTraitDef.INSTANCE));
    private final ExpressionConverter converter = new ExpressionConverter((RelBuilder)this.plannerContext.createRelBuilder(CatalogManagerMocks.DEFAULT_CATALOG, CatalogManagerMocks.DEFAULT_DATABASE));

    @Test
    public void testLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)1));
        Assert.assertEquals((long)1L, (long)((Integer)((RexLiteral)rex).getValueAs(Integer.class)).intValue());
        Assert.assertEquals((Object)SqlTypeName.TINYINT, (Object)rex.getType().getSqlTypeName());
        rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)1));
        Assert.assertEquals((long)1L, (long)((Integer)((RexLiteral)rex).getValueAs(Integer.class)).intValue());
        Assert.assertEquals((Object)SqlTypeName.SMALLINT, (Object)rex.getType().getSqlTypeName());
        rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)1));
        Assert.assertEquals((long)1L, (long)((Integer)((RexLiteral)rex).getValueAs(Integer.class)).intValue());
        Assert.assertEquals((Object)SqlTypeName.INTEGER, (Object)rex.getType().getSqlTypeName());
    }

    @Test
    public void testCharLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)"ABC", (DataType)((DataType)DataTypes.CHAR((int)4).notNull())));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(String.class), (Matcher)CoreMatchers.equalTo((Object)"ABC "));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.CHAR));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testVarCharLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)"ABC", (DataType)((DataType)DataTypes.STRING().notNull())));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(String.class), (Matcher)CoreMatchers.equalTo((Object)"ABC"));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.VARCHAR));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)Integer.MAX_VALUE));
    }

    @Test
    public void testBinaryLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)new byte[]{1, 2, 3}, (DataType)((DataType)DataTypes.BINARY((int)4).notNull())));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(byte[].class), (Matcher)CoreMatchers.equalTo((Object)new byte[]{1, 2, 3, 0}));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.BINARY));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testTimestampLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)LocalDateTime.parse("2012-12-12T12:12:12.12345"), (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull())));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(TimestampString.class), (Matcher)CoreMatchers.equalTo((Object)new TimestampString("2012-12-12 12:12:12.123")));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.TIMESTAMP));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testTimestampWithLocalZoneLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)Instant.ofEpochMilli(100L), (DataType)((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull())));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(TimestampString.class), (Matcher)CoreMatchers.equalTo((Object)TimestampString.fromMillisSinceEpoch((long)100L)));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testTimeLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)LocalTime.parse("12:12:12.12345"), (DataType)((DataType)DataTypes.TIME((int)2).notNull())));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(TimeString.class), (Matcher)CoreMatchers.equalTo((Object)new TimeString("12:12:12.12")));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.TIME));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testTimeLiteralBiggerPrecision() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)LocalTime.parse("12:12:12.12345"), (DataType)((DataType)DataTypes.TIME((int)5).notNull())));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(TimeString.class), (Matcher)CoreMatchers.equalTo((Object)new TimeString("12:12:12.123")));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.TIME));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testDateLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)LocalDate.parse("2012-12-12"), (DataType)((DataType)DataTypes.DATE().notNull())));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(DateString.class), (Matcher)CoreMatchers.equalTo((Object)new DateString("2012-12-12")));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.DATE));
    }

    @Test
    public void testIntervalDayTime() {
        Duration value = Duration.ofDays(3L).plusMillis(21L);
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)value));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(BigDecimal.class), (Matcher)CoreMatchers.equalTo((Object)BigDecimal.valueOf(value.toMillis())));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.INTERVAL_DAY_SECOND));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)rex.getType().getScale(), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void testIntervalYearMonth() {
        Period value = Period.of(999, 3, 1);
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)value));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(BigDecimal.class), (Matcher)CoreMatchers.equalTo((Object)BigDecimal.valueOf(value.toTotalMonths())));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.INTERVAL_YEAR_MONTH));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testDecimalLiteral() {
        BigDecimal value = new BigDecimal("12345678.999");
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)value));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(BigDecimal.class), (Matcher)CoreMatchers.equalTo((Object)value));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.DECIMAL));
        Assert.assertThat((Object)rex.getType().getPrecision(), (Matcher)CoreMatchers.equalTo((Object)11));
        Assert.assertThat((Object)rex.getType().getScale(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testSymbolLiteral() {
        RexNode rex = this.converter.visit(ApiExpressionUtils.valueLiteral((Object)TimePointUnit.MICROSECOND));
        Assert.assertThat((Object)((RexLiteral)rex).getValueAs(TimeUnit.class), (Matcher)CoreMatchers.equalTo((Object)TimeUnit.MICROSECOND));
        Assert.assertThat((Object)rex.getType().getSqlTypeName(), (Matcher)CoreMatchers.equalTo((Object)SqlTypeName.SYMBOL));
    }
}

