/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.planner.expressions.utils.ScalarTypesTestBase;
import org.junit.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001E\u0011QdU2bY\u0006\u0014h)\u001e8di&|gn\u001d,bY&$\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t!B^1mS\u0012\fG/[8o\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0006kRLGn]\u0005\u0003/Q\u00111cU2bY\u0006\u0014H+\u001f9fgR+7\u000f\u001e\"bg\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000by\u0001A\u0011A\u0010\u0002\u001fQ,7\u000f^%om\u0006d\u0017\u000e\u001a\"j]F\"\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0005+:LG\u000f\u000b\u0003\u001eO5r\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u000f\u0003\u0015QWO\\5u\u0013\ta\u0013F\u0001\u0003UKN$\u0018\u0001C3ya\u0016\u001cG/\u001a3$\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u00025c\t\u0019b+\u00197jI\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\")a\u0007\u0001C\u0001?\u0005yA/Z:u\u0013:4\u0018\r\\5e\u0005&t'\u0007\u000b\u00036O5r\u0003\"B\u001d\u0001\t\u0003y\u0012a\u0004;fgRLeN^1mS\u0012\u0014\u0015N\\\u001a)\ta:SF\f\u0005\u0006y\u0001!\taH\u0001\u0015i\u0016\u001cH/\u00138wC2LG\r\u0016:v]\u000e\fG/Z\u0019)\tm:SF\f\u0005\u0006\u007f\u0001!\taH\u0001\u0015i\u0016\u001cH/\u00138wC2LG\r\u0016:v]\u000e\fG/\u001a\u001a)\u0005y:\u0003\"\u0002\"\u0001\t\u0003y\u0012!\u0006;fgRLeN^1mS\u0012\u001cVOY:ue&tw-\r\u0015\u0005\u0003\u001ejc\u0006C\u0003F\u0001\u0011\u0005q$A\u000buKN$\u0018J\u001c<bY&$7+\u001e2tiJLgn\u001a\u001a)\t\u0011;SF\f\u0005\u0006\u0011\u0002!\taH\u0001+i\u0016\u001cH\u000fV5nKN$\u0018-\u001c9BI\u0012<\u0016\u000e\u001e5Xe>tw\rV5nKN$\u0018-\u001c9J]R,'O^1mQ\u00119u%\f&$\u0003-\u0003\"\u0001\r'\n\u00055\u000b$AE*rYB\u000b'o]3s\u000bb\u001cW\r\u001d;j_:DQa\u0014\u0001\u0005\u0002}\t\u0001\u0006^3tiRKW.Z:uC6\u0004\u0018\t\u001a3XSRDwK]8oORKW.Z:uC6\u0004hi\u001c:nCRDCAT\u0014.\u0015\")!\u000b\u0001C\u0001?\u0005\tC/Z:u)&lWm\u001d;b[B\fE\rZ,ji\"<&o\u001c8h#V\fg\u000e^5us\"\"\u0011kJ\u0017/\u0011\u0015)\u0006\u0001\"\u0001 \u0003%\"Xm\u001d;J]Z\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8N_J,G\u000b[1o\u001f:,G+\u001f9fg\"\"AkJ\u0017/\u0011\u0015A\u0006\u0001\"\u0001 \u0003=\u001a8-\u00197b\u0013:4\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8o\t&4g-\u001a:f]R|\u0005/\u001a:b]\u0012\u001cH+Z:uQ\u00119v%\f\u0018\t\u000bm\u0003A\u0011A\u0010\u0002])\fg/Y%o-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c#jM\u001a,'/\u001a8u\u001fB,'/\u00198egR+7\u000f\u001e\u0015\u00055\u001ejc\u0006C\u0003_\u0001\u0011\u0005q$\u0001\u0010uKN$H+[7fgR\fW\u000e\u001d#jM\u001a<\u0016\u000e\u001e5Xe>tw\rV5nK\"\"QlJ\u0017/\u0011\u0015\t\u0007\u0001\"\u0001 \u0003\u0015\"Xm\u001d;US6,7\u000f^1na\u0012KgMZ,ji\"<&o\u001c8h)&lW-\u00118e+:LG\u000f\u000b\u0003aO5r\u0003\"\u00023\u0001\t\u0003y\u0012!\t;fgR$ujV,ji\"$\u0016.\\3XQ&\u001c\u0007.S:V]N,\b\u000f]8si\u0016$\u0007FA2(\u0011\u00159\u0007\u0001\"\u0001 \u0003\u0005\"Xm\u001d;E\u001ff;\u0016\u000e\u001e5US6,w\u000b[5dQ&\u001bXK\\:vaB|'\u000f^3eQ\t1w\u0005C\u0003k\u0001\u0011\u0005q$\u0001\u0013uKN$\u0018jU(E\u001f^;\u0016\u000e\u001e5US6,w\u000b[5dQ&\u001bXK\\:vaB|'\u000f^3eQ\tIw\u0005C\u0003n\u0001\u0011\u0005q$A\u0013uKN$\u0018jU(Z\u000b\u0006\u0013v+\u001b;i)&lWm\u00165jG\"L5/\u00168tkB\u0004xN\u001d;fI\"\u0012An\n\u0005\u0006a\u0002!I!]\u0001\u001ei\u0016\u001cH/\u0012=ue\u0006\u001cGO\u0012:p[RKW.\u001a.fe>\u0014Vm];miR\u0011\u0001E\u001d\u0005\u0006g>\u0004\r\u0001^\u0001\u0005k:LG\u000f\u0005\u0002vy6\taO\u0003\u0002xq\u0006!Q\u000f^5m\u0015\tI(0A\u0004bm\u0006$\u0018nY1\u000b\u0005md\u0011aB2bY\u000eLG/Z\u0005\u0003{Z\u0014\u0001\u0002V5nKVs\u0017\u000e\u001e\u0005\u0006\u007f\u0002!\taH\u0001\u0017i\u0016\u001cH/T5mY\u0016tg.[;n/&$\b\u000eV5nK\"\u0012ap\n\u0005\u0007\u0003\u000b\u0001A\u0011A\u0010\u0002'Q,7\u000f^\"f]R,(/_,ji\"$\u0016.\\3)\u0007\u0005\rq\u0005\u0003\u0004\u0002\f\u0001!\taH\u0001\u0013i\u0016\u001cH\u000fR3dC\u0012,w+\u001b;i)&lW\rK\u0002\u0002\n\u001dBa!!\u0005\u0001\t\u0003y\u0012\u0001\u0005;fgRLV-\u0019:XSRDG+[7fQ\r\tya\n\u0005\u0007\u0003/\u0001A\u0011A\u0010\u0002#Q,7\u000f^'p]RDw+\u001b;i)&lW\rK\u0002\u0002\u0016\u001dBa!!\b\u0001\t\u0003y\u0012a\u0004;fgR$\u0015-_,ji\"$\u0016.\\3)\u0007\u0005mq\u0005\u0003\u0004\u0002$\u0001!\taH\u0001\u0017i\u0016\u001cH/\u00138wC2LGm\u0015;sS:<Gk\\'ba\"\u001a\u0011\u0011E\u0014\t\r\u0005%\u0002\u0001\"\u0001 \u00035!Xm\u001d;J]Z\fG.\u001b3JM\"\u001a\u0011qE\u0014\t\r\u0005=\u0002\u0001\"\u0001 \u0003M!Xm\u001d;J]Z\fG.\u001b3U_\n\u000b7/\u001a\u001c5Q\r\tic\n")
public class ScalarFunctionsValidationTest
extends ScalarTypesTestBase {
    @Test(expected=ValidationException.class)
    public void testInvalidBin1() {
        this.testSqlApi("BIN(f12)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidBin2() {
        this.testSqlApi("BIN(f15)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidBin3() {
        this.testSqlApi("BIN(f16)", "101010");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidTruncate1() {
        this.testSqlApi("TRUNCATE('abc', 'def')", "FAIL");
        this.testSqlApi("TRUNCATE(f12, f0)", "FAIL");
        this.testSqlApi("TRUNCATE(f12,f12)", "FAIL");
        this.testSqlApi("TRUNCATE(f12, cast(f28 as DOUBLE))", "FAIL");
        this.testSqlApi("TRUNCATE(f12,f15)", "FAIL");
    }

    @Test
    public void testInvalidTruncate2() {
        this.thrown().expect(ValidationException.class);
        this.testSqlApi("TRUNCATE('abc')", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidSubstring1() {
        this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring((Object)package$.MODULE$.LiteralDoubleExpression(2.0).toExpr()), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidSubstring2() {
        this.testTableApi((Expression)package$.MODULE$.LiteralStringExpression("test").substring((Object)package$.MODULE$.LiteralStringExpression("test").toExpr()), "FAIL", "FAIL");
    }

    @Test(expected=SqlParserException.class)
    public void testTimestampAddWithWrongTimestampInterval() {
        this.testSqlApi("TIMESTAMPADD(XXX, 1, timestamp '2016-02-24'))", "2016-06-16");
    }

    @Test(expected=SqlParserException.class)
    public void testTimestampAddWithWrongTimestampFormat() {
        this.testSqlApi("TIMESTAMPADD(YEAR, 1, timestamp '2016-02-24'))", "2016-06-16");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampAddWithWrongQuantity() {
        this.testSqlApi("TIMESTAMPADD(YEAR, 1.0, timestamp '2016-02-24 12:42:25')", "2016-06-16");
    }

    @Test(expected=ValidationException.class)
    public void testInValidationExceptionMoreThanOneTypes() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).in((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f8"))}), "f2.in(f3, f8)", "TRUE");
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).in((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.int2Literal(4)}), "f2.in(f3, f4, 4)", "FALSE");
    }

    @Test(expected=ValidationException.class)
    public void scalaInValidationExceptionDifferentOperandsTest() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).in((Object[])new Expression[]{package$.MODULE$.string2Literal("Hi"), package$.MODULE$.string2Literal("Hello world"), package$.MODULE$.string2Literal("Comment#1")}), "true", "TRUE");
    }

    @Test(expected=ValidationException.class)
    public void javaInValidationExceptionDifferentOperandsTest() {
        this.testTableApi(package$.MODULE$.boolean2Literal(true), "f1.in('Hi','Hello world','Comment#1')", "TRUE");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampDiffWithWrongTime() {
        this.testTableApi(package$.MODULE$.timestampDiff(TimePointUnit.DAY, package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testTimestampDiffWithWrongTimeAndUnit() {
        this.testTableApi(package$.MODULE$.timestampDiff(TimePointUnit.MINUTE, package$.MODULE$.string2Literal("2016-02-24"), package$.MODULE$.string2Literal("2016-02-27")), "FAIL", "FAIL");
    }

    @Test
    public void testDOWWithTimeWhichIsUnsupported() {
        this.thrown().expect(ValidationException.class);
        this.testSqlApi("EXTRACT(DOW FROM TIME '12:42:25')", "0");
    }

    @Test
    public void testDOYWithTimeWhichIsUnsupported() {
        this.thrown().expect(ValidationException.class);
        this.testSqlApi("EXTRACT(DOY FROM TIME '12:42:25')", "0");
    }

    @Test
    public void testISODOWWithTimeWhichIsUnsupported() {
        this.thrown().expect(ValidationException.class);
        this.testSqlApi("EXTRACT(ISODOW FROM TIME '12:42:25')", "0");
    }

    @Test
    public void testISOYEARWithTimeWhichIsUnsupported() {
        this.thrown().expect(ValidationException.class);
        this.testSqlApi("EXTRACT(ISOYEAR FROM TIME '12:42:25')", "0");
    }

    private void testExtractFromTimeZeroResult(TimeUnit unit) {
        this.thrown().expect(ValidationException.class);
        this.testSqlApi(new StringBuilder(30).append("EXTRACT(").append(unit).append(" FROM TIME '00:00:00')").toString(), "0");
    }

    @Test
    public void testMillenniumWithTime() {
        this.thrown().expect(ValidationException.class);
        this.testExtractFromTimeZeroResult(TimeUnit.MILLENNIUM);
    }

    @Test
    public void testCenturyWithTime() {
        this.thrown().expect(ValidationException.class);
        this.testExtractFromTimeZeroResult(TimeUnit.CENTURY);
    }

    @Test
    public void testDecadeWithTime() {
        this.thrown().expect(ValidationException.class);
        this.testExtractFromTimeZeroResult(TimeUnit.DECADE);
    }

    @Test
    public void testYearWithTime() {
        this.thrown().expect(ValidationException.class);
        this.testExtractFromTimeZeroResult(TimeUnit.YEAR);
    }

    @Test
    public void testMonthWithTime() {
        this.thrown().expect(ValidationException.class);
        this.testExtractFromTimeZeroResult(TimeUnit.MONTH);
    }

    @Test
    public void testDayWithTime() {
        this.thrown().expect(ValidationException.class);
        this.testExtractFromTimeZeroResult(TimeUnit.DAY);
    }

    @Test
    public void testInvalidStringToMap() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Invalid number of arguments to function 'STR_TO_MAP'");
        this.testSqlApi("STR_TO_MAP('k1:v1;k2:v2', ';')", "EXCEPTION");
    }

    @Test
    public void testInvalidIf() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Cannot apply 'IF' to arguments");
        this.testSqlApi("IF(f7 > 5, f0, f1)", "FAIL");
    }

    @Test
    public void testInvalidToBase64() {
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Cannot apply 'TO_BASE64' to arguments of type 'TO_BASE64(<INTEGER>)'");
        this.testSqlApi("TO_BASE64(11)", "FAIL");
    }
}

