/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ScalarOperatorsTestBase;
import org.junit.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001#\ti2kY1mCJ|\u0005/\u001a:bi>\u00148OV1mS\u0012\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011aC3yaJ,7o]5p]NT!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)B!A\u0003vi&d7/\u0003\u0002\u0018)\t92kY1mCJ|\u0005/\u001a:bi>\u00148\u000fV3ti\n\u000b7/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\tq\u0003^3ti&3\u0017J\u001c<bY&$G+\u001f9fgN\u001b\u0017\r\\1\u0015\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\"\"QdJ\u0017/!\tA3&D\u0001*\u0015\tQc\"A\u0003kk:LG/\u0003\u0002-S\t!A+Z:u\u0003!)\u0007\u0010]3di\u0016$7%A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IB\u0011aA1qS&\u0011A'\r\u0002\u0014-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c\u0005\u0006m\u0001!\taH\u0001\u0017i\u0016\u001cH/\u00134J]Z\fG.\u001b3UsB,7OS1wC\"\"QgJ\u0017/\u0011\u0015I\u0004\u0001\"\u0001 \u0003q!Xm\u001d;J]Z\fG.\u001b3TiJLgnZ\"p[B\f'/[:p]FBC\u0001O\u0014.]!)A\b\u0001C\u0001?\u0005aB/Z:u\u0013:4\u0018\r\\5e'R\u0014\u0018N\\4D_6\u0004\u0018M]5t_:\u0014\u0004\u0006B\u001e([9BQa\u0010\u0001\u0005\u0002}\ta\u0003^3ti&sWj\u001c:f)\"\fgn\u00148f)f\u0004Xm\u001d\u0015\u0005}\u001djc\u0006C\u0003C\u0001\u0011\u0005q$A\fuKN$\u0018J\u001c#jM\u001a,'/\u001a8u\u001fB,'/\u00198eg\"\"\u0011iJ\u0017/\u0011\u0015)\u0005\u0001\"\u0001 \u0003!\"Xm\u001d;CKR<X-\u001a8XSRDG)\u001b4gKJ,g\u000e^(qKJ\fg\u000e\u001a+za\u0016\u001c6-\u00197bQ\u0011!u%\f\u0018\t\u000b!\u0003A\u0011A\u0010\u0002OQ,7\u000f\u001e\"fi^,WM\\,ji\"$\u0015N\u001a4fe\u0016tGo\u00149fe\u0006tG\rV=qK*\u000bg/\u0019\u0015\u0005\u000f\u001ejc\u0006C\u0003L\u0001\u0011\u0005q$\u0001\u0016uKN$H+Z7q_J\fG\u000eV=qK\u0016\u000bX/\u00197t\u0013:4\u0018\r\\5e'R\u0014\u0018N\\4MSR,'/\u00197)\u0005);\u0003")
public class ScalarOperatorsValidationTest
extends ScalarOperatorsTestBase {
    @Test(expected=ValidationException.class)
    public void testIfInvalidTypesScala() {
        this.testTableApi(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f6")).$amp$amp(package$.MODULE$.boolean2Literal(true))).$qmark(package$.MODULE$.int2Literal(5), package$.MODULE$.string2Literal("false")), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testIfInvalidTypesJava() {
        this.testTableApi(package$.MODULE$.string2Literal("FAIL"), "(f8 && true).?(5, 'false')", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidStringComparison1() {
        this.testTableApi(package$.MODULE$.LiteralStringExpression("w").$eq$eq$eq(package$.MODULE$.int2Literal(4)), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidStringComparison2() {
        this.testTableApi(package$.MODULE$.LiteralStringExpression("w").$greater(package$.MODULE$.LiteralIntExpression(4).toExpr()), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInMoreThanOneTypes() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).in((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f3")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f4")), package$.MODULE$.int2Literal(4)}), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testInDifferentOperands() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1")).in((Object[])new Expression[]{package$.MODULE$.string2Literal("Hi"), package$.MODULE$.string2Literal("Hello world"), package$.MODULE$.string2Literal("Comment#1")}), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testBetweenWithDifferentOperandTypeScala() {
        this.testTableApi((Expression)package$.MODULE$.LiteralIntExpression(2).between((Object)package$.MODULE$.int2Literal(1), (Object)package$.MODULE$.string2Literal("a")), "FAIL", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testBetweenWithDifferentOperandTypeJava() {
        this.testTableApi(package$.MODULE$.string2Literal("FAIL"), "2.between(1, 'a')", "FAIL");
    }

    @Test
    public void testTemporalTypeEqualsInvalidStringLiteral() {
        this.testExpectedSqlException("f15 = 'invalid'", "Error when casting CHAR(7) NOT NULL to DATE", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f15", "Error when casting CHAR(7) NOT NULL to DATE", ValidationException.class);
        this.testExpectedSqlException("f21 = 'invalid'", "Error when casting CHAR(7) NOT NULL to TIME", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f21", "Error when casting CHAR(7) NOT NULL to TIME", ValidationException.class);
        this.testExpectedSqlException("f22 = 'invalid'", "Error when casting CHAR(7) NOT NULL to TIMESTAMP(6)", ValidationException.class);
        this.testExpectedSqlException("'invalid' = f22", "Error when casting CHAR(7) NOT NULL to TIMESTAMP(6)", ValidationException.class);
    }
}

