/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BuiltInAggregateFunctionTestBase {
    @ClassRule
    public static MiniClusterWithClientResource miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());
    @Parameterized.Parameter
    public TestSpec testSpec;

    @Test
    public void testFunction() throws Exception {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        tEnv.getConfig().set(StateBackendOptions.STATE_BACKEND, (Object)this.testSpec.backendName);
        Table sourceTable = BuiltInAggregateFunctionTestBase.asTable(tEnv, this.testSpec.sourceRowType, this.testSpec.sourceRows);
        for (TestItem testItem : this.testSpec.testItems) {
            testItem.execute(tEnv, sourceTable);
        }
    }

    protected static Table asTable(TableEnvironment tEnv, DataType sourceRowType, List<Row> rows) {
        TableDescriptor descriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().fromRowDataType(sourceRowType).build()).source(BuiltInAggregateFunctionTestBase.asSource(rows, sourceRowType)).build();
        return tEnv.from(descriptor);
    }

    protected static TableFactoryHarness.ScanSourceBase asSource(final List<Row> rows, final DataType producedDataType) {
        return new TableFactoryHarness.ScanSourceBase(){

            @Override
            public ChangelogMode getChangelogMode() {
                Set rowKinds = rows.stream().map(Row::getKind).collect(Collectors.toSet());
                if (rowKinds.size() == 1 && rowKinds.contains(RowKind.INSERT)) {
                    return ChangelogMode.insertOnly();
                }
                return ChangelogMode.all();
            }

            @Override
            public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
                DynamicTableSource.DataStructureConverter converter = context.createDataStructureConverter(producedDataType);
                return SourceFunctionProvider.of((SourceFunction)new Source(rows, converter), (boolean)true);
            }
        };
    }

    protected static void assertRows(List<Row> expectedRows, TableResult tableResult) {
        List actualRows = BuiltInAggregateFunctionTestBase.materializeResult(tableResult).stream().sorted(Comparator.comparing(Objects::toString)).collect(Collectors.toList());
        List sortedExpectedRows = expectedRows.stream().sorted(Comparator.comparing(Objects::toString)).collect(Collectors.toList());
        Assert.assertEquals((String)String.format("%n%nExpected:%n%s%n%nActual:%n%s", sortedExpectedRows, actualRows), sortedExpectedRows, actualRows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Row> materializeResult(TableResult tableResult) {
        try (CloseableIterator iterator = tableResult.collect();){
            ArrayList<Row> actualRows = new ArrayList<Row>();
            iterator.forEachRemaining(row -> {
                RowKind kind = row.getKind();
                switch (kind) {
                    case INSERT: 
                    case UPDATE_AFTER: {
                        row.setKind(RowKind.INSERT);
                        actualRows.add((Row)row);
                        break;
                    }
                    case UPDATE_BEFORE: 
                    case DELETE: {
                        row.setKind(RowKind.INSERT);
                        actualRows.remove(row);
                    }
                }
            });
            ArrayList<Row> arrayList = actualRows;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not collect results", e);
        }
    }

    private static class Source
    implements SourceFunction<RowData> {
        private final List<Row> rows;
        private final DynamicTableSource.DataStructureConverter converter;

        public Source(List<Row> rows, DynamicTableSource.DataStructureConverter converter) {
            this.rows = rows;
            this.converter = converter;
        }

        public void run(SourceFunction.SourceContext<RowData> ctx) throws Exception {
            this.rows.stream().map(row -> (RowData)this.converter.toInternal(row)).forEach(arg_0 -> ctx.collect(arg_0));
        }

        public void cancel() {
        }
    }

    private static class TableApiTestItem
    extends SuccessItem {
        private final Function<Table, Table> spec;

        public TableApiTestItem(Function<Table, Table> spec, @Nullable DataType expectedRowType, @Nullable List<Row> expectedRows) {
            super(expectedRowType, expectedRows);
            this.spec = spec;
        }

        @Override
        protected TableResult getResult(TableEnvironment tEnv, Table sourceTable) {
            return this.spec.apply(sourceTable).execute();
        }
    }

    private static class SqlTestItem
    extends SuccessItem {
        private final Function<Table, String> spec;

        public SqlTestItem(Function<Table, String> spec, @Nullable DataType expectedRowType, @Nullable List<Row> expectedRows) {
            super(expectedRowType, expectedRows);
            this.spec = spec;
        }

        @Override
        protected TableResult getResult(TableEnvironment tEnv, Table sourceTable) {
            return tEnv.sqlQuery(this.spec.apply(sourceTable)).execute();
        }
    }

    private static abstract class SuccessItem
    implements TestItem {
        @Nullable
        private final DataType expectedRowType;
        @Nullable
        private final List<Row> expectedRows;

        public SuccessItem(@Nullable DataType expectedRowType, @Nullable List<Row> expectedRows) {
            this.expectedRowType = expectedRowType;
            this.expectedRows = expectedRows;
        }

        @Override
        public void execute(TableEnvironment tEnv, Table sourceTable) {
            TableResult tableResult = this.getResult(tEnv, sourceTable);
            if (this.expectedRowType != null) {
                DataType actualRowType = tableResult.getResolvedSchema().toSourceRowDataType();
                Assert.assertEquals((long)DataType.getFieldCount((DataType)this.expectedRowType), (long)DataType.getFieldCount((DataType)actualRowType));
                Assert.assertEquals((Object)DataType.getFieldDataTypes((DataType)this.expectedRowType), (Object)DataType.getFieldDataTypes((DataType)actualRowType));
            }
            if (this.expectedRows != null) {
                BuiltInAggregateFunctionTestBase.assertRows(this.expectedRows, tableResult);
            }
        }

        protected abstract TableResult getResult(TableEnvironment var1, Table var2);
    }

    private static interface TestItem {
        public void execute(TableEnvironment var1, Table var2);
    }

    protected static class TestSpec {
        private final BuiltInFunctionDefinition definition;
        private final List<TestItem> testItems = new ArrayList<TestItem>();
        @Nullable
        private String description;
        private DataType sourceRowType;
        private List<Row> sourceRows;
        private String backendName;

        private TestSpec(BuiltInFunctionDefinition definition) {
            this.definition = (BuiltInFunctionDefinition)Preconditions.checkNotNull((Object)definition);
        }

        static TestSpec forFunction(BuiltInFunctionDefinition definition) {
            return new TestSpec(definition);
        }

        TestSpec withDescription(String description) {
            this.description = description;
            return this;
        }

        TestSpec withSource(DataType sourceRowType, List<Row> sourceRows) {
            this.sourceRowType = sourceRowType;
            this.sourceRows = sourceRows;
            return this;
        }

        public TestSpec withStateBackend(String backendName) {
            this.backendName = backendName;
            return this;
        }

        public TestSpec copy() {
            return new TestSpec(this.definition).withSource(this.sourceRowType, new ArrayList<Row>(this.sourceRows));
        }

        TestSpec testSqlResult(Function<Table, String> sqlSpec, DataType expectedRowType, List<Row> expectedRows) {
            this.testItems.add(new SqlTestItem(sqlSpec, expectedRowType, expectedRows));
            return this;
        }

        TestSpec testApiResult(Function<Table, Table> tableApiSpec, DataType expectedRowType, List<Row> expectedRows) {
            this.testItems.add(new TableApiTestItem(tableApiSpec, expectedRowType, expectedRows));
            return this;
        }

        TestSpec testResult(Function<Table, String> sqlSpec, Function<Table, Table> tableApiSpec, DataType expectedRowType, List<Row> expectedRows) {
            return this.testResult(sqlSpec, tableApiSpec, expectedRowType, expectedRowType, expectedRows);
        }

        TestSpec testResult(Function<Table, String> sqlSpec, Function<Table, Table> tableApiSpec, DataType expectedSqlRowType, DataType expectedTableApiRowType, List<Row> expectedRows) {
            this.testSqlResult(sqlSpec, expectedSqlRowType, expectedRows);
            this.testApiResult(tableApiSpec, expectedTableApiRowType, expectedRows);
            return this;
        }

        public String toString() {
            StringBuilder bob = new StringBuilder();
            bob.append(this.definition.getName());
            if (this.description != null) {
                bob.append(" (");
                bob.append(this.description);
                bob.append(")");
            }
            bob.append(", backend: ").append(this.backendName);
            return bob.toString();
        }
    }
}

