/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={FieldAccessFromTable.class, FieldAccessAfterCall.class})
public class ConstructedAccessFunctionsITCase {

    public static class ComplexPojo {
        public final int i;
        @DataTypeHint(value="TIMESTAMP(3)")
        public final LocalDateTime t;
        public final String s;
        @DataTypeHint(value="ROW<ri INT, rs STRING>")
        public final Row r;

        public ComplexPojo(int i, LocalDateTime t, String s, Row r) {
            this.i = i;
            this.t = t;
            this.s = s;
            this.r = r;
        }
    }

    public static class PojoConstructorScalarFunction
    extends ScalarFunction {
        public ComplexPojo eval(int i, @DataTypeHint(value="TIMESTAMP(3)") LocalDateTime t, String s, @DataTypeHint(value="ROW<ri INT, rs STRING>") Row r) {
            return new ComplexPojo(i, t, s, r);
        }
    }

    @FunctionHint(output=@DataTypeHint(value="ROW<s STRING, sa ARRAY<STRING> NOT NULL>"))
    public static class RowTableFunction
    extends TableFunction<Row> {
        public void eval() {
            this.collect(null);
            this.collect(Row.of((Object[])new Object[]{"A", new String[]{"A", "B"}}));
        }
    }

    public static class CustomScalarFunction
    extends ScalarFunction {
        public long eval(int i, long l) {
            return (long)i + l;
        }

        @DataTypeHint(value="ROW<nested INT NOT NULL>")
        public Row eval() {
            return null;
        }

        @DataTypeHint(value="ROW<nested INT NOT NULL> NOT NULL")
        public Row eval(int nested) {
            return Row.of((Object[])new Object[]{nested});
        }
    }

    public static class FieldAccessAfterCall {
        @ClassRule
        public static MiniClusterWithClientResource miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());
        @Rule
        public ExpectedException thrown = ExpectedException.none();

        @Test
        public void testSqlAccessingNullableRow() {
            TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
            env.createTemporarySystemFunction("CustomScalarFunction", CustomScalarFunction.class);
            this.thrown.expect(ValidationException.class);
            this.thrown.expectMessage("Invalid function call:\nCustomScalarFunction(INT NOT NULL, INT)");
            env.executeSql("SELECT CustomScalarFunction(1, CustomScalarFunction().nested)");
        }

        @Test
        public void testSqlAccessingNotNullRow() throws Exception {
            TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
            env.createTemporarySystemFunction("CustomScalarFunction", CustomScalarFunction.class);
            TableResult result = env.executeSql("SELECT CustomScalarFunction(1, CustomScalarFunction(1).nested)");
            try (CloseableIterator it = result.collect();){
                MatcherAssert.assertThat((Object)it.next(), (Matcher)CoreMatchers.equalTo((Object)Row.of((Object[])new Object[]{2L})));
                Assert.assertFalse((boolean)it.hasNext());
            }
        }

        @Test
        public void testSqlAccessingNullableRowWithAlias() throws Exception {
            TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
            env.createTemporarySystemFunction("RowTableFunction", RowTableFunction.class);
            TableResult result = env.executeSql("SELECT t.b, t.a FROM (SELECT * FROM (VALUES(1))), LATERAL TABLE(RowTableFunction()) AS t(a, b)");
            MatcherAssert.assertThat((Object)result.getResolvedSchema(), (Matcher)CoreMatchers.equalTo((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"b", (DataType)((DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull())), Column.physical((String)"a", (DataType)DataTypes.STRING())})));
            try (CloseableIterator it = result.collect();){
                MatcherAssert.assertThat((Object)it.next(), (Matcher)CoreMatchers.equalTo((Object)Row.of((Object[])new Object[]{new String[]{"A", "B"}, "A"})));
                Assert.assertFalse((boolean)it.hasNext());
            }
        }

        @Test
        public void testTableApiAccessingNullableRow() {
            TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
            this.thrown.expect(ValidationException.class);
            this.thrown.expectMessage("Invalid function call:\nCustomScalarFunction(INT NOT NULL, INT)");
            env.fromValues(new Object[]{1}).select(new Expression[]{Expressions.call(CustomScalarFunction.class, (Object[])new Object[]{1, Expressions.call(CustomScalarFunction.class, (Object[])new Object[0]).get("nested")})}).execute();
        }

        @Test
        public void testTableApiAccessingNotNullRow() throws Exception {
            TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
            TableResult result = env.fromValues(new Object[]{1}).select(new Expression[]{Expressions.call(CustomScalarFunction.class, (Object[])new Object[]{1, Expressions.call(CustomScalarFunction.class, (Object[])new Object[]{1}).get("nested")})}).execute();
            try (CloseableIterator it = result.collect();){
                MatcherAssert.assertThat((Object)it.next(), (Matcher)CoreMatchers.equalTo((Object)Row.of((Object[])new Object[]{2L})));
                Assert.assertFalse((boolean)it.hasNext());
            }
        }

        @Test
        public void testTableApiFlattenRowType() throws Exception {
            TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
            TableResult result = env.fromValues(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"nested0", (DataType)((DataType)DataTypes.BIGINT().notNull())), DataTypes.FIELD((String)"nested1", (DataType)DataTypes.STRING())}).nullable()))}).notNull(), new Object[]{Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{1, "ABC"})})}).select(new Expression[]{(Expression)Expressions.$((String)"f0").flatten()}).execute();
            MatcherAssert.assertThat((Object)result.getResolvedSchema(), (Matcher)CoreMatchers.equalTo((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"f0$nested0", (DataType)((DataType)DataTypes.BIGINT().nullable())), Column.physical((String)"f0$nested1", (DataType)((DataType)DataTypes.STRING().nullable()))})));
            try (CloseableIterator it = result.collect();){
                MatcherAssert.assertThat((Object)it.next(), (Matcher)CoreMatchers.equalTo((Object)Row.of((Object[])new Object[]{1L, "ABC"})));
                Assert.assertFalse((boolean)it.hasNext());
            }
        }

        @Test
        public void testTableApiFlattenStructuredType() throws Exception {
            TableEnvironment env = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
            Row row = Row.of((Object[])new Object[]{1, LocalDateTime.parse("2012-12-12T12:12:12.001"), "a", Row.of((Object[])new Object[]{10, "aa"})});
            Table data = env.fromValues(new Object[]{row});
            TableResult result = data.select(new Expression[]{(Expression)Expressions.call(PojoConstructorScalarFunction.class, (Object[])new Object[]{Expressions.$((String)"*")}).flatten()}).execute();
            MatcherAssert.assertThat((Object)result.getResolvedSchema(), (Matcher)CoreMatchers.equalTo((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"_c0", (DataType)((DataType)DataTypes.INT().bridgedTo(Integer.TYPE))), Column.physical((String)"_c1", (DataType)DataTypes.TIMESTAMP((int)3)), Column.physical((String)"_c2", (DataType)DataTypes.STRING()), Column.physical((String)"_c3", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"ri", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"rs", (DataType)DataTypes.STRING())}))})));
            try (CloseableIterator it = result.collect();){
                MatcherAssert.assertThat((Object)it.next(), (Matcher)CoreMatchers.equalTo((Object)row));
                Assert.assertFalse((boolean)it.hasNext());
            }
        }
    }

    public static class FieldAccessFromTable
    extends BuiltInFunctionTestBase {
        @Parameterized.Parameters(name="{index}: {0}")
        public static List<BuiltInFunctionTestBase.TestSpec> testData() {
            return Arrays.asList(BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.GET).onFieldsWithData(null, Row.of((Object[])new Object[]{1})).andDataTypes(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"nested", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).nullable(), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"nested", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull()).testResult(FieldAccessFromTable.resultSpec((Expression)Expressions.$((String)"f0").get("nested"), "f0.nested", null, DataTypes.BIGINT().nullable()), FieldAccessFromTable.resultSpec((Expression)Expressions.$((String)"f1").get("nested"), "f1.nested", 1L, DataTypes.BIGINT().notNull())), BuiltInFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.AT).onFieldsWithData(null, new int[]{1}, null, Collections.singletonMap("nested", 1), null, Row.of((Object[])new Object[]{1})).andDataTypes(DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull())).nullable(), DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull())).notNull(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)((DataType)DataTypes.BIGINT().notNull())).nullable(), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)((DataType)DataTypes.BIGINT().notNull())).notNull(), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"nested", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).nullable(), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"nested", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull()).testResult(FieldAccessFromTable.resultSpec((Expression)Expressions.$((String)"f0").at((Object)1), "f0[1]", null, DataTypes.BIGINT().nullable()), FieldAccessFromTable.resultSpec((Expression)Expressions.$((String)"f1").at((Object)1), "f1[1]", 1L, DataTypes.BIGINT().nullable()), FieldAccessFromTable.resultSpec((Expression)Expressions.$((String)"f2").at((Object)"nested"), "f2['nested']", null, DataTypes.BIGINT().nullable()), FieldAccessFromTable.resultSpec((Expression)Expressions.$((String)"f3").at((Object)"nested"), "f3['nested']", 1L, DataTypes.BIGINT().nullable()), FieldAccessFromTable.resultSpec((Expression)Expressions.$((String)"f4").get("nested"), "f4['nested']", null, DataTypes.BIGINT().nullable()), FieldAccessFromTable.resultSpec((Expression)Expressions.$((String)"f5").get("nested"), "f5['nested']", 1L, DataTypes.BIGINT().notNull())));
        }
    }
}

