/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public abstract class AggFunctionTestBase<T, ACC> {
    protected abstract List<List<T>> getInputValueSets();

    protected abstract List<T> getExpectedResults();

    protected abstract AggregateFunction<T, ACC> getAggregator();

    protected abstract Class<?> getAccClass();

    protected Method getAccumulateFunc() throws NoSuchMethodException {
        return this.getAggregator().getClass().getMethod("accumulate", this.getAccClass(), Object.class);
    }

    protected Method getRetractFunc() throws NoSuchMethodException {
        throw new UnsupportedOperationException("retract is not supported");
    }

    @Test
    public void testAccumulateAndRetractWithoutMerge() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<List<T>> inputValueSets = this.getInputValueSets();
        List<T> expectedResults = this.getExpectedResults();
        Preconditions.checkArgument((inputValueSets.size() == expectedResults.size() ? 1 : 0) != 0);
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        int size = this.getInputValueSets().size();
        for (int i = 0; i < size; ++i) {
            List<T> inputValues = inputValueSets.get(i);
            T expected = expectedResults.get(i);
            ACC acc = this.accumulateValues(inputValues);
            Object result = aggregator.getValue(acc);
            this.validateResult(expected, result);
            if (!UserDefinedFunctionUtils.ifMethodExistInFunction((String)"retract", aggregator)) continue;
            this.retractValues(acc, inputValues);
            Object expectedAcc = aggregator.createAccumulator();
            this.validateResult(expectedAcc, acc);
        }
    }

    @Test
    public void testAggregateWithMerge() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        if (UserDefinedFunctionUtils.ifMethodExistInFunction((String)"merge", aggregator)) {
            T expected;
            List<T> inputValues;
            int i;
            Method mergeFunc = aggregator.getClass().getMethod("merge", this.getAccClass(), Iterable.class);
            List<List<T>> inputValueSets = this.getInputValueSets();
            List<T> expectedResults = this.getExpectedResults();
            Preconditions.checkArgument((inputValueSets.size() == expectedResults.size() ? 1 : 0) != 0);
            int size = this.getInputValueSets().size();
            for (i = 0; i < size; ++i) {
                inputValues = inputValueSets.get(i);
                expected = expectedResults.get(i);
                Tuple2<List<T>, List<T>> splitValues = this.splitValues(inputValues);
                List firstValues = (List)splitValues.f0;
                List secondValues = (List)splitValues.f1;
                ArrayList<ACC> accumulators = new ArrayList<ACC>();
                accumulators.add(this.accumulateValues(secondValues));
                ACC acc = this.accumulateValues(firstValues);
                mergeFunc.invoke(aggregator, acc, accumulators);
                Object result = aggregator.getValue(acc);
                this.validateResult(expected, result);
                if (!UserDefinedFunctionUtils.ifMethodExistInFunction((String)"retract", aggregator)) continue;
                this.retractValues(acc, inputValues);
                Object expectedAcc = aggregator.createAccumulator();
                this.validateResult(expectedAcc, acc);
            }
            for (i = 0; i < size; ++i) {
                inputValues = inputValueSets.get(i);
                expected = expectedResults.get(i);
                ArrayList<Object> accumulators = new ArrayList<Object>();
                accumulators.add(aggregator.createAccumulator());
                ACC acc = this.accumulateValues(inputValues);
                mergeFunc.invoke(aggregator, acc, accumulators);
                Object result = aggregator.getValue(acc);
                this.validateResult(expected, result);
            }
        }
    }

    @Test
    public void testMergeReservedAccumulator() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        boolean hasMerge = UserDefinedFunctionUtils.ifMethodExistInFunction((String)"merge", aggregator);
        boolean hasRetract = UserDefinedFunctionUtils.ifMethodExistInFunction((String)"retract", aggregator);
        if (!hasMerge || !hasRetract) {
            return;
        }
        Method mergeFunc = aggregator.getClass().getMethod("merge", this.getAccClass(), Iterable.class);
        List<List<T>> inputValueSets = this.getInputValueSets();
        int size = this.getInputValueSets().size();
        for (int i = 0; i < size; ++i) {
            List<T> inputValues = inputValueSets.get(i);
            ArrayList<ACC> accumulators = new ArrayList<ACC>();
            ArrayList<Object> reversedAccumulators = new ArrayList<Object>();
            accumulators.add(this.accumulateValues(inputValues));
            Object retractedAcc = aggregator.createAccumulator();
            this.retractValues(retractedAcc, inputValues);
            reversedAccumulators.add(retractedAcc);
            ACC accWithSubset = this.accumulateValues(inputValues.subList(0, 2));
            Object expectedValue = aggregator.getValue(accWithSubset);
            Object acc = aggregator.createAccumulator();
            mergeFunc.invoke(aggregator, acc, accumulators);
            mergeFunc.invoke(aggregator, acc, reversedAccumulators);
            mergeFunc.invoke(aggregator, accWithSubset, Collections.singleton(acc));
            Object result = aggregator.getValue(accWithSubset);
            this.validateResult(expectedValue, result);
        }
    }

    @Test
    public void testResetAccumulator() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        if (UserDefinedFunctionUtils.ifMethodExistInFunction((String)"resetAccumulator", aggregator)) {
            Method resetAccFunc = aggregator.getClass().getMethod("resetAccumulator", this.getAccClass());
            List<List<T>> inputValueSets = this.getInputValueSets();
            List<T> expectedResults = this.getExpectedResults();
            Preconditions.checkArgument((inputValueSets.size() == expectedResults.size() ? 1 : 0) != 0);
            int size = this.getInputValueSets().size();
            for (int i = 0; i < size; ++i) {
                List<T> inputValues = inputValueSets.get(i);
                ACC acc = this.accumulateValues(inputValues);
                resetAccFunc.invoke(aggregator, acc);
                Object expectedAcc = aggregator.createAccumulator();
                this.validateResult(expectedAcc, acc);
            }
        }
    }

    protected <E> void validateResult(E expected, E result) {
        Assert.assertEquals(expected, result);
    }

    protected ACC accumulateValues(List<T> values) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        Object accumulator = this.getAggregator().createAccumulator();
        Method accumulateFunc = this.getAccumulateFunc();
        for (T value : values) {
            if (accumulateFunc.getParameterCount() == 1) {
                accumulateFunc.invoke(aggregator, accumulator);
                continue;
            }
            if (accumulateFunc.getParameterCount() == 2) {
                accumulateFunc.invoke(aggregator, accumulator, value);
                continue;
            }
            throw new TableException("Unsupported now");
        }
        return (ACC)accumulator;
    }

    protected void retractValues(ACC accumulator, List<T> values) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<T, ACC> aggregator = this.getAggregator();
        Method retractFunc = this.getRetractFunc();
        for (T value : values) {
            if (retractFunc.getParameterCount() == 1) {
                retractFunc.invoke(aggregator, accumulator);
                continue;
            }
            if (retractFunc.getParameterCount() == 2) {
                retractFunc.invoke(aggregator, accumulator, value);
                continue;
            }
            throw new TableException("Unsupported now");
        }
    }

    protected Tuple2<List<T>, List<T>> splitValues(List<T> values) {
        return this.splitValues(values, values.size() / 2);
    }

    protected Tuple2<List<T>, List<T>> splitValues(List<T> values, int index) {
        int i;
        ArrayList<T> firstValues = new ArrayList<T>();
        ArrayList<T> secondValues = new ArrayList<T>();
        for (i = 0; i < values.size() && i < index; ++i) {
            firstValues.add(values.get(i));
        }
        if (i < values.size()) {
            secondValues.addAll(values.subList(i, values.size()));
        }
        return new Tuple2(firstValues, secondValues);
    }
}

