/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.runtime.functions.aggregate.FirstValueWithRetractAggFunction;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public final class FirstValueWithRetractAggFunctionWithoutOrderTest {

    public static abstract class NumberFirstValueWithRetractAggFunctionWithoutOrderTestBase<T>
    extends FirstValueWithRetractAggFunctionWithoutOrderTestBase<T> {
        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getValue("-99"), this.getValue("3"), null), Arrays.asList(null, null, null, null), Arrays.asList(null, this.getValue("10"), null, this.getValue("3")));
        }

        @Override
        protected List<T> getExpectedResults() {
            return Arrays.asList(this.getValue("1"), null, this.getValue("10"));
        }
    }

    public static abstract class FirstValueWithRetractAggFunctionWithoutOrderTestBase<T>
    extends AggFunctionTestBase<T, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<T>> {
        @Override
        protected Class<?> getAccClass() {
            return FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator.class;
        }

        @Override
        protected Method getRetractFunc() throws NoSuchMethodException {
            return this.getAggregator().getClass().getMethod("retract", this.getAccClass(), Object.class);
        }
    }

    public static final class StringFirstValueWithRetractAggFunctionWithoutOrderTest
    extends FirstValueWithRetractAggFunctionWithoutOrderTestBase<StringData> {
        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<StringData> getExpectedResults() {
            return Arrays.asList(StringData.fromString((String)"abc"), null, StringData.fromString((String)"a"), StringData.fromString((String)"x"));
        }

        @Override
        protected AggregateFunction<StringData, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<StringData>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.STRING().getLogicalType());
        }
    }

    public static final class DecimalFirstValueWithRetractAggFunctionWithoutOrderTest
    extends FirstValueWithRetractAggFunctionWithoutOrderTestBase<DecimalData> {
        private int precision = 20;
        private int scale = 6;

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<DecimalData> getExpectedResults() {
            return Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale));
        }

        @Override
        protected AggregateFunction<DecimalData, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<DecimalData>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.DECIMAL((int)this.precision, (int)this.scale).getLogicalType());
        }
    }

    public static final class BooleanFirstValueWithRetractAggFunctionWithoutOrderTest
    extends FirstValueWithRetractAggFunctionWithoutOrderTestBase<Boolean> {
        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<Boolean> getExpectedResults() {
            return Arrays.asList(false, true, true, null, true);
        }

        @Override
        protected AggregateFunction<Boolean, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Boolean>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.BOOLEAN().getLogicalType());
        }
    }

    public static final class DoubleFirstValueWithRetractAggFunctionWithoutOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithoutOrderTestBase<Double> {
        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<Double, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Double>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.DOUBLE().getLogicalType());
        }
    }

    public static final class FloatFirstValueWithRetractAggFunctionWithoutOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithoutOrderTestBase<Float> {
        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<Float, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Float>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.FLOAT().getLogicalType());
        }
    }

    public static final class LongFirstValueWithRetractAggFunctionWithoutOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithoutOrderTestBase<Long> {
        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<Long, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Long>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.BIGINT().getLogicalType());
        }
    }

    public static final class IntFirstValueWithRetractAggFunctionWithoutOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithoutOrderTestBase<Integer> {
        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<Integer, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Integer>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.INT().getLogicalType());
        }
    }

    public static final class ShortFirstValueWithRetractAggFunctionWithoutOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithoutOrderTestBase<Short> {
        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<Short, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Short>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.SMALLINT().getLogicalType());
        }
    }

    public static final class ByteFirstValueWithRetractAggFunctionWithoutOrderTest
    extends NumberFirstValueWithRetractAggFunctionWithoutOrderTestBase<Byte> {
        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<Byte, FirstValueWithRetractAggFunction.FirstValueWithRetractAccumulator<Byte>> getAggregator() {
            return new FirstValueWithRetractAggFunction(DataTypes.TINYINT().getLogicalType());
        }
    }
}

