/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.runtime.functions.aggregate.ListAggWsWithRetractAggFunction;
import org.apache.flink.util.Preconditions;

public final class ListAggWsWithRetractAggFunctionTest
extends AggFunctionTestBase<StringData, ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator> {
    @Override
    protected List<List<StringData>> getInputValueSets() {
        return Arrays.asList(Arrays.asList(StringData.fromString((String)"a"), StringData.fromString((String)"\n"), StringData.fromString((String)"b"), StringData.fromString((String)"\n"), null, StringData.fromString((String)"\n"), StringData.fromString((String)"c"), StringData.fromString((String)"\n"), null, StringData.fromString((String)"\n"), StringData.fromString((String)"d"), StringData.fromString((String)"\n"), StringData.fromString((String)"e"), StringData.fromString((String)"\n"), null, StringData.fromString((String)"\n"), StringData.fromString((String)"f"), StringData.fromString((String)"\n")), Arrays.asList(null, null, null, null, null, null), Arrays.asList(null, StringData.fromString((String)"\n"), null, StringData.fromString((String)"\n"), null, StringData.fromString((String)"\n")), Arrays.asList(null, StringData.fromString((String)"\n"), StringData.fromString((String)"a"), StringData.fromString((String)"\n"), StringData.fromString((String)"b"), StringData.fromString((String)"\n")), Arrays.asList(StringData.fromString((String)"a"), StringData.fromString((String)","), StringData.fromString((String)"b"), StringData.fromString((String)","), null, StringData.fromString((String)"\n"), StringData.fromString((String)"c"), StringData.fromString((String)",")), Arrays.asList(StringData.fromString((String)"a"), StringData.fromString((String)","), StringData.fromString((String)"b"), StringData.fromString((String)","), null, StringData.fromString((String)"\n"), StringData.fromString((String)"c"), StringData.fromString((String)"\n")));
    }

    @Override
    protected List<StringData> getExpectedResults() {
        return Arrays.asList(StringData.fromString((String)"a\nb\nc\nd\ne\nf"), null, null, StringData.fromString((String)"a\nb"), StringData.fromString((String)"a,b,c"), StringData.fromString((String)"a\nb\nc"));
    }

    @Override
    protected AggregateFunction<StringData, ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator> getAggregator() {
        return new ListAggWsWithRetractAggFunction();
    }

    @Override
    protected Method getAccumulateFunc() throws NoSuchMethodException {
        return this.getAggregator().getClass().getMethod("accumulate", this.getAccClass(), StringData.class, StringData.class);
    }

    @Override
    protected Method getRetractFunc() throws NoSuchMethodException {
        return this.getAggregator().getClass().getMethod("retract", this.getAccClass(), StringData.class, StringData.class);
    }

    @Override
    protected Class<?> getAccClass() {
        return ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator.class;
    }

    @Override
    protected ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator accumulateValues(List<StringData> values) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<StringData, ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator> aggregator = this.getAggregator();
        ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator accumulator = (ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator)this.getAggregator().createAccumulator();
        Method accumulateFunc = this.getAccumulateFunc();
        Preconditions.checkArgument((values.size() % 2 == 0 ? 1 : 0) != 0, (Object)"number of values must be an integer multiple of 2.");
        for (int i = 0; i < values.size(); i += 2) {
            StringData value = values.get(i + 1);
            StringData delimiter = values.get(i);
            accumulateFunc.invoke(aggregator, accumulator, delimiter, value);
        }
        return accumulator;
    }

    @Override
    protected void retractValues(ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator accumulator, List<StringData> values) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AggregateFunction<StringData, ListAggWsWithRetractAggFunction.ListAggWsWithRetractAccumulator> aggregator = this.getAggregator();
        Method retractFunc = this.getRetractFunc();
        Preconditions.checkArgument((values.size() % 2 == 0 ? 1 : 0) != 0, (Object)"number of values must be an integer multiple of 2.");
        for (int i = 0; i < values.size(); i += 2) {
            StringData value = values.get(i + 1);
            StringData delimiter = values.get(i);
            retractFunc.invoke(aggregator, accumulator, delimiter, value);
        }
    }

    @Override
    protected Tuple2<List<StringData>, List<StringData>> splitValues(List<StringData> values) {
        Preconditions.checkArgument((values.size() % 2 == 0 ? 1 : 0) != 0, (Object)"number of values must be an integer multiple of 2.");
        int index = values.size() / 2;
        if (index % 2 != 0) {
            --index;
        }
        return super.splitValues(values, index);
    }
}

