/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.mocks.MockSource;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraphGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.processor.MultipleInputNodeCreationProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.util.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;

public class MultipleInputNodeCreationProcessorTest
extends TableTestBase {
    private final BatchTableTestUtil batchUtil = this.batchTestUtil(new TableConfig());
    private final StreamTableTestUtil streamUtil = this.streamTestUtil(new TableConfig());

    @Test
    public void testIsChainableDataStreamSource() {
        this.createChainableStream(this.batchUtil);
        this.assertChainableSource("chainableStream", this.batchUtil, true);
        this.createChainableStream(this.streamUtil);
        this.assertChainableSource("chainableStream", this.streamUtil, true);
    }

    @Test
    public void testNonChainableDataStreamSource() {
        this.createNonChainableStream(this.batchUtil);
        this.assertChainableSource("nonChainableStream", this.batchUtil, false);
        this.createNonChainableStream(this.streamUtil);
        this.assertChainableSource("nonChainableStream", this.streamUtil, false);
    }

    @Test
    public void testIsChainableTableSource() throws IOException {
        this.createTestFileSource(this.batchUtil.tableEnv(), "fileSource1", "Source");
        this.assertChainableSource("fileSource1", this.batchUtil, true);
        this.createTestFileSource(this.streamUtil.tableEnv(), "fileSource1", "Source");
        this.assertChainableSource("fileSource1", this.streamUtil, true);
        this.createTestFileSource(this.batchUtil.tableEnv(), "fileSource2", "DataStream");
        this.assertChainableSource("fileSource2", this.batchUtil, true);
        this.createTestFileSource(this.streamUtil.tableEnv(), "fileSource2", "DataStream");
        this.assertChainableSource("fileSource2", this.streamUtil, true);
    }

    @Test
    public void testNonChainableTableSource() throws IOException {
        this.createTestValueSource(this.batchUtil.tableEnv(), "valueSource1", "DataStream");
        this.assertChainableSource("valueSource1", this.batchUtil, false);
        this.createTestValueSource(this.streamUtil.tableEnv(), "valueSource1", "DataStream");
        this.assertChainableSource("valueSource1", this.streamUtil, false);
        this.createTestValueSource(this.batchUtil.tableEnv(), "valueSource2", "SourceFunction");
        this.assertChainableSource("valueSource2", this.batchUtil, false);
        this.createTestValueSource(this.streamUtil.tableEnv(), "valueSource2", "SourceFunction");
        this.assertChainableSource("valueSource2", this.streamUtil, false);
        this.createTestValueSource(this.batchUtil.tableEnv(), "valueSource3", "InputFormat");
        this.assertChainableSource("valueSource3", this.batchUtil, false);
        this.createTestValueSource(this.streamUtil.tableEnv(), "valueSource3", "InputFormat");
        this.assertChainableSource("valueSource3", this.streamUtil, false);
    }

    private void assertChainableSource(String name, TableTestUtil util, boolean expected) {
        String sql = "SELECT * FROM " + name;
        Table table = util.tableEnv().sqlQuery(sql);
        RelNode relNode = TableTestUtil.toRelNode(table);
        FlinkPhysicalRel optimizedRel = (FlinkPhysicalRel)util.getPlanner().optimize(relNode);
        ExecNodeGraphGenerator generator = new ExecNodeGraphGenerator();
        ExecNodeGraph execGraph = generator.generate(Collections.singletonList(optimizedRel), false);
        ExecNode execNode = (ExecNode)execGraph.getRootNodes().get(0);
        while (!execNode.getInputEdges().isEmpty()) {
            execNode = ((ExecEdge)execNode.getInputEdges().get(0)).getSource();
        }
        ProcessorContext context = new ProcessorContext(util.getPlanner());
        Assert.assertEquals((Object)expected, (Object)MultipleInputNodeCreationProcessor.isChainableSource((ExecNode)execNode, (ProcessorContext)context));
    }

    private void createChainableStream(TableTestUtil util) {
        DataStreamSource dataStream = util.getStreamEnv().fromSource((Source)new MockSource(Boundedness.BOUNDED, 1), WatermarkStrategy.noWatermarks(), "chainableStream");
        TableTestUtil.createTemporaryView(util.tableEnv(), "chainableStream", dataStream, (Option<Expression[]>)Option.apply((Object)new Expression[]{ApiExpressionUtils.unresolvedRef((String)"a")}), (Option<boolean[]>)Option.empty(), (Option<FlinkStatistic>)Option.empty());
    }

    private void createNonChainableStream(TableTestUtil util) {
        DataStreamSource dataStream = util.getStreamEnv().fromElements((Object[])new Integer[]{1, 2, 3});
        TableTestUtil.createTemporaryView(util.tableEnv(), "nonChainableStream", dataStream, (Option<Expression[]>)Option.apply((Object)new Expression[]{ApiExpressionUtils.unresolvedRef((String)"a")}), (Option<boolean[]>)Option.empty(), (Option<FlinkStatistic>)Option.empty());
    }

    private void createTestFileSource(TableEnvironment tEnv, String name, String runtimeSource) throws IOException {
        File file = this.tempFolder().newFile();
        file.delete();
        file.createNewFile();
        FileUtils.writeFileUtf8((File)file, (String)"1\n2\n3\n");
        tEnv.executeSql("CREATE TABLE " + name + "(\n  a STRING\n) WITH (\n  'connector' = 'test-file',\n  'path' = '" + file.toURI() + "',\n  'runtime-source' = '" + runtimeSource + "'\n)");
    }

    private void createTestValueSource(TableEnvironment tEnv, String name, String runtimeSource) {
        tEnv.executeSql("CREATE TABLE " + name + "(\n  a STRING\n) WITH (\n  'connector' = 'values',\n  'bounded' = 'true',\n  'runtime-source' = '" + runtimeSource + "'\n)");
    }
}

