/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.TestingBatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.processor.utils.TopologyGraph;
import org.junit.Assert;
import org.junit.Test;

public class TopologyGraphTest {
    private TestingBatchExecNode[] buildLinkedNodes() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[8];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        nodes[1].addInput((ExecNode<?>)nodes[0]);
        nodes[2].addInput((ExecNode<?>)nodes[1]);
        nodes[3].addInput((ExecNode<?>)nodes[1]);
        nodes[4].addInput((ExecNode<?>)nodes[3]);
        nodes[5].addInput((ExecNode<?>)nodes[2]);
        nodes[5].addInput((ExecNode<?>)nodes[4]);
        nodes[6].addInput((ExecNode<?>)nodes[3]);
        nodes[7].addInput((ExecNode<?>)nodes[6]);
        return nodes;
    }

    private Tuple2<TopologyGraph, TestingBatchExecNode[]> buildTopologyGraph() {
        TestingBatchExecNode[] nodes = this.buildLinkedNodes();
        return Tuple2.of((Object)new TopologyGraph(Arrays.asList(nodes[5], nodes[7])), (Object)nodes);
    }

    private Tuple2<TopologyGraph, TestingBatchExecNode[]> buildBoundedTopologyGraph() {
        TestingBatchExecNode[] nodes = this.buildLinkedNodes();
        return Tuple2.of((Object)new TopologyGraph(Arrays.asList(nodes[5], nodes[7]), new HashSet<TestingBatchExecNode>(Arrays.asList(nodes[2], nodes[3]))), (Object)nodes);
    }

    @Test
    public void testCanReach() {
        Tuple2<TopologyGraph, TestingBatchExecNode[]> tuple2 = this.buildTopologyGraph();
        TopologyGraph graph = (TopologyGraph)tuple2.f0;
        TestingBatchExecNode[] nodes = (TestingBatchExecNode[])tuple2.f1;
        String[] canReach = new String[]{"11111111", "01111111", "00100100", "00011111", "00001100", "00000100", "00000011", "00000001"};
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (canReach[i].charAt(j) == '1') {
                    Assert.assertTrue((boolean)graph.canReach((ExecNode)nodes[i], (ExecNode)nodes[j]));
                    continue;
                }
                Assert.assertFalse((boolean)graph.canReach((ExecNode)nodes[i], (ExecNode)nodes[j]));
            }
        }
    }

    @Test
    public void testLink() {
        Tuple2<TopologyGraph, TestingBatchExecNode[]> tuple2 = this.buildTopologyGraph();
        TopologyGraph graph = (TopologyGraph)tuple2.f0;
        TestingBatchExecNode[] nodes = (TestingBatchExecNode[])tuple2.f1;
        Assert.assertTrue((boolean)graph.link((ExecNode)nodes[2], (ExecNode)nodes[4]));
        Assert.assertTrue((boolean)graph.link((ExecNode)nodes[3], (ExecNode)nodes[5]));
        Assert.assertTrue((boolean)graph.link((ExecNode)nodes[5], (ExecNode)nodes[6]));
        Assert.assertFalse((boolean)graph.link((ExecNode)nodes[7], (ExecNode)nodes[2]));
        Assert.assertFalse((boolean)graph.link((ExecNode)nodes[7], (ExecNode)nodes[4]));
        Assert.assertTrue((boolean)graph.link((ExecNode)nodes[0], (ExecNode)nodes[7]));
    }

    @Test
    public void testUnlink() {
        Tuple2<TopologyGraph, TestingBatchExecNode[]> tuple2 = this.buildTopologyGraph();
        TopologyGraph graph = (TopologyGraph)tuple2.f0;
        TestingBatchExecNode[] nodes = (TestingBatchExecNode[])tuple2.f1;
        graph.unlink((ExecNode)nodes[2], (ExecNode)nodes[5]);
        Assert.assertTrue((boolean)graph.canReach((ExecNode)nodes[0], (ExecNode)nodes[5]));
        graph.unlink((ExecNode)nodes[4], (ExecNode)nodes[5]);
        Assert.assertFalse((boolean)graph.canReach((ExecNode)nodes[0], (ExecNode)nodes[5]));
        graph.unlink((ExecNode)nodes[3], (ExecNode)nodes[6]);
        Assert.assertFalse((boolean)graph.canReach((ExecNode)nodes[0], (ExecNode)nodes[7]));
    }

    @Test
    public void testCalculateMaximumDistance() {
        Tuple2<TopologyGraph, TestingBatchExecNode[]> tuple2 = this.buildTopologyGraph();
        TopologyGraph graph = (TopologyGraph)tuple2.f0;
        TestingBatchExecNode[] nodes = (TestingBatchExecNode[])tuple2.f1;
        Map result = graph.calculateMaximumDistance();
        Assert.assertEquals((long)8L, (long)result.size());
        Assert.assertEquals((long)0L, (long)((Integer)result.get(nodes[0])).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(nodes[1])).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)result.get(nodes[2])).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)result.get(nodes[3])).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)result.get(nodes[4])).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)result.get(nodes[6])).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)result.get(nodes[5])).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)result.get(nodes[7])).intValue());
    }

    @Test
    public void testBoundedCalculateMaximumDistance() {
        Tuple2<TopologyGraph, TestingBatchExecNode[]> tuple2 = this.buildBoundedTopologyGraph();
        TopologyGraph graph = (TopologyGraph)tuple2.f0;
        TestingBatchExecNode[] nodes = (TestingBatchExecNode[])tuple2.f1;
        Map result = graph.calculateMaximumDistance();
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertEquals((long)0L, (long)((Integer)result.get(nodes[2])).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)result.get(nodes[3])).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(nodes[4])).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(nodes[6])).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)result.get(nodes[5])).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)result.get(nodes[7])).intValue());
    }

    @Test
    public void testMakeAsFarAs() {
        Tuple2<TopologyGraph, TestingBatchExecNode[]> tuple2 = this.buildTopologyGraph();
        TopologyGraph graph = (TopologyGraph)tuple2.f0;
        TestingBatchExecNode[] nodes = (TestingBatchExecNode[])tuple2.f1;
        graph.makeAsFarAs((ExecNode)nodes[4], (ExecNode)nodes[7]);
        Map distances = graph.calculateMaximumDistance();
        Assert.assertEquals((long)4L, (long)((Integer)distances.get(nodes[7])).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)distances.get(nodes[4])).intValue());
    }
}

