/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ContextResolvedTableJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
public class ContextResolvedTableSerdeTest {
    private static final ObjectIdentifier TEMPORARY_TABLE_IDENTIFIER = ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)"db1", (String)"my_temporary_table");
    private static final ObjectIdentifier PERMANENT_TABLE_IDENTIFIER = ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)"db1", (String)"my_permanent_table");
    private static final ResolvedSchema CATALOG_TABLE_RESOLVED_SCHEMA = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.BOOLEAN())), Collections.emptyList(), null);
    private static final Schema CATALOG_TABLE_SCHEMA = Schema.newBuilder().fromResolvedSchema(CATALOG_TABLE_RESOLVED_SCHEMA).build();
    private static final Map<String, String> CATALOG_OPTIONS = new HashMap<String, String>();
    private static final Map<String, String> PLAN_OPTIONS;
    private static final List<String> PARTITION_KEYS;
    private static final ResolvedCatalogTable RESOLVED_CATALOG_TABLE;
    private static final Catalog CATALOG;
    private static final CatalogManager CATALOG_MANAGER;
    private static final ContextResolvedTable ANONYMOUS_CONTEXT_RESOLVED_TABLE;
    private static final ContextResolvedTable TEMPORARY_CATALOG_CONTEXT_RESOLVED_TABLE;
    private static final ContextResolvedTable TEMPORARY_PLAN_CONTEXT_RESOLVED_TABLE;
    private static final ContextResolvedTable PERMANENT_CATALOG_CONTEXT_RESOLVED_TABLE;
    private static final ContextResolvedTable PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE;

    @Test
    void anonymousTable() throws Exception {
        Tuple2<JsonNode, ContextResolvedTable> result = this.serDe(ContextResolvedTableSerdeTest.serdeContext(TableConfigOptions.CatalogPlanCompilation.IDENTIFIER, TableConfigOptions.CatalogPlanRestore.IDENTIFIER), ANONYMOUS_CONTEXT_RESOLVED_TABLE);
        JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "identifier");
        JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable", "options");
        JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable", "comment");
        Assertions.assertThat((boolean)((ContextResolvedTable)result.f1).isAnonymous()).isTrue();
        Assertions.assertThat((Object)((ContextResolvedTable)result.f1).getResolvedTable()).isEqualTo((Object)ANONYMOUS_CONTEXT_RESOLVED_TABLE.getResolvedTable());
    }

    @Test
    void temporaryTable() throws Exception {
        Tuple2<JsonNode, ContextResolvedTable> result = this.serDe(ContextResolvedTableSerdeTest.serdeContext(TableConfigOptions.CatalogPlanCompilation.ALL, TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED), TEMPORARY_PLAN_CONTEXT_RESOLVED_TABLE);
        JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "identifier");
        JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "resolvedTable");
        Assertions.assertThat((Object)result.f1).isEqualTo((Object)TEMPORARY_CATALOG_CONTEXT_RESOLVED_TABLE);
    }

    @Test
    void temporaryTableAndMissingIdentifierInCatalog() throws Exception {
        SerdeContext ctx = ContextResolvedTableSerdeTest.serdeContext(TableConfigOptions.CatalogPlanCompilation.ALL, TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED);
        ObjectIdentifier objectIdentifier = ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)"db2", (String)"some-nonexistent-table");
        ContextResolvedTable spec = ContextResolvedTable.temporary((ObjectIdentifier)objectIdentifier, (ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)CATALOG_TABLE_SCHEMA, (String)"my amazing table", Collections.emptyList(), PLAN_OPTIONS), CATALOG_TABLE_RESOLVED_SCHEMA));
        byte[] actualSerialized = JsonSerdeUtil.createObjectWriter((SerdeContext)ctx).writeValueAsBytes((Object)spec);
        Assertions.assertThatThrownBy(() -> {
            ContextResolvedTable cfr_ignored_0 = (ContextResolvedTable)JsonSerdeUtil.createObjectReader((SerdeContext)ctx).readValue(actualSerialized, ContextResolvedTable.class);
        }).satisfies(FlinkAssertions.anyCauseMatches(TableException.class, (String)ContextResolvedTableJsonDeserializer.missingTableFromCatalog((ObjectIdentifier)objectIdentifier, (boolean)false).getMessage()));
    }

    private Tuple2<JsonNode, ContextResolvedTable> serDe(SerdeContext serdeCtx, ContextResolvedTable contextResolvedTable) throws Exception {
        byte[] actualSerialized = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeCtx).writeValueAsBytes((Object)contextResolvedTable);
        ObjectReader objectReader = JsonSerdeUtil.createObjectReader((SerdeContext)serdeCtx);
        JsonNode middleDeserialized = objectReader.readTree(actualSerialized);
        ContextResolvedTable actualDeserialized = (ContextResolvedTable)objectReader.readValue(actualSerialized, ContextResolvedTable.class);
        return Tuple2.of((Object)middleDeserialized, (Object)actualDeserialized);
    }

    private static SerdeContext serdeContext(TableConfigOptions.CatalogPlanCompilation planCompilationOption, TableConfigOptions.CatalogPlanRestore planRestoreOption) {
        TableConfig tableConfig = TableConfig.getDefault().set(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS, (Object)planRestoreOption).set(TableConfigOptions.PLAN_COMPILE_CATALOG_OBJECTS, (Object)planCompilationOption);
        return JsonSerdeTestUtil.configuredSerdeContext(CATALOG_MANAGER, tableConfig);
    }

    static {
        CATALOG_OPTIONS.put("a", "1");
        CATALOG_OPTIONS.put("b", "2");
        CATALOG_OPTIONS.put("c", "3");
        PLAN_OPTIONS = new HashMap<String, String>();
        PLAN_OPTIONS.put("a", "1");
        PLAN_OPTIONS.put("b", "10");
        PLAN_OPTIONS.put("d", "4");
        PARTITION_KEYS = Collections.singletonList("a");
        RESOLVED_CATALOG_TABLE = new ResolvedCatalogTable(CatalogTable.of((Schema)CATALOG_TABLE_SCHEMA, (String)"my comment", PARTITION_KEYS, CATALOG_OPTIONS), CATALOG_TABLE_RESOLVED_SCHEMA);
        CATALOG = new GenericInMemoryCatalog(CatalogManagerMocks.DEFAULT_CATALOG, "db1");
        CATALOG_MANAGER = CatalogManagerMocks.createCatalogManager((Catalog)CATALOG);
        CATALOG_MANAGER.createTable((CatalogBaseTable)RESOLVED_CATALOG_TABLE, PERMANENT_TABLE_IDENTIFIER, false);
        CATALOG_MANAGER.createTemporaryTable((CatalogBaseTable)RESOLVED_CATALOG_TABLE, TEMPORARY_TABLE_IDENTIFIER, false);
        ANONYMOUS_CONTEXT_RESOLVED_TABLE = ContextResolvedTable.anonymous((ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)CATALOG_TABLE_SCHEMA, (String)"my comment", PARTITION_KEYS, PLAN_OPTIONS), CATALOG_TABLE_RESOLVED_SCHEMA));
        TEMPORARY_CATALOG_CONTEXT_RESOLVED_TABLE = CATALOG_MANAGER.getTableOrError(TEMPORARY_TABLE_IDENTIFIER);
        TEMPORARY_PLAN_CONTEXT_RESOLVED_TABLE = ContextResolvedTable.temporary((ObjectIdentifier)TEMPORARY_TABLE_IDENTIFIER, (ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)CATALOG_TABLE_SCHEMA, (String)"my comment", PARTITION_KEYS, PLAN_OPTIONS), CATALOG_TABLE_RESOLVED_SCHEMA));
        PERMANENT_CATALOG_CONTEXT_RESOLVED_TABLE = CATALOG_MANAGER.getTableOrError(PERMANENT_TABLE_IDENTIFIER);
        PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE = ContextResolvedTable.permanent((ObjectIdentifier)PERMANENT_TABLE_IDENTIFIER, (Catalog)((Catalog)CATALOG_MANAGER.getCatalog(CatalogManagerMocks.DEFAULT_CATALOG).orElseThrow(AssertionError::new)), (ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)CATALOG_TABLE_SCHEMA, (String)"my comment", PARTITION_KEYS, PLAN_OPTIONS), CATALOG_TABLE_RESOLVED_SCHEMA));
    }

    @Nested
    @DisplayName(value="Test CatalogPlanCompilation == ALL")
    class TestCompileAll {
        TestCompileAll() {
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL_ENFORCED")
        class TestRestoreAllEnforced {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.ALL, TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED);

            TestRestoreAllEnforced() {
            }

            @Test
            void withPermanentTable() throws Exception {
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "identifier");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable", "options");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable", "comment");
                Assertions.assertThat((Object)result.f1).isEqualTo((Object)ContextResolvedTable.permanent((ObjectIdentifier)PERMANENT_TABLE_IDENTIFIER, (Catalog)CATALOG, (ResolvedCatalogBaseTable)PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE.getResolvedTable()));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL")
        class TestRestoreAll {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.ALL, TableConfigOptions.CatalogPlanRestore.ALL);

            TestRestoreAll() {
            }

            @Test
            void withPermanentTable() throws Exception {
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "identifier");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable", "options");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable", "comment");
                Assertions.assertThat((Object)result.f1).isEqualTo((Object)PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
            }

            @Test
            void withPermanentTableAndMissingIdentifierInCatalog() throws Exception {
                ObjectIdentifier objectIdentifier = ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)"db2", (String)"some-nonexistent-table");
                ContextResolvedTable spec = ContextResolvedTable.permanent((ObjectIdentifier)objectIdentifier, (Catalog)CATALOG, (ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)CATALOG_TABLE_SCHEMA, (String)"my amazing table", Collections.emptyList(), (Map)PLAN_OPTIONS), CATALOG_TABLE_RESOLVED_SCHEMA));
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, spec);
                Assertions.assertThat((Object)result.f1).isEqualTo((Object)ContextResolvedTable.temporary((ObjectIdentifier)objectIdentifier, (ResolvedCatalogBaseTable)spec.getResolvedTable()));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == IDENTIFIER")
        class TestRestoreIdentifier {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.ALL, TableConfigOptions.CatalogPlanRestore.IDENTIFIER);

            TestRestoreIdentifier() {
            }

            @Test
            void withPermanentTable() throws Exception {
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "identifier");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable", "options");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable", "comment");
                Assertions.assertThat((Object)result.f1).isEqualTo((Object)PERMANENT_CATALOG_CONTEXT_RESOLVED_TABLE);
            }
        }
    }

    @Nested
    @DisplayName(value="Test CatalogPlanCompilation == SCHEMA")
    class TestCompileSchema {
        TestCompileSchema() {
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL_ENFORCED")
        class TestRestoreAllEnforced {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.SCHEMA, TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED);

            TestRestoreAllEnforced() {
            }

            @Test
            void withPermanentTable() throws Exception {
                byte[] actualSerialized = JsonSerdeUtil.createObjectWriter((SerdeContext)this.ctx).writeValueAsBytes((Object)PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                Assertions.assertThatThrownBy(() -> {
                    ContextResolvedTable cfr_ignored_0 = (ContextResolvedTable)JsonSerdeUtil.createObjectReader((SerdeContext)this.ctx).readValue(actualSerialized, ContextResolvedTable.class);
                }).satisfies(FlinkAssertions.anyCauseMatches(TableException.class, (String)ContextResolvedTableJsonDeserializer.lookupDisabled((ObjectIdentifier)PERMANENT_TABLE_IDENTIFIER).getMessage()));
            }

            @Test
            void withShadowingTemporaryTable() throws Exception {
                ContextResolvedTable spec = ContextResolvedTable.permanent((ObjectIdentifier)TEMPORARY_TABLE_IDENTIFIER, (Catalog)CATALOG, (ResolvedCatalogBaseTable)RESOLVED_CATALOG_TABLE);
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, spec);
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "identifier");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable");
                Assertions.assertThat((boolean)((ContextResolvedTable)result.f1).isTemporary()).isTrue();
                Assertions.assertThat((Object)result.f1).isEqualTo((Object)CATALOG_MANAGER.getTableOrError(TEMPORARY_TABLE_IDENTIFIER));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL")
        class TestRestoreAll {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.SCHEMA, TableConfigOptions.CatalogPlanRestore.ALL);

            TestRestoreAll() {
            }

            @Test
            void withPermanentTable() throws Exception {
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "identifier");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable");
                JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "resolvedTable", "options");
                JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "resolvedTable", "comment");
                Assertions.assertThat((boolean)((ContextResolvedTable)result.f1).isPermanent()).isTrue();
                Assertions.assertThat((Object)((ContextResolvedTable)result.f1).getIdentifier()).isEqualTo((Object)PERMANENT_TABLE_IDENTIFIER);
                Assertions.assertThat((Object)((ContextResolvedTable)result.f1).getResolvedSchema()).isEqualTo((Object)CATALOG_TABLE_RESOLVED_SCHEMA);
                Assertions.assertThat((List)((ResolvedCatalogTable)((ContextResolvedTable)result.f1).getResolvedTable()).getPartitionKeys()).isEqualTo((Object)PARTITION_KEYS);
                Assertions.assertThat((Map)((ContextResolvedTable)result.f1).getResolvedTable().getOptions()).isEqualTo((Object)RESOLVED_CATALOG_TABLE.getOptions());
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == IDENTIFIER")
        class TestRestoreIdentifier {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.SCHEMA, TableConfigOptions.CatalogPlanRestore.IDENTIFIER);

            TestRestoreIdentifier() {
            }

            @Test
            void withPermanentTable() throws Exception {
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "identifier");
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "resolvedTable");
                JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "resolvedTable", "options");
                JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "resolvedTable", "comment");
                Assertions.assertThat((boolean)((ContextResolvedTable)result.f1).isPermanent()).isTrue();
                Assertions.assertThat((Optional)((ContextResolvedTable)result.f1).getCatalog()).containsSame((Object)CATALOG);
                Assertions.assertThat((Object)((ContextResolvedTable)result.f1).getIdentifier()).isEqualTo((Object)PERMANENT_TABLE_IDENTIFIER);
                Assertions.assertThat((Object)((ContextResolvedTable)result.f1).getResolvedSchema()).isEqualTo((Object)CATALOG_TABLE_RESOLVED_SCHEMA);
                Assertions.assertThat((Map)((ContextResolvedTable)result.f1).getResolvedTable().getOptions()).isEqualTo((Object)CATALOG_OPTIONS);
            }

            @Test
            void withDifferentSchema() throws Exception {
                ResolvedSchema resolvedSchema = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.STRING()), Column.physical((String)"c", (DataType)DataTypes.STRING())), Collections.emptyList(), null);
                ContextResolvedTable spec = ContextResolvedTable.permanent((ObjectIdentifier)PERMANENT_TABLE_IDENTIFIER, (Catalog)CATALOG, (ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)"my comment", (List)PARTITION_KEYS, (Map)PLAN_OPTIONS), resolvedSchema));
                byte[] actualSerialized = JsonSerdeUtil.createObjectWriter((SerdeContext)this.ctx).writeValueAsBytes((Object)spec);
                Assertions.assertThatThrownBy(() -> {
                    ContextResolvedTable cfr_ignored_0 = (ContextResolvedTable)JsonSerdeUtil.createObjectReader((SerdeContext)this.ctx).readValue(actualSerialized, ContextResolvedTable.class);
                }).satisfies(FlinkAssertions.anyCauseMatches(TableException.class, (String)ContextResolvedTableJsonDeserializer.schemaNotMatching((ObjectIdentifier)PERMANENT_TABLE_IDENTIFIER, (ResolvedSchema)resolvedSchema, (ResolvedSchema)CATALOG_TABLE_RESOLVED_SCHEMA).getMessage()));
            }
        }
    }

    @Nested
    @DisplayName(value="Test CatalogPlanCompilation == IDENTIFIER")
    class TestCompileIdentifier {
        TestCompileIdentifier() {
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL_ENFORCED")
        class TestRestoreAllEnforced {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.IDENTIFIER, TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED);

            TestRestoreAllEnforced() {
            }

            @Test
            void deserializationFail() throws Exception {
                byte[] actualSerialized = JsonSerdeUtil.createObjectWriter((SerdeContext)this.ctx).writeValueAsBytes((Object)PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                Assertions.assertThatThrownBy(() -> {
                    ContextResolvedTable cfr_ignored_0 = (ContextResolvedTable)JsonSerdeUtil.createObjectReader((SerdeContext)this.ctx).readValue(actualSerialized, ContextResolvedTable.class);
                }).satisfies(FlinkAssertions.anyCauseMatches(TableException.class, (String)ContextResolvedTableJsonDeserializer.lookupDisabled((ObjectIdentifier)PERMANENT_TABLE_IDENTIFIER).getMessage()));
            }

            @Test
            void withShadowingTemporaryTable() throws Exception {
                ContextResolvedTable spec = ContextResolvedTable.permanent((ObjectIdentifier)TEMPORARY_TABLE_IDENTIFIER, (Catalog)CATALOG, (ResolvedCatalogBaseTable)RESOLVED_CATALOG_TABLE);
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, spec);
                JsonSerdeTestUtil.assertThatJsonContains((JsonNode)result.f0, "identifier");
                JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "resolvedTable");
                Assertions.assertThat((boolean)((ContextResolvedTable)result.f1).isTemporary()).isTrue();
                Assertions.assertThat((Object)result.f1).isEqualTo((Object)CATALOG_MANAGER.getTableOrError(TEMPORARY_TABLE_IDENTIFIER));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == ALL")
        class TestRestoreAll {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.IDENTIFIER, TableConfigOptions.CatalogPlanRestore.ALL);

            TestRestoreAll() {
            }

            @Test
            void withPermanentTable() throws Exception {
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "resolvedTable");
                Assertions.assertThat((Object)result.f1).isEqualTo((Object)PERMANENT_CATALOG_CONTEXT_RESOLVED_TABLE);
            }

            @Test
            void withMissingIdentifierInCatalog() throws Exception {
                SerdeContext serdeCtx = ContextResolvedTableSerdeTest.serdeContext(TableConfigOptions.CatalogPlanCompilation.IDENTIFIER, TableConfigOptions.CatalogPlanRestore.ALL);
                ObjectIdentifier objectIdentifier = ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)"db2", (String)"some-invalid-table");
                ContextResolvedTable spec = ContextResolvedTable.permanent((ObjectIdentifier)objectIdentifier, (Catalog)CATALOG, (ResolvedCatalogBaseTable)new ResolvedCatalogTable(CatalogTable.of((Schema)CATALOG_TABLE_SCHEMA, null, Collections.emptyList(), (Map)PLAN_OPTIONS), CATALOG_TABLE_RESOLVED_SCHEMA));
                byte[] actualSerialized = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeCtx).writeValueAsBytes((Object)spec);
                Assertions.assertThatThrownBy(() -> {
                    ContextResolvedTable cfr_ignored_0 = (ContextResolvedTable)JsonSerdeUtil.createObjectReader((SerdeContext)serdeCtx).readValue(actualSerialized, ContextResolvedTable.class);
                }).satisfies(FlinkAssertions.anyCauseMatches(TableException.class, (String)ContextResolvedTableJsonDeserializer.missingTableFromCatalog((ObjectIdentifier)objectIdentifier, (boolean)false).getMessage()));
            }
        }

        @Nested
        @DisplayName(value="and CatalogPlanRestore == IDENTIFIER")
        class TestRestoreIdentifier {
            private final SerdeContext ctx = ContextResolvedTableSerdeTest.access$000(TableConfigOptions.CatalogPlanCompilation.IDENTIFIER, TableConfigOptions.CatalogPlanRestore.IDENTIFIER);

            TestRestoreIdentifier() {
            }

            @Test
            void withPermanentTable() throws Exception {
                Tuple2 result = ContextResolvedTableSerdeTest.this.serDe(this.ctx, PERMANENT_PLAN_CONTEXT_RESOLVED_TABLE);
                JsonSerdeTestUtil.assertThatJsonDoesNotContain((JsonNode)result.f0, "resolvedTable");
                Assertions.assertThat((Object)result.f1).isEqualTo((Object)PERMANENT_CATALOG_CONTEXT_RESOLVED_TABLE);
            }
        }
    }
}

