/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Collections;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;

class JsonSerdeTestUtil {
    private JsonSerdeTestUtil() {
    }

    static SerdeContext configuredSerdeContext() {
        return JsonSerdeTestUtil.configuredSerdeContext(CatalogManagerMocks.createEmptyCatalogManager(), TableConfig.getDefault());
    }

    static SerdeContext configuredSerdeContext(Configuration configuration) {
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.addConfiguration(configuration);
        return JsonSerdeTestUtil.configuredSerdeContext(CatalogManagerMocks.createEmptyCatalogManager(), configuration);
    }

    static SerdeContext configuredSerdeContext(CatalogManager catalogManager, Configuration configuration) {
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.addConfiguration(configuration);
        return JsonSerdeTestUtil.configuredSerdeContext(catalogManager, tableConfig);
    }

    static SerdeContext configuredSerdeContext(CatalogManager catalogManager, TableConfig tableConfig) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ModuleManager moduleManager = new ModuleManager();
        FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)tableConfig, catalogManager, moduleManager);
        PlannerContext plannerContext = new PlannerContext(false, tableConfig, moduleManager, functionCatalog, catalogManager, CalciteSchemaBuilder.asRootSchema((Schema)new CatalogManagerCalciteSchema(catalogManager, true)), Collections.emptyList());
        return new SerdeContext((Parser)new ParserImpl(null, null, () -> ((PlannerContext)plannerContext).createCalciteParser(), null), plannerContext.getFlinkContext(), classLoader, FlinkTypeFactory.INSTANCE(), plannerContext.createFrameworkConfig().getOperatorTable());
    }

    static String toJson(SerdeContext serdeContext, Object object) throws IOException {
        ObjectWriter objectWriter = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeContext);
        return objectWriter.writeValueAsString(object);
    }

    static <T> T toObject(SerdeContext serdeContext, String json, Class<T> clazz) throws IOException {
        ObjectReader objectReader = JsonSerdeUtil.createObjectReader((SerdeContext)serdeContext);
        return (T)objectReader.readValue(json, clazz);
    }

    static <T> T testJsonRoundTrip(SerdeContext serdeContext, T spec, Class<T> clazz) throws IOException {
        String actualJson = JsonSerdeTestUtil.toJson(serdeContext, spec);
        T actual = JsonSerdeTestUtil.toObject(serdeContext, actualJson, clazz);
        Assertions.assertThat(actual).isEqualTo(spec);
        return actual;
    }

    static <T> T testJsonRoundTrip(T spec, Class<T> clazz) throws IOException {
        return JsonSerdeTestUtil.testJsonRoundTrip(JsonSerdeTestUtil.configuredSerdeContext(), spec, clazz);
    }

    static void assertThatJsonContains(JsonNode json, String ... path) {
        JsonPointer jsonPointer = JsonSerdeTestUtil.pathToPointer(path);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Iterable)json).asInstanceOf(InstanceOfAssertFactories.type(ObjectNode.class))).as("Serialized json '%s'", new Object[]{json})).matches(o -> {
            JsonNode node = o.at(jsonPointer);
            return !node.isMissingNode() && !node.isNull();
        }, String.format("contains at pointer '%s' a not null value", jsonPointer));
    }

    static void assertThatJsonDoesNotContain(JsonNode json, String ... path) {
        JsonPointer jsonPointer = JsonSerdeTestUtil.pathToPointer(path);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Iterable)json).asInstanceOf(InstanceOfAssertFactories.type(ObjectNode.class))).as("Serialized json '%s'", new Object[]{json})).matches(o -> {
            JsonNode node = o.at(jsonPointer);
            return node.isMissingNode() || node.isNull();
        }, String.format("at pointer '%s' return missing node or null node", jsonPointer));
    }

    private static JsonPointer pathToPointer(String ... path) {
        JsonPointer pointer = JsonPointer.empty();
        for (String el : path) {
            pointer = pointer.append(JsonPointer.compile((String)('/' + el)));
        }
        return pointer;
    }
}

