/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.runtime.groupwindow.WindowReference;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LogicalWindowSerdeTest {
    @Parameterized.Parameter
    public LogicalWindow window;

    @Parameterized.Parameters(name="{0}")
    public static List<LogicalWindow> testData() {
        return Arrays.asList(new TumblingGroupWindow(new WindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofMinutes(10L))), new TumblingGroupWindow(new WindowReference("countWindow", (LogicalType)new BigIntType()), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)10L)), new SlidingGroupWindow(new WindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofSeconds(10L)), new ValueLiteralExpression((Object)Duration.ofSeconds(5L))), new SlidingGroupWindow(new WindowReference("countWindow", (LogicalType)new BigIntType()), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)10L), new ValueLiteralExpression((Object)5L)), new SessionGroupWindow(new WindowReference("timeWindow", (LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), new FieldReferenceExpression("rowTime", (DataType)new AtomicDataType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3)), 1, 2), new ValueLiteralExpression((Object)Duration.ofDays(10L))));
    }

    @Test
    public void testLogicalWindowSerde() throws IOException {
        SerdeContext serdeCtx = new SerdeContext(null, (FlinkContext)new FlinkContextImpl(false, TableConfig.getDefault(), new ModuleManager(), null, CatalogManagerMocks.createEmptyCatalogManager(), null), Thread.currentThread().getContextClassLoader(), FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectReader objectReader = JsonSerdeUtil.createObjectReader((SerdeContext)serdeCtx);
        ObjectWriter objectWriter = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeCtx);
        Assert.assertEquals((Object)objectReader.readValue(objectWriter.writeValueAsString((Object)this.window), LogicalWindow.class), (Object)this.window);
    }
}

