/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.VoidSerializer;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.typeutils.LogicalRelDataTypeConverterTest;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RawType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
public class RelDataTypeJsonSerdeTest {
    private static final FlinkTypeFactory FACTORY = FlinkTypeFactory.INSTANCE();

    @ParameterizedTest
    @MethodSource(value={"testRelDataTypeSerde"})
    public void testRelDataTypeSerde(RelDataType relDataType) throws IOException {
        SerdeContext serdeContext = JsonSerdeTestUtil.configuredSerdeContext();
        String json = JsonSerdeTestUtil.toJson(serdeContext, relDataType);
        RelDataType actual = JsonSerdeTestUtil.toObject(serdeContext, json, RelDataType.class);
        Assertions.assertThat((Object)actual).isSameAs((Object)relDataType);
    }

    @Test
    public void testMissingPrecisionAndScale() throws IOException {
        SerdeContext serdeContext = JsonSerdeTestUtil.configuredSerdeContext();
        String json = JsonSerdeTestUtil.toJson(serdeContext, FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO)));
        RelDataType actual = JsonSerdeTestUtil.toObject(serdeContext, json, RelDataType.class);
        Assertions.assertThat((Object)actual).isSameAs((Object)FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, 2, TimeUnit.SECOND, 6, SqlParserPos.ZERO)));
    }

    @Test
    public void testNegativeScale() throws IOException {
        SerdeContext serdeContext = JsonSerdeTestUtil.configuredSerdeContext();
        String json = JsonSerdeTestUtil.toJson(serdeContext, FACTORY.createSqlType(SqlTypeName.DECIMAL, 5, -1));
        RelDataType actual = JsonSerdeTestUtil.toObject(serdeContext, json, RelDataType.class);
        Assertions.assertThat((Object)actual).isSameAs((Object)FACTORY.createSqlType(SqlTypeName.DECIMAL, 6, 0));
    }

    public static List<RelDataType> testRelDataTypeSerde() {
        List<RelDataType> types = Arrays.asList(FACTORY.createSqlType(SqlTypeName.BOOLEAN), FACTORY.createSqlType(SqlTypeName.TINYINT), FACTORY.createSqlType(SqlTypeName.SMALLINT), FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.BIGINT), FACTORY.createSqlType(SqlTypeName.DECIMAL, 10, 3), FACTORY.createSqlType(SqlTypeName.DECIMAL, 19, 0), FACTORY.createSqlType(SqlTypeName.DECIMAL, 38, 19), FACTORY.createSqlType(SqlTypeName.FLOAT), FACTORY.createSqlType(SqlTypeName.DOUBLE), FACTORY.createSqlType(SqlTypeName.DATE), FACTORY.createSqlType(SqlTypeName.TIME), FACTORY.createSqlType(SqlTypeName.TIMESTAMP), FACTORY.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, 2, TimeUnit.MINUTE, -1, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.DAY, 6, TimeUnit.SECOND, 9, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.HOUR, -1, TimeUnit.SECOND, 9, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.MINUTE, -1, TimeUnit.SECOND, 0, SqlParserPos.ZERO)), FACTORY.createSqlIntervalType(new SqlIntervalQualifier(TimeUnit.SECOND, -1, TimeUnit.SECOND, 6, SqlParserPos.ZERO)), FACTORY.createSqlType(SqlTypeName.CHAR), FACTORY.createSqlType(SqlTypeName.CHAR, 0), FACTORY.createSqlType(SqlTypeName.CHAR, 32), FACTORY.createSqlType(SqlTypeName.VARCHAR), FACTORY.createSqlType(SqlTypeName.VARCHAR, 0), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10), FACTORY.createSqlType(SqlTypeName.BINARY), FACTORY.createSqlType(SqlTypeName.BINARY, 0), FACTORY.createSqlType(SqlTypeName.BINARY, 100), FACTORY.createSqlType(SqlTypeName.VARBINARY), FACTORY.createSqlType(SqlTypeName.VARBINARY, 0), FACTORY.createSqlType(SqlTypeName.VARBINARY, 1000), FACTORY.createSqlType(SqlTypeName.NULL), FACTORY.createSqlType(SqlTypeName.SYMBOL), FACTORY.createMultisetType(FACTORY.createSqlType(SqlTypeName.VARCHAR), -1L), FACTORY.createArrayType(FACTORY.createSqlType(SqlTypeName.VARCHAR, 16), -1L), FACTORY.createArrayType(FACTORY.createArrayType(FACTORY.createSqlType(SqlTypeName.VARCHAR, 16), -1L), -1L), FACTORY.createMapType(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10)), FACTORY.createMapType(FACTORY.createMapType(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10)), FACTORY.createArrayType(FACTORY.createMapType(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10)), -1L)), FACTORY.createStructType(StructKind.PEEK_FIELDS_NO_EXPAND, Arrays.asList(FACTORY.createSqlType(SqlTypeName.INTEGER), FACTORY.createSqlType(SqlTypeName.DECIMAL, 10, 3)), Arrays.asList("f1", "f2")), FACTORY.createStructType(StructKind.PEEK_FIELDS_NO_EXPAND, Arrays.asList(FACTORY.createSqlType(SqlTypeName.VARCHAR), FACTORY.createArrayType(FACTORY.createSqlType(SqlTypeName.VARCHAR, 16), -1L)), Arrays.asList("f1", "f2")), FACTORY.createStructType(StructKind.PEEK_FIELDS_NO_EXPAND, Arrays.asList(FACTORY.createStructType(StructKind.PEEK_FIELDS_NO_EXPAND, Arrays.asList(FACTORY.createSqlType(SqlTypeName.VARCHAR, 5), FACTORY.createSqlType(SqlTypeName.VARCHAR, 10)), Arrays.asList("f1", "f2")), FACTORY.createArrayType(FACTORY.createSqlType(SqlTypeName.VARCHAR, 16), -1L)), Arrays.asList("f3", "f4")), FACTORY.createRowtimeIndicatorType(true, false), FACTORY.createRowtimeIndicatorType(true, true), FACTORY.createProctimeIndicatorType(true), FACTORY.createFieldTypeFromLogicalType(LogicalRelDataTypeConverterTest.PojoClass.TYPE_WITH_IDENTIFIER));
        ArrayList<RelDataType> mutableTypes = new ArrayList<RelDataType>(types.size() * 2);
        for (RelDataType type : types) {
            mutableTypes.add(FACTORY.createTypeWithNullability(type, true));
            mutableTypes.add(FACTORY.createTypeWithNullability(type, false));
        }
        mutableTypes.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new RawType(true, Void.class, (TypeSerializer)VoidSerializer.INSTANCE)), true));
        mutableTypes.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new RawType(false, Void.class, (TypeSerializer)VoidSerializer.INSTANCE)), false));
        mutableTypes.add(FACTORY.createTypeWithNullability(FACTORY.createFieldTypeFromLogicalType((LogicalType)new RawType(true, Void.class, (TypeSerializer)VoidSerializer.INSTANCE)), false));
        return mutableTypes;
    }
}

