/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Assert;
import org.junit.Test;

public class RexWindowBoundSerdeTest {
    @Test
    public void testSerde() throws IOException {
        SerdeContext serdeCtx = new SerdeContext(null, (FlinkContext)new FlinkContextImpl(false, TableConfig.getDefault(), new ModuleManager(), null, CatalogManagerMocks.createEmptyCatalogManager(), null), Thread.currentThread().getContextClassLoader(), FlinkTypeFactory.INSTANCE(), (SqlOperatorTable)FlinkSqlOperatorTable.instance());
        ObjectReader objectReader = JsonSerdeUtil.createObjectReader((SerdeContext)serdeCtx);
        ObjectWriter objectWriter = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeCtx);
        Assert.assertEquals((Object)RexWindowBounds.CURRENT_ROW, (Object)objectReader.readValue(objectWriter.writeValueAsString((Object)RexWindowBounds.CURRENT_ROW), RexWindowBound.class));
        Assert.assertEquals((Object)RexWindowBounds.UNBOUNDED_FOLLOWING, (Object)objectReader.readValue(objectWriter.writeValueAsString((Object)RexWindowBounds.UNBOUNDED_FOLLOWING), RexWindowBound.class));
        Assert.assertEquals((Object)RexWindowBounds.UNBOUNDED_PRECEDING, (Object)objectReader.readValue(objectWriter.writeValueAsString((Object)RexWindowBounds.UNBOUNDED_PRECEDING), RexWindowBound.class));
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)FlinkTypeFactory.INSTANCE());
        RexWindowBound windowBound = RexWindowBounds.following((RexNode)builder.makeLiteral("test"));
        Assert.assertEquals((Object)windowBound, (Object)objectReader.readValue(objectWriter.writeValueAsString((Object)windowBound), RexWindowBound.class));
        windowBound = RexWindowBounds.preceding((RexNode)builder.makeLiteral("test"));
        Assert.assertEquals((Object)windowBound, (Object)objectReader.readValue(objectWriter.writeValueAsString((Object)windowBound), RexWindowBound.class));
    }
}

