/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.FlinkFilterJoinRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001'\t9b\t\\5oW\u001aKG\u000e^3s\u0015>LgNU;mKR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0006\r\u0005)!/\u001e7fg*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0013\u0001B;uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\u000bM,G/\u001e9\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\"\u0012q%\r\t\u0003eUj\u0011a\r\u0006\u0003iA\tQA[;oSRL!AN\u001a\u0003\r\t+gm\u001c:f\u0011\u0015A\u0004\u0001\"\u0001*\u0003m!Xm\u001d;GS2$XM\u001d)vg\"$un\u001e8MK\u001a$8+Z7jc!\u0012qG\u000f\t\u0003emJ!\u0001P\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006}\u0001!\t!K\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000eT3giN+W.\u001b\u001a)\u0005uR\u0004\"B!\u0001\t\u0003I\u0013a\u0007;fgR4\u0015\u000e\u001c;feB+8\u000f\u001b#po:dUM\u001a;TK6L7\u0007\u000b\u0002Au!)A\t\u0001C\u0001S\u0005\u0011C/Z:u\u0015>LgnQ8oI&$\u0018n\u001c8QkNDGi\\<o\u0019\u00164GoU3nSFB#a\u0011\u001e\t\u000b\u001d\u0003A\u0011A\u0015\u0002EQ,7\u000f\u001e&pS:\u001cuN\u001c3ji&|g\u000eU;tQ\u0012{wO\u001c'fMR\u001cV-\\53Q\t1%\bC\u0003K\u0001\u0011\u0005\u0011&\u0001\u0012uKN$(j\\5o\u0007>tG-\u001b;j_:\u0004Vo\u001d5E_^tG*\u001a4u'\u0016l\u0017n\r\u0015\u0003\u0013jBQ!\u0014\u0001\u0005\u0002%\n1\u0004^3ti\u001aKG\u000e^3s!V\u001c\b\u000eR8x]2+g\r^!oi&\f\u0004F\u0001';\u0011\u0015\u0001\u0006\u0001\"\u0001*\u0003m!Xm\u001d;GS2$XM\u001d)vg\"$un\u001e8MK\u001a$\u0018I\u001c;je!\u0012qJ\u000f\u0005\u0006'\u0002!\t!K\u0001\u001ci\u0016\u001cHOR5mi\u0016\u0014\b+^:i\t><h\u000eT3gi\u0006sG/[\u001a)\u0005IS\u0004\"\u0002,\u0001\t\u0003I\u0013a\u0007;fgR4\u0015\u000e\u001c;feB+8\u000f\u001b#po:dUM\u001a;B]RLG\u0007\u000b\u0002Vu!)\u0011\f\u0001C\u0001S\u0005\u0011C/Z:u\u0015>LgnQ8oI&$\u0018n\u001c8QkNDGi\\<o\u0019\u00164G/\u00118uSFB#\u0001\u0017\u001e\t\u000bq\u0003A\u0011A\u0015\u0002EQ,7\u000f\u001e&pS:\u001cuN\u001c3ji&|g\u000eU;tQ\u0012{wO\u001c'fMR\fe\u000e^53Q\tY&\bC\u0003`\u0001\u0011\u0005\u0011&\u0001\u0012uKN$(j\\5o\u0007>tG-\u001b;j_:\u0004Vo\u001d5E_^tG*\u001a4u\u0003:$\u0018n\r\u0015\u0003=jBQA\u0019\u0001\u0005\u0002%\n!\u0005^3ti*{\u0017N\\\"p]\u0012LG/[8o!V\u001c\b\u000eR8x]2+g\r^!oi&$\u0004FA1;\u0001")
public class FlinkFilterJoinRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_COLLECTION()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_PROJECT_TRANSPOSE, CoreRules.FILTER_INTO_JOIN, CoreRules.JOIN_CONDITION_PUSH})).build());
        this.util().addTableSource("leftT", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.FlinkFilterJoinRuleTest$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("rightT", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.FlinkFilterJoinRuleTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testFilterPushDownLeftSemi1() {
        String sqlQuery = "SELECT * FROM (SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT)) T WHERE T.b > 2";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testFilterPushDownLeftSemi2() {
        String sqlQuery = "SELECT * FROM (SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT)) T WHERE T.b > 2";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testFilterPushDownLeftSemi3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (SELECT * FROM leftT WHERE EXISTS\n        |    (SELECT * FROM rightT WHERE a = c)) T WHERE T.b > 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testJoinConditionPushDownLeftSemi1() {
        this.util().verifyRelPlan("SELECT * FROM leftT WHERE a IN (SELECT c FROM rightT WHERE b > 2)");
    }

    @Test
    public void testJoinConditionPushDownLeftSemi2() {
        this.util().verifyRelPlan("SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE b > 2)");
    }

    @Test
    public void testJoinConditionPushDownLeftSemi3() {
        this.util().verifyRelPlan("SELECT * FROM leftT WHERE EXISTS (SELECT * FROM rightT WHERE a = c AND b > 2)");
    }

    @Test
    public void testFilterPushDownLeftAnti1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (SELECT * FROM leftT WHERE a NOT IN\n        |    (SELECT c FROM rightT WHERE c < 3)) T WHERE T.b > 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testFilterPushDownLeftAnti2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (SELECT * FROM leftT WHERE NOT EXISTS\n        |    (SELECT * FROM rightT where c > 10)) T WHERE T.b > 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testFilterPushDownLeftAnti3() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (SELECT * FROM leftT WHERE a NOT IN\n        |(SELECT c FROM rightT WHERE b = d AND c < 3)) T WHERE T.b > 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testFilterPushDownLeftAnti4() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (SELECT * FROM leftT WHERE NOT EXISTS\n        |    (SELECT * FROM rightT WHERE a = c)) T WHERE T.b > 2\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testJoinConditionPushDownLeftAnti1() {
        this.util().verifyRelPlan("SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b > 2)");
    }

    @Test
    public void testJoinConditionPushDownLeftAnti2() {
        this.util().verifyRelPlan("SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE b > 2)");
    }

    @Test
    public void testJoinConditionPushDownLeftAnti3() {
        String sqlQuery = "SELECT * FROM leftT WHERE a NOT IN (SELECT c FROM rightT WHERE b = d AND b > 1)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testJoinConditionPushDownLeftAnti4() {
        String sqlQuery = "SELECT * FROM leftT WHERE NOT EXISTS (SELECT * FROM rightT WHERE a = c AND b > 2)";
        this.util().verifyRelPlan(sqlQuery);
    }
}

