/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.junit.Before;
import org.junit.Test;

public class WrapJsonAggFunctionArgumentsRuleTest
extends TableTestBase {
    private StreamTableTestUtil util;

    @Before
    public void before() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
    }

    @Test
    public void testJsonObjectAgg() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build()).unboundedScanSource(ChangelogMode.all()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT JSON_OBJECTAGG(f0 VALUE f0) FROM T");
    }

    @Test
    public void testJsonObjectAggInGroupWindow() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).column("f1", (AbstractDataType)DataTypes.STRING()).build()).unboundedScanSource().build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f0, JSON_OBJECTAGG(f1 VALUE f0) FROM T GROUP BY f0");
    }

    @Test
    public void testJsonArrayAgg() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build()).unboundedScanSource(ChangelogMode.all()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT JSON_ARRAYAGG(f0) FROM T");
    }

    @Test
    public void testJsonArrayAggInGroupWindow() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build()).unboundedScanSource().build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f0, JSON_ARRAYAGG(f0) FROM T GROUP BY f0");
    }
}

