/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.functions.aggregate.CollectAggFunction;
import org.junit.Before;
import org.junit.Test;

public class PushLocalAggIntoTableSourceScanRuleTest
extends TableTestBase {
    protected BatchTableTestUtil util = this.batchTestUtil(new TableConfig());

    @Before
    public void setup() {
        TableConfig tableConfig = this.util.tableEnv().getConfig();
        tableConfig.set(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_AGGREGATE_PUSHDOWN_ENABLED, (Object)true);
        String ddl = "CREATE TABLE inventory (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  type STRING\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'id;type',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl);
        String ddl2 = "CREATE TABLE inventory_meta (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  type STRING,\n  metadata_1 BIGINT METADATA,\n  metadata_2 STRING METADATA,\n  PRIMARY KEY (`id`) NOT ENFORCED\n) WITH (\n 'connector' = 'values',\n 'filterable-fields' = 'id;type',\n 'readable-metadata' = 'metadata_1:BIGINT, metadata_2:STRING',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl2);
        String ddl3 = "CREATE TABLE inventory_part (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  type STRING\n) PARTITIONED BY (type)\nWITH (\n 'connector' = 'values',\n 'filterable-fields' = 'id;type',\n 'partition-list' = 'type:a;type:b',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl3);
        String ddl4 = "CREATE TABLE inventory_no_proj (\n  id BIGINT,\n  name STRING,\n  amount BIGINT,\n  price BIGINT,\n  type STRING\n)\nWITH (\n 'connector' = 'values',\n 'filterable-fields' = 'id;type',\n 'enable-projection-push-down' = 'false',\n 'bounded' = 'true'\n)";
        this.util.tableEnv().executeSql(ddl4);
    }

    @Test
    public void testCanPushDownLocalHashAggWithGroup() {
        this.util.verifyRelPlan("SELECT\n  sum(amount),\n  name,\n  type\nFROM inventory\n  group by name, type");
    }

    @Test
    public void testDisablePushDownLocalAgg() {
        this.util.getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_AGGREGATE_PUSHDOWN_ENABLED, (Object)false);
        this.util.verifyRelPlan("SELECT\n  sum(amount),\n  name,\n  type\nFROM inventory\n  group by name, type");
        this.util.getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_AGGREGATE_PUSHDOWN_ENABLED, (Object)true);
    }

    @Test
    public void testCanPushDownLocalHashAggWithoutGroup() {
        this.util.verifyRelPlan("SELECT\n  min(id),\n  max(amount),\n  sum(price),\n  avg(price),\n  count(id)\nFROM inventory");
    }

    @Test
    public void testCanPushDownLocalSortAggWithoutSort() {
        this.util.getTableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.util.verifyRelPlan("SELECT\n  min(id),\n  max(amount),\n  sum(price),\n  avg(price),\n  count(id)\nFROM inventory");
        this.util.getTableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"");
    }

    @Test
    public void testCanPushDownLocalSortAggWithSort() {
        this.util.getTableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.util.verifyRelPlan("SELECT\n  sum(amount),\n  name,\n  type\nFROM inventory\n  group by name, type");
        this.util.getTableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"");
    }

    @Test
    public void testCanPushDownLocalAggAfterFilterPushDown() {
        this.util.verifyRelPlan("SELECT\n  sum(amount),\n  name,\n  type\nFROM inventory\n  where id = 123\n  group by name, type");
    }

    @Test
    public void testCanPushDownLocalAggWithMetadata() {
        this.util.verifyRelPlan("SELECT\n  sum(amount),\n  max(metadata_1),\n  name,\n  type\nFROM inventory_meta\n  where id = 123\n  group by name, type");
    }

    @Test
    public void testCanPushDownLocalAggWithPartition() {
        this.util.verifyRelPlan("SELECT\n  sum(amount),\n  type,\n  name\nFROM inventory_part\n  where type in ('a', 'b') and id = 123\n  group by type, name");
    }

    @Test
    public void testCanPushDownLocalAggWithoutProjectionPushDown() {
        this.util.verifyRelPlan("SELECT\n  sum(amount),\n  name,\n  type\nFROM inventory_no_proj\n  where id = 123\n  group by name, type");
    }

    @Test
    public void testCanPushDownLocalAggWithAuxGrouping() {
        this.util.getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"TWO_PHASE");
        this.util.verifyRelPlan("SELECT\n  id, name, count(*)\nFROM inventory_meta\n  group by id, name");
    }

    @Test
    public void testCannotPushDownLocalAggAfterLimitPushDown() {
        this.util.verifyRelPlan("SELECT\n  sum(amount),\n  name,\n  type\nFROM (\n  SELECT\n    *\n  FROM inventory\n  LIMIT 100\n) t\n  group by name, type");
    }

    @Test
    public void testCannotPushDownLocalAggWithUDAF() {
        this.util.addTemporarySystemFunction("udaf_collect", (UserDefinedFunction)new CollectAggFunction(DataTypes.BIGINT().getLogicalType()));
        this.util.verifyRelPlan("SELECT\n  udaf_collect(amount),\n  name,\n  type\nFROM inventory\n  group by name, type");
    }

    @Test
    public void testCannotPushDownLocalAggWithUnsupportedDataTypes() {
        this.util.verifyRelPlan("SELECT\n  max(name),\n  type\nFROM inventory\n  group by type");
    }

    @Test
    public void testCannotPushDownWithColumnExpression() {
        this.util.verifyRelPlan("SELECT\n  min(amount + price),\n  max(amount),\n  sum(price),\n  count(id),\n  name\nFROM inventory\n  group by name");
    }

    @Test
    public void testCannotPushDownWithUnsupportedAggFunction() {
        this.util.verifyRelPlan("SELECT\n  min(id),\n  max(amount),\n  sum(price),\n  count(distinct id),\n  name\nFROM inventory\n  group by name");
    }

    @Test
    public void testCannotPushDownWithWindowAggFunction() {
        this.util.verifyRelPlan("SELECT\n  id,\n  amount,\n  sum(price) over (partition by name),\n  name\nFROM inventory");
    }

    @Test
    public void testCannotPushDownWithArgFilter() {
        this.util.verifyRelPlan("SELECT\n  min(id),\n  max(amount),\n  sum(price),\n  count(id) FILTER(WHERE id > 100),\n  name\nFROM inventory\n  group by name");
    }
}

