/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.junit.Before;
import org.junit.Test;

public class PushFilterPastChangelogNormalizeRuleTest
extends TableTestBase {
    private StreamTableTestUtil util;

    @Before
    public void before() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
    }

    @Test
    public void testWithSinglePrimaryKeyFilter() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).primaryKey(new String[]{"f1"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT * FROM T WHERE f1 < 1");
    }

    @Test
    public void testWithMultipleFilters() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).column("f2", (AbstractDataType)DataTypes.STRING()).primaryKey(new String[]{"f1"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f1, SUM(f1) AS `sum` FROM T WHERE f1 < 10 AND (f1 > 3 OR f2 IS NULL) GROUP BY f1");
    }

    @Test
    public void testWithMultiplePrimaryKeyColumns() {
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", DataTypes.INT().notNull()).column("f2", DataTypes.BIGINT().notNull()).primaryKey(new String[]{"f1", "f2"}).build()).unboundedScanSource(ChangelogMode.upsert()).build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
        this.util.verifyRelPlan("SELECT f0, f1 FROM T WHERE (f1 < 1 OR f2 > 10) AND f0 IS NOT NULL");
    }
}

