/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001M\u0011Q\u0002V1cY\u0016\u001c\u0016N\\6UKN$(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e)\u0006\u0014G.\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0005kRLG.F\u0001#!\t)2%\u0003\u0002%-\t\u00192\u000b\u001e:fC6$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQ\u0005^3ti&s7/\u001a:u/&$\b\u000eV1sO\u0016$8i\u001c7v[:\u001c\u0018I\u001c3Tc2D\u0015N\u001c;\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\"\u0012q%\r\t\u0003eUj\u0011a\r\u0006\u0003iA\tQA[;oSRL!AN\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006q\u0001!\t!K\u0001#i\u0016\u001cH/\u00138tKJ$X*[:nCR\u001c\u0007\u000eV=qK\u001a{'/R7qif\u001c\u0005.\u0019:)\u0005]\n\u0004\"B\u001e\u0001\t\u0003I\u0013A\u0007;fgR,\u0005pY3qi&|gNR8s\u0003B\u0004XM\u001c3TS:\\\u0007F\u0001\u001e2\u0011\u0015q\u0004\u0001\"\u0001*\u0003u!Xm\u001d;Fq\u000e,\u0007\u000f^5p]\u001a{'o\u0014<fe\u0006;wM]3hCR,\u0007FA\u001f2\u0011\u0015\t\u0005\u0001\"\u0001*\u00039!Xm\u001d;BaB,g\u000eZ*j].D#\u0001Q\u0019\t\u000b\u0011\u0003A\u0011A\u0015\u0002!Q,7\u000f\u001e*fiJ\f7\r^*j].\f\u0004FA\"2\u0011\u00159\u0005\u0001\"\u0001*\u0003A!Xm\u001d;SKR\u0014\u0018m\u0019;TS:\\'\u0007\u000b\u0002Gc!)!\n\u0001C\u0001S\u0005qA/Z:u+B\u001cXM\u001d;TS:\\\u0007FA%2\u0011\u0015i\u0005\u0001\"\u0001*\u0003a!Xm\u001d;VaN,'\u000f^*j].<\u0016\u000e\u001e5GS2$XM\u001d\u0015\u0003\u0019FBQ\u0001\u0015\u0001\u0005\u0002%\n\u0001\u0004^3tiJ+GO]1di\u0006sG-\u00169tKJ$8+\u001b8lQ\ty\u0015\u0007C\u0003T\u0001\u0011\u0005\u0011&\u0001\u0010uKN$\u0018\t\u001d9f]\u0012,\u0006o]3si\u0006sGMU3ue\u0006\u001cGoU5oW\"\u0012!+\r\u0005\u0006-\u0002!\t!K\u0001-i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8G_J<&/\u001b;j]\u001e4\u0016N\u001d;vC2lU\r^1eCR\f7i\u001c7v[:D#!V\u0019\t\u000be\u0003A\u0011A\u0015\u0002YQ,7\u000f^#yG\u0016\u0004H/[8o\r>\u0014xK]5uS:<\u0017J\u001c<bY&$W*\u001a;bI\u0006$\u0018mQ8mk6t\u0007F\u0001-2\u0011\u0015a\u0006\u0001\"\u0001*\u0003I!Xm\u001d;NKR\fG-\u0019;b\u0007>dW/\u001c8)\u0005m\u000b\u0004\"B0\u0001\t\u0003I\u0013!\r;fgRlU\r^1eCR\f7i\u001c7v[:$\u0006.\u0019;D_:4G.[2ug^KG\u000f\u001b)isNL7-\u00197D_2,XN\u001c\u0015\u0003=FBQA\u0019\u0001\u0005\u0002%\n\u0011\u0005^3tiNKgn\u001b#jg>\u0014H-\u001a:DQ\u0006tw-\u001a'pO^KG\u000f\u001b&pS:D#!Y\u0019\t\u000b\u0015\u0004A\u0011A\u0015\u0002CQ,7\u000f^*j].$\u0015n]8sI\u0016\u00148\t[1oO\u0016dunZ,ji\"\u0014\u0016M\\6)\u0005\u0011\f\u0004\"\u00025\u0001\t\u0003I\u0013!\n;fgR\f\u0005\u000f]3oIN#(/Z1n)>\u001c\u0016N\\6XSRD\u0007k[!vi>\\U-\u001f\"zQ\t9\u0017\u0007C\u0003l\u0001\u0011\u0005\u0011&A\u0012uKN$\u0018\t\u001d9f]\u0012\u001cFO]3b[R{7+\u001b8l/&$\b\u000eU6O_.+\u0017PQ=)\u0005)\f\u0004\"\u00028\u0001\t\u0003I\u0013A\n;fgR\f\u0005\u000f]3oIN#(/Z1n)>\u001c\u0016N\\6XSRD\u0007k\u001b$pe\u000e,7*Z=Cs\"\u0012Q.\r\u0005\u0006c\u0002!\t!K\u00018i\u0016\u001cHoU5oO2,\u0007+\u0019:bY2,G.[:n\u0003B\u0004XM\u001c3TiJ,\u0017-\u001c+p'&t7nV5uQB[gi\u001c:dK.+\u0017PQ=)\u0005A\f\u0004\"\u0002;\u0001\t\u0003I\u0013!\u000b;fgR\f\u0005\u000f]3oIN#(/Z1n)>\u001c\u0016N\\6XSRDw.\u001e;QW\u001a{'oY3LKf\u0014\u0015\u0010\u000b\u0002tc!)q\u000f\u0001C\u0001S\u0005QD/Z:u\u0003B\u0004XM\u001c3TiJ,\u0017-\u001c+p'&t7nV5uQ>,H\u000fU6G_J\u001cWmS3z\u0005f\u001c\u0016N\\4mKB\u000b'/\u00197mK2L7/\u001c\u0015\u0003mFBQA\u001f\u0001\u0005\u0002%\n1\u0007^3ti\u000eC\u0017M\\4fY><7\u000b\u001e:fC6$vnU5oW^KG\u000f\u001b)l\t&4g-\u001a:f]R\u0004\u0016M]1mY\u0016d\u0017n]7)\u0005e\f\u0004\"B?\u0001\t\u0003I\u0013\u0001\r;fgR\u001c\u0005.\u00198hK2|wm\u0015;sK\u0006lGk\\*j].<\u0016\u000e\u001e5QWNKgn\u001a7f!\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000e\u000b\u0002}c!1\u0011\u0011\u0001\u0001\u0005\u0002%\nA\u0006^3ti6\u000bg.Y4fIR\u000b'\r\\3TS:\\w+\u001b;i\t&\u001c\u0018M\u00197f\u0007\",7m\u001b9pS:$\u0018N\\4)\u0005}\f\u0004BBA\u0004\u0001\u0011\u0005\u0011&A\u0016uKN$X*\u00198bO\u0016$G+\u00192mKNKgn[,ji\",e.\u00192mK\u000eCWmY6q_&tG/\u001b8hQ\r\t)!\r\u0005\u0007\u0003\u001b\u0001A\u0011A\u0015\u0002)Q,7\u000f^%og\u0016\u0014H\u000fU1si\u000e{G.^7oQ\r\tY!\r")
public class TableSinkTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testInsertWithTargetColumnsAndSqlHint() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT,\n                     |  `b` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink /*+ OPTIONS('sink.parallelism' = '1') */(a, b) SELECT a + b, c FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInsertMismatchTypeForEmptyChar() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE my_sink (\n                     |  name STRING,\n                     |  email STRING,\n                     |  message_offset BIGINT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Query schema: [a: INT, EXPR$1: CHAR(0) NOT NULL, EXPR$2: CHAR(0) NOT NULL]\nSink schema:  [name: STRING, email: STRING, message_offset: BIGINT]");
        this.util().verifyExecPlanInsert("INSERT INTO my_sink SELECT a, '', '' FROM MyTable");
    }

    @Test
    public void testExceptionForAppendSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("Table sink 'default_catalog.default_database.appendSink' doesn't support consuming update changes which is produced by node GroupAggregate(groupBy=[a], select=[a, COUNT(*) AS cnt])");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testExceptionForOverAggregate() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink1 (\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink2 (\n                     |  `cnt` BIGINT,\n                     |  `total` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink1 SELECT * FROM TempTable");
        stmtSet.addInsertSql("INSERT INTO retractSink2 SELECT cnt, SUM(cnt) OVER (ORDER BY PROCTIME()) FROM TempTable");
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("OverAggregate doesn't support consuming update changes which is produced by node GroupAggregate(groupBy=[a], select=[a, COUNT(*) AS cnt])");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testAppendSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` BIGINT,\n                     |  `b` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT a + b, c FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractSink1() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractSink2() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `cnt` BIGINT,\n                     |  `a` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        String dml = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO retractSink\n        |SELECT cnt, COUNT(a) AS a FROM (\n        |    SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a) t\n        |GROUP BY cnt\n      ")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(dml);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testUpsertSinkWithFilter() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO upsertSink\n        |SELECT *\n        |FROM (SELECT a, COUNT(*) AS cnt FROM MyTable GROUP BY a)\n        |WHERE cnt < 10\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRetractAndUpsertSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `b` BIGINT,\n                     |  `cnt` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `b` BIGINT,\n                     |  `cnt` BIGINT,\n                     |  PRIMARY KEY (b) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT b, COUNT(a) AS cnt FROM MyTable GROUP BY b");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT b, cnt FROM TempTable WHERE b < 4");
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT b, cnt FROM TempTable WHERE b >= 4 AND b < 6");
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT cnt, COUNT(b) AS frequency FROM TempTable WHERE b < 4 GROUP BY cnt");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testAppendUpsertAndRetractSink() {
        this.util().addDataStream("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE appendSink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        Table table = this.util().tableEnv().sqlQuery("SELECT a, b FROM MyTable UNION ALL SELECT d, e FROM MyTable2");
        this.util().tableEnv().createTemporaryView("TempTable", table);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO appendSink SELECT * FROM TempTable");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE retractSink (\n                     |  `total_sum` INT\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        Table table1 = this.util().tableEnv().sqlQuery("SELECT a, b FROM TempTable UNION ALL SELECT i, j FROM MyTable3");
        this.util().tableEnv().createTemporaryView("TempTable1", table1);
        stmtSet.addInsertSql("INSERT INTO retractSink SELECT SUM(a) AS total_sum FROM TempTable1");
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE upsertSink (\n                     |  `a` INT,\n                     |  `total_min` BIGINT,\n                     |  PRIMARY KEY (a) NOT ENFORCED\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'false'\n                     |)\n                     |")).stripMargin());
        stmtSet.addInsertSql("INSERT INTO upsertSink SELECT a, MIN(b) AS total_min FROM TempTable1 GROUP BY a");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testExceptionForWritingVirtualMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MetadataTable (\n         |  `a` INT,\n         |  `m_3` INT METADATA FROM 'metadata_3' VIRTUAL,\n         |  `m_2` INT METADATA FROM 'metadata_2',\n         |  `b` BIGINT,\n         |  `c` INT,\n         |  `metadata_1` STRING METADATA\n         |) WITH (\n         |  'connector' = 'values',\n         |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT, metadata_3:BIGINT',\n         |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n         |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT *\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Query schema: [a: INT, m_3: INT, m_2: INT, b: BIGINT, c: INT, metadata_1: STRING]\nSink schema:  [a: INT, m_2: INT, b: BIGINT, c: INT, metadata_1: STRING]");
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testExceptionForWritingInvalidMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE MetadataTable (\n                     |  `a` INT,\n                     |  `metadata_1` TIMESTAMP(3) METADATA\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'writable-metadata' = 'metadata_1:BOOLEAN'\n                     |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT TIMESTAMP '1990-10-14 06:00:00.000'\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.thrown().expect(ValidationException.class);
        this.thrown().expectMessage("Invalid data type for metadata column 'metadata_1' of table 'default_catalog.default_database.MetadataTable'. The column cannot be declared as 'TIMESTAMP(3)' because the type must be castable to metadata type 'BOOLEAN'.");
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testMetadataColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE MetadataTable (\n         |  `a` INT,\n         |  `m_3` INT METADATA FROM 'metadata_3' VIRTUAL,\n         |  `m_2` INT METADATA FROM 'metadata_2',\n         |  `b` BIGINT,\n         |  `c` INT,\n         |  `metadata_1` STRING METADATA\n         |) WITH (\n         |  'connector' = 'values',\n         |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT, metadata_3:BIGINT',\n         |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n         |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT `a`, `m_2`, `b`, `c`, `metadata_1`\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testMetadataColumnThatConflictsWithPhysicalColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE MetadataTable (\n                     |  `metadata_1` DOUBLE,\n                     |  `m_1` STRING METADATA FROM 'metadata_1' VIRTUAL,\n                     |  `m_2` BIGINT METADATA FROM 'metadata_2',\n                     |  `metadata_2` DOUBLE,\n                     |  `other` STRING\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'readable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT',\n                     |  'writable-metadata' = 'metadata_1:STRING, metadata_2:BIGINT'\n                     |)\n       ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO MetadataTable\n        |SELECT `metadata_1`, `m_2`, `metadata_2`, `other`\n        |FROM MetadataTable\n        |")).stripMargin();
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql(sql);
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testSinkDisorderChangeLogWithJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE SinkJoinChangeLog (\n                               |  person STRING, votes BIGINT, prize DOUBLE,\n                               |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                               |  'connector' = 'values',\n                               |  'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlanInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO SinkJoinChangeLog\n        |SELECT T.person, T.sum_votes, award.prize FROM\n        |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T, award\n        |   WHERE T.sum_votes = award.votes\n        |")).stripMargin());
    }

    @Test
    public void testSinkDisorderChangeLogWithRank() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE SinkRankChangeLog (\n                               |  person STRING, votes BIGINT,\n                               |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                               |  'connector' = 'values',\n                               |  'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlanInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO SinkRankChangeLog\n        |SELECT person, sum_votes FROM\n        | (SELECT person, sum_votes,\n        |   ROW_NUMBER() OVER (PARTITION BY vote_section ORDER BY sum_votes DESC) AS rank_number\n        |   FROM (SELECT person, SUM(votes) AS sum_votes, SUM(votes) / 2 AS vote_section FROM src\n        |      GROUP BY person))\n        |   WHERE rank_number < 10\n        |")).stripMargin());
    }

    @Test
    public void testAppendStreamToSinkWithPkAutoKeyBy() {
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '9'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithPkNoKeyBy() {
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.NONE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '9'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '4'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testSingleParallelismAppendStreamToSinkWithPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(1);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key (id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithoutPkForceKeyBy() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '4'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testAppendStreamToSinkWithoutPkForceKeyBySingleParallelism() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testChangelogStreamToSinkWithPkDifferentParallelism() {
        this.util().getStreamEnv().setParallelism(1);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.AUTO);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'changelog-mode' = 'I,UB,UA,D'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '2'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql("insert into sink select * from source");
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testChangelogStreamToSinkWithPkSingleParallelism() {
        this.util().getStreamEnv().setParallelism(4);
        TableEnvironment tEnv = this.util().tableEnv();
        tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_KEYED_SHUFFLE, (Object)ExecutionConfigOptions.SinkKeyedShuffle.FORCE);
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table source (\n                      | id varchar,\n                      | city_name varchar,\n                      | ts bigint\n                      |) with (\n                      | 'connector' = 'test_source'\n                      |)")).stripMargin());
        tEnv.executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |create table sink (\n                      | id varchar,\n                      | city_name varchar,\n                      | ts bigint,\n                      | rn bigint,\n                      | primary key(id) not enforced\n                      |) with (\n                      | 'connector' = 'values',\n                      | 'sink-insert-only' = 'false',\n                      | 'sink.parallelism' = '1'\n                      |)")).stripMargin());
        StatementSet stmtSet = ((TestingTableEnvironment)tEnv).createStatementSet();
        stmtSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                            |insert into sink\n                            |select * from (\n                            |  select *, row_number() over (partition by id order by ts desc) rn\n                            |  from source\n                            |) where rn=1")).stripMargin());
        this.util().verifyExplain(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.JSON_EXECUTION_PLAN}));
    }

    @Test
    public void testManagedTableSinkWithDisableCheckpointing() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT,\n                     |  `c` STRING\n                     |) WITH(\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT * FROM MyTable");
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage(new StringBuilder(193).append("You should enable the checkpointing for sinking to managed table ").append("'default_catalog.default_database.sink', ").append("managed table relies on checkpoint to commit and ").append("the data is visible only after commit.").toString());
        this.util().verifyAstPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testManagedTableSinkWithEnableCheckpointing() {
        this.util().getStreamEnv().enableCheckpointing(10L);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT,\n                     |  `c` STRING\n                     |) WITH(\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT * FROM MyTable");
        this.util().verifyAstPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInsertPartColumn() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE zm_test (\n                     |  `a` BIGINT,\n                     |  `m1` MAP<STRING, BIGINT>,\n                     |  `m2` MAP<STRING NOT NULL, BIGINT>,\n                     |  `m3` MAP<STRING, BIGINT NOT NULL>,\n                     |  `m4` MAP<STRING NOT NULL, BIGINT NOT NULL>\n                     |) WITH (\n                     |  'connector' = 'values',\n                     |  'sink-insert-only' = 'true'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO zm_test(`a`) SELECT `a` FROM MyTable");
        this.util().verifyRelPlan(stmtSet, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    public TableSinkTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.TableSinkTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE src (person String, votes BIGINT) WITH(\n                             |  'connector' = 'values'\n                             |)\n                             |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n      |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n      |  'connector' = 'values'\n      |)\n      |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n      |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n      |  'connector' = 'values'\n      |)\n      |")).stripMargin());
    }
}

