/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001'\tyA+\u00192mKN{WO]2f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013\u0001\u000b;fgR$\u0016M\u00197f'>,(oY3XSRDG+[7fgR\fW\u000e\u001d*poRKW.\u001a$jK2$G#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\t\u0002\u000b),h.\u001b;\n\u0005Y\u001a$\u0001\u0002+fgRDQ\u0001\u000f\u0001\u0005\u0002%\n1\u0005^3tiR\u000b'\r\\3T_V\u00148-Z,ji\"\u001cv.\u001e:dK^\u000bG/\u001a:nCJ\\7\u000f\u000b\u00028c!)1\b\u0001C\u0001S\u0005\tC/Z:u%><H+[7f)\u0006\u0014G.Z*pkJ\u001cWm\u0012:pkB<\u0016N\u001c3po\"\u0012!(\r\u0005\u0006}\u0001!\t!K\u0001\u001ci\u0016\u001cH\u000f\u0015:pGRLW.Z(o/\u0006$XM]7be.\u001c\u0006/Z2)\u0005u\n\u0004\"B!\u0001\t\u0003I\u0013!\u0007;fgR\u0004&o\u001c6fGR<\u0016\u000e\u001e5pkR\u0014vn\u001e;j[\u0016D#\u0001Q\u0019\t\u000b\u0011\u0003A\u0011A\u0015\u00025Q,7\u000f\u001e)s_*,7\r^,ji\"|W\u000f\u001e)s_\u000e$\u0018.\\3)\u0005\r\u000b\u0004\"B$\u0001\t\u0003I\u0013A\u0006;fgR\u0004&o\u001c6fGR|e\u000e\\=S_^$\u0018.\\3)\u0005\u0019\u000b\u0004\"\u0002&\u0001\t\u0003I\u0013!\u0005;fgRtUm\u001d;fIB\u0013xN[3di\"\u0012\u0011*\r\u0005\u0006\u001b\u0002!\t!K\u0001\u001bi\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ>,H/\u00138qkR\u0014VM\u001a\u0015\u0003\u0019FBQ\u0001\u0015\u0001\u0005\u0002%\nQ\u0004^3ti:+7\u000f^3e!J|'.Z2u/&$\b.T3uC\u0012\fG/\u0019\u0015\u0003\u001fFBQa\u0015\u0001\u0005\u0002%\nq\u0004^3ti:{g*Z:uK\u0012\u0004&o\u001c6fGR<\u0016\u000e\u001e5NKR\fG-\u0019;bQ\t\u0011\u0016\u0007C\u0003W\u0001\u0011%q+A\u0011uKN$h*Z:uK\u0012\u0004&o\u001c6fGR<\u0016\u000e\u001e5NKR\fG-\u0019;b\u0005\u0006\u001cX\r\u0006\u0002+1\")\u0011,\u0016a\u00015\u0006\u00013/\u001e9q_J$8OT3ti\u0016$\u0007K]8kK\u000e$\u0018n\u001c8QkNDGi\\<o!\tY3,\u0003\u0002]Y\t9!i\\8mK\u0006t\u0007\"\u00020\u0001\t\u0003I\u0013!\u0007;fgRtUm\u001d;fIB\u0013xN[3di^KG\u000f[%uK6D#!X\u0019\t\u000b\u0005\u0004A\u0011\u00022\u0002IA\u0014X\r]1sK\u0012#GnV5uQB+8\u000f\u001b)s_*,7\r^!oI6+G/\u0019#bi\u0006$2AK2f\u0011\u0015!\u0007\r1\u0001[\u0003I\u0001(o\u001c6fGRLwN\u001c)vg\"$un\u001e8\t\u000b\u0019\u0004\u0007\u0019\u0001.\u0002\u0013I,\u0017\rZ:NKR\f\u0007\"\u00025\u0001\t\u0003I\u0013a\t;fgR\u0014V-\u00193t\u001b\u0016$\u0018\rR1uC^KG\u000f\u001b#jM\u001a,'/\u001a8u\u001fJ$WM\u001d\u0015\u0003OFBQa\u001b\u0001\u0005\u0002%\n!\u0006^3tiJ+\u0017\rZ:NKR\fG)\u0019;b/&$\bn\\;u!J|'.Z2uS>t\u0007+^:i\t><h\u000e\u000b\u0002kc!)a\u000e\u0001C\u0001S\u0005\u0001D/Z:u%\u0016\fGm]\"p[B,H/\u001a3D_2,XN\\,ji\"|W\u000f\u001e)s_*,7\r^5p]B+8\u000f\u001b#po:D#!\\\u0019\t\u000bE\u0004A\u0011A\u0015\u0002[Q,7\u000f\u001e*fC\u0012\u001c8i\\7qkR,GmQ8mk6tw+\u001b;i!J|'.Z2uS>t\u0007+^:i\t><h\u000e\u000b\u0002qc!)A\u000f\u0001C\u0001S\u00059C/Z:u%\u0016\fGm]'fi\u0006$\u0015\r^1XSRD\u0007K]8kK\u000e$\u0018n\u001c8QkNDGi\\<oQ\t\u0019\u0018\u0007C\u0003x\u0001\u0011\u0005\u0011&\u0001\u000euKN$\bK]8kK\u000e$\u0018n\u001c8QkNDGi\\<o\u001f:d\u0017\u0010\u000b\u0002wc\u0001")
public class TableSourceTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testTableSourceWithTimestampRowTimeField() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rowtime, id, name, val FROM rowTimeT");
    }

    @Test
    public void testTableSourceWithSourceWatermarks() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id INT,\n         |  rowtime TIMESTAMP(3),\n         |  val BIGINT,\n         |  name VARCHAR(32),\n         |  WATERMARK FOR rowtime AS SOURCE_WATERMARK()\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false',\n         |  'disable-lookup' = 'true',\n         |  'enable-watermark-push-down' = 'true'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rowtime, id, name, val FROM rowTimeT");
    }

    @Test
    public void testRowTimeTableSourceGroupWindow() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE rowTimeT (\n         |  id int,\n         |  rowtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  watermark for rowtime as rowtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT name,\n        |    TUMBLE_END(rowtime, INTERVAL '10' MINUTE),\n        |    AVG(val)\n        |FROM rowTimeT WHERE val > 100\n        |   GROUP BY name, TUMBLE(rowtime, INTERVAL '10' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProctimeOnWatermarkSpec() {
        this.thrown().expect(TableException.class);
        this.thrown().expect(FlinkMatchers.containsMessage((String)"A watermark can not be defined for a processing-time attribute."));
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE procTimeT (\n         |  id int,\n         |  val bigint,\n         |  name varchar(32),\n         |  pTime as PROCTIME(),\n         |  watermark for pTime as pTime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT pTime, id, name, val FROM procTimeT");
    }

    @Test
    public void testProjectWithoutRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT ptime, name, val, id FROM T");
    }

    @Test
    public void testProjectWithoutProctime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("select name, val, rtime, id from T");
    }

    @Test
    public void testProjectOnlyRowtime() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  rtime timestamp(3),\n         |  val bigint,\n         |  name varchar(32),\n         |  ptime as PROCTIME(),\n         |  watermark for rtime as rtime\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT rtime FROM T");
    }

    @Test
    public void testNestedProject() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'true',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |FROM T\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testProjectWithoutInputRef() {
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |  id int,\n         |  name varchar(32)\n         |) WITH (\n         |  'connector' = 'values',\n         |  'bounded' = 'false'\n         |)\n       ")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        this.util().verifyExecPlan("SELECT COUNT(1) FROM T");
    }

    @Test
    public void testNestedProjectWithMetadata() {
        this.testNestedProjectWithMetadataBase(true);
    }

    @Test
    public void testNoNestedProjectWithMetadata() {
        this.testNestedProjectWithMetadataBase(false);
    }

    private void testNestedProjectWithMetadataBase(boolean supportsNestedProjectionPushDown) {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(487).append("\n         |CREATE TABLE T (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |    nested2 row<num int, flag boolean>>,\n         |  metadata_1 int metadata,\n         |  metadata_2 string metadata\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = '").append(supportsNestedProjectionPushDown).append("',\n         |  'bounded' = 'true',\n         |  'readable-metadata' = 'metadata_1:INT, metadata_2:STRING, metadata_3:BIGINT'\n         |)\n         |").toString())).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT id,\n        |       deepNested.nested1 AS nested1,\n        |       deepNested.nested1.`value` + deepNested.nested2.num + metadata_1 as results\n        |FROM T\n        |")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedProjectWithItem() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE NestedItemTable (\n         |  `id` INT,\n         |  `name` STRING,\n         |  `result` ROW<\n         |     `data_arr` ROW<`value` BIGINT> ARRAY,\n         |     `data_map` MAP<STRING, ROW<`value` BIGINT>>>,\n         |  `extra` STRING\n         |  ) WITH (\n         |    'connector' = 'values',\n         |    'nested-projection-supported' = 'true',\n         |    'bounded' = 'true'\n         |)\n         |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  `result`.`data_arr`[`id`].`value`,\n         |  `result`.`data_map`['item'].`value`\n         |FROM NestedItemTable\n         |")).stripMargin());
    }

    private void prepareDdlWithPushProjectAndMetaData(boolean projectionPushDown, boolean readsMeta) {
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n         |CREATE TABLE src (\n         |  id int,\n         |  name varchar,\n         |  tags varchar ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  op varchar ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  ts timestamp(3) ").append((Object)(readsMeta ? "METADATA VIRTUAL" : "")).append(",\n         |  ts1 as ts + interval '10' second\n         |) WITH (\n         |  'connector' = 'values',\n         |  ").append((Object)(readsMeta ? "'readable-metadata'='tags:varchar,op:varchar,ts:timestamp(3)'," : "")).append("\n         |  'enable-projection-push-down' = '").append(projectionPushDown).append("'\n         |)").toString())).stripMargin();
        this.util().tableEnv().executeSql(ddl);
    }

    @Test
    public void testReadsMetaDataWithDifferentOrder() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT ts, id, name, tags, op FROM src");
    }

    @Test
    public void testReadsMetaDataWithoutProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT id, ts, tags FROM src");
    }

    @Test
    public void testReadsComputedColumnWithoutProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(false, true);
        this.util().verifyExecPlan("SELECT id, ts1, op FROM src");
    }

    @Test
    public void testReadsComputedColumnWithProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(true, true);
        this.util().verifyExecPlan("SELECT id, ts1, op FROM src");
    }

    @Test
    public void testReadsMetaDataWithProjectionPushDown() {
        this.prepareDdlWithPushProjectAndMetaData(true, true);
        this.util().verifyExecPlan("SELECT id, ts, tags FROM src");
    }

    @Test
    public void testProjectionPushDownOnly() {
        this.prepareDdlWithPushProjectAndMetaData(true, false);
        this.util().verifyExecPlan("SELECT id, ts1, tags FROM src");
    }
}

