/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001U\u0011\u0001BS8j]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0019\u0019HO]3b[*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!9!\u0005\u0001b\u0001\n\u0013\u0019\u0013\u0001B;uS2,\u0012\u0001\n\t\u0003/\u0015J!A\n\r\u0003'M#(/Z1n)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r!\u0002\u0001\u0015!\u0003%\u0003\u0015)H/\u001b7!\u0011\u0015Q\u0003\u0001\"\u0001,\u0003%\"Xm\u001d;EKB,g\u000eZ3oi\u000e{g\u000eZ5uS>tG)\u001a:jm\u0006$\u0018n\u001c8J]:,'OS8j]V\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\bFA\u00154!\t!t'D\u00016\u0015\t1$#A\u0003kk:LG/\u0003\u00029k\t!A+Z:u\u0011\u0015Q\u0004\u0001\"\u0001,\u0003E\"Xm\u001d;EKB,g\u000eZ3oi\u000e{g\u000eZ5uS>tG)\u001a:jm\u0006$\u0018n\u001c8J]:,'OS8j]^KG\u000f\u001b+sk\u0016D#!O\u001a\t\u000bu\u0002A\u0011A\u0016\u0002cQ,7\u000f\u001e#fa\u0016tG-\u001a8u\u0007>tG-\u001b;j_:$UM]5wCRLwN\\%o]\u0016\u0014(j\\5o/&$\bNT;mY\"\u0012Ah\r\u0005\u0006\u0001\u0002!\t!Q\u0001\u000ei\u0016\u001cH/\u00138oKJTu.\u001b8\u0015\u00031B#aP\u001a\t\u000b\u0011\u0003A\u0011A!\u00021Q,7\u000f^%o]\u0016\u0014(j\\5o/&$\b.R9vC2\u00046\u000e\u000b\u0002Dg!)q\t\u0001C\u0001\u0003\u0006\u0019B/Z:u\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5QW\"\u0012ai\r\u0005\u0006\u0015\u0002!\t!Q\u0001\u0014i\u0016\u001cH\u000fT3gi*{\u0017N\u001c(p]\u0016\u000bX/\u001b\u0015\u0003\u0013NBQ!\u0014\u0001\u0005\u0002\u0005\u000ba\u0004^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5FcV\fG\u000eU6O_:,\u0015/^5)\u00051\u001b\u0004\"\u0002)\u0001\t\u0003\t\u0015!\t;fgRdUM\u001a;K_&tw+\u001b;i%&<\u0007\u000e\u001e(piB[gj\u001c8FcVL\u0007FA(4\u0011\u0015\u0019\u0006\u0001\"\u0001B\u0003e!Xm\u001d;MK\u001a$(j\\5o/&$\b\u000eU6O_:,\u0015/^5)\u0005I\u001b\u0004\"\u0002,\u0001\t\u0003\t\u0015\u0001\u0004;fgRdUM\u001a;K_&t\u0007FA+4\u0011\u0015I\u0006\u0001\"\u0001B\u0003]!Xm\u001d;MK\u001a$(j\\5o/&$\b.R9vC2\u00046\u000e\u000b\u0002Yg!)A\f\u0001C\u0001\u0003\u0006QB/Z:u\u0019\u00164GOS8j]^KG\u000f\u001b*jO\"$hj\u001c;QW\"\u00121l\r\u0005\u0006?\u0002!\t!Q\u0001\u0013i\u0016\u001cH\u000fT3gi*{\u0017N\\,ji\"\u00046\u000e\u000b\u0002_g!)!\r\u0001C\u0001\u0003\u0006!B/Z:u%&<\u0007\u000e\u001e&pS:tuN\\#rk&D#!Y\u001a\t\u000b\u0015\u0004A\u0011A!\u0002?Q,7\u000f\u001e*jO\"$(j\\5o/&$\b.R9vC2\u00046NT8o\u000bF,\u0018\u000e\u000b\u0002eg!)\u0001\u000e\u0001C\u0001\u0003\u0006\u0011C/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5SS\u001eDGOT8u!.tuN\\#rk&D#aZ\u001a\t\u000b-\u0004A\u0011A!\u00025Q,7\u000f\u001e*jO\"$(j\\5o/&$\b\u000eU6O_:,\u0015/^5)\u0005)\u001c\u0004\"\u00028\u0001\t\u0003\t\u0015!\u0004;fgR\u0014\u0016n\u001a5u\u0015>Lg\u000e\u000b\u0002ng!)\u0011\u000f\u0001C\u0001\u0003\u0006AB/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5FcV\fG\u000eU6)\u0005A\u001c\u0004\"\u0002;\u0001\t\u0003\t\u0015a\u0007;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQJKw\r\u001b;O_R\u00046\u000e\u000b\u0002tg!)q\u000f\u0001C\u0001\u0003\u0006\u0019B/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5QW\"\u0012ao\r\u0005\u0006u\u0002!\t!Q\u0001\u0014i\u0016\u001cHOR;mY*{\u0017N\u001c(p]\u0016\u000bX/\u001b\u0015\u0003sNBQ! \u0001\u0005\u0002\u0005\u000ba\u0004^3ti\u001a+H\u000e\u001c&pS:<\u0016\u000e\u001e5FcV\fG\u000eU6O_:,\u0015/^5)\u0005q\u001c\u0004BBA\u0001\u0001\u0011\u0005\u0011)\u0001\u0011uKN$h)\u001e7m\u0015>LgnV5uQ\u001a+H\u000e\u001c(piB[gj\u001c8FcVL\u0007FA@4\u0011\u0019\t9\u0001\u0001C\u0001\u0003\u0006IB/Z:u\rVdGNS8j]^KG\u000f\u001b)l\u001d>tW)];jQ\r\t)a\r\u0005\u0007\u0003\u001b\u0001A\u0011A!\u0002\u0019Q,7\u000f\u001e$vY2Tu.\u001b8)\u0007\u0005-1\u0007\u0003\u0004\u0002\u0014\u0001!\t!Q\u0001\u0018i\u0016\u001cHOR;mY*{\u0017N\\,ji\",\u0015/^1m!.D3!!\u00054\u0011\u0019\tI\u0002\u0001C\u0001\u0003\u0006IB/Z:u\rVdGNS8j]^KG\u000f\u001b$vY2tu\u000e\u001e)lQ\r\t9b\r\u0005\u0007\u0003?\u0001A\u0011A!\u0002%Q,7\u000f\u001e$vY2Tu.\u001b8XSRD\u0007k\u001b\u0015\u0004\u0003;\u0019\u0004BBA\u0013\u0001\u0011\u0005\u0011)\u0001\tuKN$8+\u001a7g\u0015>Lg\u000e\u00157b]\"\u001a\u00111E\u001a\t\r\u0005-\u0002\u0001\"\u0001B\u0003A!Xm\u001d;K_&tw+\u001b;i'>\u0014H\u000fK\u0002\u0002*MBa!!\r\u0001\t\u0003\t\u0015!\u0007;fgRdUM\u001a;PkR,'OS8j]\u0016\u000bX/\u001b)sK\u0012D3!a\f4\u0011\u0019\t9\u0004\u0001C\u0001\u0003\u0006\tC/Z:u\u0019\u00164GoT;uKJTu.\u001b8FcVL\u0017I\u001c3M_\u000e\fG\u000e\u0015:fI\"\u001a\u0011QG\u001a\t\r\u0005u\u0002\u0001\"\u0001B\u0003\r\"Xm\u001d;MK\u001a$x*\u001e;fe*{\u0017N\\#rk&\fe\u000e\u001a(p]\u0016\u000bX/\u001b)sK\u0012D3!a\u000f4\u0011\u0019\t\u0019\u0005\u0001C\u0001\u0003\u0006QB/Z:u%&<\u0007\u000e^(vi\u0016\u0014(j\\5o\u000bF,\u0018\u000e\u0015:fI\"\u001a\u0011\u0011I\u001a\t\r\u0005%\u0003\u0001\"\u0001B\u0003\t\"Xm\u001d;SS\u001eDGoT;uKJTu.\u001b8FcVL\u0017I\u001c3M_\u000e\fG\u000e\u0015:fI\"\u001a\u0011qI\u001a\t\r\u0005=\u0003\u0001\"\u0001B\u0003\u0011\"Xm\u001d;SS\u001eDGoT;uKJTu.\u001b8FcVL\u0017I\u001c3O_:,\u0015/^5Qe\u0016$\u0007fAA'g!1\u0011Q\u000b\u0001\u0005\u0002\u0005\u000bQ\u0006^3ti*{\u0017N\\!oIN+G.Z2u\u001f:\u0004\u0016M\u001d;jC2\u001cu.\u001c9pg&$X\r\u0015:j[\u0006\u0014\u0018pS3zQ\r\t\u0019f\r\u0005\u0007\u00037\u0002A\u0011A!\u00023Q,7\u000f\u001e&pS:$\u0015n]8sI\u0016\u00148\t[1oO\u0016dun\u001a\u0015\u0004\u00033\u001a\u0004BBA1\u0001\u0011\u0005\u0011)A\u0013uKN$(j\\5o\u001fV$\b/\u001e;VaN,'\u000f^&fs:{G/T1uG\"\u001c\u0016N\\6QW\"\u001a\u0011qL\u001a\t\r\u0005\u001d\u0004\u0001\"\u0001B\u0003}!Xm\u001d;K_&tw*\u001e;qkR,\u0006o]3si.+\u00170\u00138TS:\\\u0007k\u001b\u0015\u0004\u0003K\u001a\u0004BBA7\u0001\u0011\u0005\u0011)A\u0013uKN$(j\\5o\u001fV$\b/\u001e;M_N$X\u000b]:feR\\U-_,ji\"\u001c\u0016N\\6QW\"\u001a\u00111N\u001a")
public class JoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testDependentConditionDerivationInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON (a1 = 1 AND b1 = 1) OR (a2 = 2 AND b2 = 2)");
    }

    @Test
    public void testDependentConditionDerivationInnerJoinWithTrue() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON (a1 = 1 AND b1 = 1) OR (a2 = 2 AND true)");
    }

    @Test
    public void testDependentConditionDerivationInnerJoinWithNull() {
        this.util().verifyExecPlan("SELECT * FROM t JOIN s ON (a = 1 AND x = 1) OR (a = 2 AND y is null)");
    }

    @Test
    public void testInnerJoin() {
        this.util().verifyExecPlan("SELECT a1, b1 FROM A JOIN B ON a1 = b1");
    }

    @Test
    public void testInnerJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(40).append("SELECT a1, b1 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testInnerJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(48).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(56).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(65).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A LEFT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(44).append("SELECT a1, b1 FROM (").append(query1).append(") LEFT JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testLeftJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(53).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") LEFT JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(58).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(66).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoin() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A RIGHT JOIN B ON a1 = b1", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(46).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithRightNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") RIGHT JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testRightJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A group by a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B group by b1";
        String query = new StringBuilder(54).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") RIGHT JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinNonEqui() {
        this.util().verifyRelPlan("SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1 AND a2 > b2", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(57).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(56).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN B ON a1 = b1 AND a2 > b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPkNonEqui() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(65).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a2 = b2 AND a1 > b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoin() {
        String query = "SELECT a1, b1 FROM A FULL JOIN B ON a1 = b1";
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithEqualPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(45).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithFullNotPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query = new StringBuilder(44).append("SELECT a1, b1 FROM (").append(query1).append(") FULL JOIN B ON a1 = b1").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFullJoinWithPk() {
        String query1 = "SELECT SUM(a2) AS a2, a1 FROM A GROUP BY a1";
        String query2 = "SELECT SUM(b2) AS b2, b1 FROM B GROUP BY b1";
        String query = new StringBuilder(53).append("SELECT a1, a2, b1, b2 FROM (").append(query1).append(") FULL JOIN (").append(query2).append(") ON a2 = b2").toString();
        this.util().verifyRelPlan(query, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSelfJoinPlan() {
        this.util().addTableSource("src", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "key")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "v"))}), new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$12 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM (\n         |  SELECT * FROM src WHERE key = 0) src1\n         |LEFT OUTER JOIN (\n         |  SELECT * FROM src WHERE key = 0) src2\n         |ON (src1.key = src2.key AND src2.key > 10)\n       ")).stripMargin();
        this.util().verifyRelPlan(sql, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinWithSort() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "j")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "t"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$13 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable4", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))}), new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  MyTable3 FULL JOIN\n        |  (SELECT * FROM MyTable4 ORDER BY MyTable4.i DESC, MyTable4.k ASC) MyTable4\n        |  ON MyTable3.i = MyTable4.i and MyTable3.i = MyTable4.k\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testLeftOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z");
    }

    @Test
    public void testLeftOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < 2");
    }

    @Test
    public void testLeftOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t LEFT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testRightOuterJoinEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z");
    }

    @Test
    public void testRightOuterJoinEquiAndLocalPred() {
        this.util().verifyExecPlan("SELECT b, x FROM t RIGHT OUTER JOIN s ON a = z AND x < 2");
    }

    @Test
    public void testRightOuterJoinEquiAndNonEquiPred() {
        this.util().verifyExecPlan("SELECT b, y FROM t RIGHT OUTER JOIN s ON a = z AND b < x");
    }

    @Test
    public void testJoinAndSelectOnPartialCompositePrimaryKey() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE tableWithCompositePk (\n                               |  pk1 INT,\n                               |  pk2 BIGINT,\n                               |  PRIMARY KEY (pk1, pk2) NOT ENFORCED\n                               |) WITH (\n                               |  'connector'='values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT A.a1 FROM A LEFT JOIN tableWithCompositePk T ON A.a1 = T.pk1");
    }

    @Test
    public void testJoinDisorderChangeLog() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (person String, votes BIGINT) WITH(\n                               |  'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n        |  'connector' = 'values'\n        |)\n        |")).stripMargin());
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                          |SELECT T1.person, T1.sum_votes, T1.prize, T2.age FROM\n                          | (SELECT T.person, T.sum_votes, award.prize FROM\n                          |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T,\n                          |   award\n                          |   WHERE T.sum_votes = award.votes) T1, people T2\n                          | WHERE T1.person = T2.person\n                          |")).stripMargin());
    }

    @Test
    public void testJoinOutputUpsertKeyNotMatchSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_id varchar,\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t1.city_id, t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinOutputUpsertKeyInSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_id varchar,\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_id, city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t1.city_id, t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testJoinOutputLostUpsertKeyWithSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_city (\n                               | id varchar,\n                               | city_name varchar,\n                               | primary key (id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table source_customer (\n                               | customer_id varchar,\n                               | city_id varchar,\n                               | age int,\n                               | gender varchar,\n                               | update_time timestamp(3),\n                               | primary key (customer_id) not enforced\n                               |) with (\n                               | 'connector' = 'values',\n                               | 'changelog-mode' = 'I,UA,D'\n                               |)\n                               |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |create table sink (\n                               | city_name varchar,\n                               | customer_cnt bigint,\n                               | primary key (city_name) not enforced\n                               |) with (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |insert into sink\n        |select t2.city_name, t1.customer_cnt\n        | from (select city_id, count(*) customer_cnt from source_customer group by city_id) t1\n        | join source_city t2 on t1.city_id = t2.id\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    public JoinTest() {
        this.util().addTableSource("A", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("B", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b3"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("s", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "x")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "y")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "z"))}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.join.JoinTest$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

