/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.trait.MiniBatchInterval;
import org.apache.flink.table.planner.plan.trait.MiniBatchMode;
import org.apache.flink.table.planner.plan.utils.ExpandTableScanShuttle;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtilTest$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001#\t\u0019b\t\\5oWJ+Gn\u00149u+RLG\u000eV3ti*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0005\u001f\u0001\u0001\u0007\t\u0019!C\u0001?\u0005AA/\u00192mK\u0016sg/F\u0001!!\t\tC%D\u0001#\u0015\t\u0019\u0003\"A\u0002ba&L!!\n\u0012\u0003!Q\u000b'\r\\3F]ZL'o\u001c8nK:$\b\"C\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001)\u00031!\u0018M\u00197f\u000b:4x\fJ3r)\tIC\u0006\u0005\u0002\u0014U%\u00111\u0006\u0006\u0002\u0005+:LG\u000fC\u0004.M\u0005\u0005\t\u0019\u0001\u0011\u0002\u0007a$\u0013\u0007C\u00050\u0001\u0001\u0007\t\u0011)Q\u0005A\u0005IA/\u00192mK\u0016sg\u000f\t\u0005\u0006c\u0001!\tAM\u0001\u0007E\u00164wN]3\u0015\u0003%B#\u0001\r\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]r\u0011!\u00026v]&$\u0018BA\u001d7\u0005\u0019\u0011UMZ8sK\")1\b\u0001C\u0001e\u0005aA/Z:u)>\u001cFO]5oO\"\u0012!(\u0010\t\u0003kyJ!a\u0010\u001c\u0003\tQ+7\u000f\u001e\u0005\u0006\u0003\u0002!\tAM\u0001!i\u0016\u001cHoR3u\t&<Wm\u001d;XSRDG)\u001f8b[&\u001cg)\u001e8di&|g\u000e\u000b\u0002A{!)A\t\u0001C\u0001e\u0005!C/Z:u\u000f\u0016$H)[4fgR<\u0016\u000e\u001e5Es:\fW.[2Gk:\u001cG/[8o-&,w\u000f\u000b\u0002D{!)q\t\u0001C\u0001e\u00059B/Z:u\u001b\u0016\u0014x-\u001a*poRKW.Z!oI:{g.\u001a\u0015\u0003\rvBQA\u0013\u0001\u0005\u0002I\n\u0001\u0004^3ti6+'oZ3Qe>\u001cG+[7f\u0003:$gj\u001c8fQ\tIU\bC\u0003N\u0001\u0011\u0005!'A\u000fuKN$X*\u001a:hKJ{w\u000fV5nKR\u000be\u000e\u001a)s_\u000e$\u0016.\\32Q\taU\bC\u0003Q\u0001\u0011\u0005!'A\u000fuKN$X*\u001a:hKJ{w\u000fV5nKR\u000be\u000e\u001a)s_\u000e$\u0016.\\33Q\tyU\bC\u0003T\u0001\u0011\u0005!'\u0001\u000euKN$X*\u001a:hKJ{w\u000fV5nK\u0006sGMU8xi&lW\r\u000b\u0002S{!)a\u000b\u0001C\u0001e\u0005QB/Z:u\u001b\u0016\u0014x-Z,ji\"tuN\\3NS:L')\u0019;dQ\"\u0012Q+\u0010")
public class FlinkRelOptUtilTest {
    private TableEnvironment tableEnv;

    public TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public void tableEnv_$eq(TableEnvironment x$1) {
        this.tableEnv = x$1;
    }

    @Before
    public void before() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().build();
        TableEnvironmentImpl tEnv = TableEnvironmentImpl.create((EnvironmentSettings)settings);
        BatchTableEnvUtil$.MODULE$.registerCollection((TableEnvironment)tEnv, "MyTable", (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Mike", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)12.3), "Smith"}))})), new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), "first, id, score, last");
        this.tableEnv_$eq((TableEnvironment)tEnv);
    }

    @Test
    public void testToString() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.createLocalEnvironment(StreamExecutionEnvironment$.MODULE$.createLocalEnvironment$default$1());
        StreamTableEnvironment tableEnv = StreamTableEnvironment$.MODULE$.create(env, TableTestUtil$.MODULE$.STREAM_SETTING());
        Table table = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(env.fromElements((Seq)Nil$.MODULE$, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.utils.FlinkRelOptUtilTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(tableEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        tableEnv.registerTable("MyTable", table);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t1 AS (SELECT a, c FROM MyTable WHERE b > 50),\n        |     t2 AS (SELECT a * 2 AS a, c FROM MyTable WHERE b < 50)\n        |\n        |SELECT * FROM t1 JOIN t2 ON t1.a = t2.a\n      ")).stripMargin();
        Table result = tableEnv.sqlQuery(sqlQuery);
        RelNode rel = TableTestUtil$.MODULE$.toRelNode(result);
        String expected1 = new StringOps(Predef$.MODULE$.augmentString("\n        |LogicalProject(a=[$0], c=[$1], a0=[$2], c0=[$3])\n        |+- LogicalJoin(condition=[=($0, $2)], joinType=[inner])\n        |   :- LogicalProject(a=[$0], c=[$2])\n        |   :  +- LogicalFilter(condition=[>($1, 50)])\n        |   :     +- LogicalTableScan(table=[[default_catalog, default_database, MyTable]])\n        |   +- LogicalProject(a=[*($0, 2)], c=[$2])\n        |      +- LogicalFilter(condition=[<($1, 50)])\n        |         +- LogicalTableScan(table=[[default_catalog, default_database, MyTable]])\n      ")).stripMargin();
        Assert.assertEquals((Object)expected1.trim(), (Object)FlinkRelOptUtil$.MODULE$.toString(rel, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()).trim());
        String expected2 = new StringOps(Predef$.MODULE$.augmentString("\n        |LogicalProject\n        |+- LogicalJoin\n        |   :- LogicalProject\n        |   :  +- LogicalFilter\n        |   :     +- LogicalTableScan\n        |   +- LogicalProject\n        |      +- LogicalFilter\n        |         +- LogicalTableScan\n      ")).stripMargin();
        Assert.assertEquals((Object)expected2.trim(), (Object)FlinkRelOptUtil$.MODULE$.toString(rel, SqlExplainLevel.NO_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()).trim());
    }

    @Test
    public void testGetDigestWithDynamicFunction() {
        Table table = this.tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                    |(SELECT id AS random FROM MyTable ORDER BY rand() LIMIT 1)\n                                    |INTERSECT\n                                    |(SELECT id AS random FROM MyTable ORDER BY rand() LIMIT 1)\n                                    |INTERSECT\n                                    |(SELECT id AS random FROM MyTable ORDER BY rand() LIMIT 1)\n      ")).stripMargin());
        RelNode rel = TableTestUtil$.MODULE$.toRelNode(table);
        String expected = TableTestUtil$.MODULE$.readFromResource("/digest/testGetDigestWithDynamicFunction.out");
        Assert.assertEquals((Object)expected, (Object)FlinkRelOptUtil$.MODULE$.getDigest(rel));
    }

    @Test
    public void testGetDigestWithDynamicFunctionView() {
        Table view = this.tableEnv().sqlQuery("SELECT id AS random FROM MyTable ORDER BY rand() LIMIT 1");
        this.tableEnv().registerTable("MyView", view);
        Table table = this.tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                    |(SELECT * FROM MyView)\n                                    |INTERSECT\n                                    |(SELECT * FROM MyView)\n                                    |INTERSECT\n                                    |(SELECT * FROM MyView)\n      ")).stripMargin());
        RelNode rel = TableTestUtil$.MODULE$.toRelNode(table).accept((RelShuttle)new ExpandTableScanShuttle());
        String expected = TableTestUtil$.MODULE$.readFromResource("/digest/testGetDigestWithDynamicFunctionView.out");
        Assert.assertEquals((Object)expected, (Object)FlinkRelOptUtil$.MODULE$.getDigest(rel));
    }

    @Test
    public void testMergeRowTimeAndNone() {
        MiniBatchInterval none = MiniBatchInterval.NONE;
        MiniBatchInterval rowtime = new MiniBatchInterval(1000L, MiniBatchMode.RowTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(none, rowtime);
        Assert.assertEquals((Object)rowtime, (Object)mergedResult);
    }

    @Test
    public void testMergeProcTimeAndNone() {
        MiniBatchInterval none = MiniBatchInterval.NONE;
        MiniBatchInterval proctime = new MiniBatchInterval(1000L, MiniBatchMode.ProcTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(none, proctime);
        Assert.assertEquals((Object)proctime, (Object)mergedResult);
    }

    @Test
    public void testMergeRowTimeTAndProcTime1() {
        MiniBatchInterval rowtime = new MiniBatchInterval(4000L, MiniBatchMode.RowTime);
        MiniBatchInterval proctime = new MiniBatchInterval(1000L, MiniBatchMode.ProcTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(rowtime, proctime);
        Assert.assertEquals((Object)rowtime, (Object)mergedResult);
    }

    @Test
    public void testMergeRowTimeTAndProcTime2() {
        MiniBatchInterval rowtime = new MiniBatchInterval(0L, MiniBatchMode.RowTime);
        MiniBatchInterval proctime = new MiniBatchInterval(1000L, MiniBatchMode.ProcTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(rowtime, proctime);
        Assert.assertEquals((Object)new MiniBatchInterval(1000L, MiniBatchMode.RowTime), (Object)mergedResult);
    }

    @Test
    public void testMergeRowTimeAndRowtime() {
        MiniBatchInterval rowtime1 = new MiniBatchInterval(3000L, MiniBatchMode.RowTime);
        MiniBatchInterval rowtime2 = new MiniBatchInterval(5000L, MiniBatchMode.RowTime);
        MiniBatchInterval mergedResult = FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(rowtime1, rowtime2);
        Assert.assertEquals((Object)new MiniBatchInterval(1000L, MiniBatchMode.RowTime), (Object)mergedResult);
    }

    @Test
    public void testMergeWithNoneMiniBatch() {
        Assert.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NO_MINIBATCH, MiniBatchInterval.NONE));
        Assert.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NONE, MiniBatchInterval.NO_MINIBATCH));
        Assert.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NO_MINIBATCH, MiniBatchInterval.NO_MINIBATCH));
        MiniBatchInterval rowtime = new MiniBatchInterval(3000L, MiniBatchMode.RowTime);
        Assert.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NO_MINIBATCH, rowtime));
        Assert.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(rowtime, MiniBatchInterval.NO_MINIBATCH));
        MiniBatchInterval proctime = new MiniBatchInterval(1000L, MiniBatchMode.ProcTime);
        Assert.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(MiniBatchInterval.NO_MINIBATCH, proctime));
        Assert.assertEquals((Object)MiniBatchInterval.NO_MINIBATCH, (Object)FlinkRelOptUtil$.MODULE$.mergeMiniBatchInterval(proctime, MiniBatchInterval.NO_MINIBATCH));
    }
}

