/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.TimeZone;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.ExpressionParser;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction$;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.planner.plan.utils.RexNodeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.IntSumAggFunction;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u0001E\u0011ACU3y\u001d>$W-\u0012=ue\u0006\u001cGo\u001c:UKN$(BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0010%\u0016Dhj\u001c3f)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003'\u0001Aqa\u0007\u0001C\u0002\u0013\u0005A$\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0016\u0003u\u0001\"AH\u0011\u000e\u0003}Q!\u0001\t\u0005\u0002\u000f\r\fG/\u00197pO&\u0011!e\b\u0002\u000f\u0007\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s\u0011\u0019!\u0003\u0001)A\u0005;\u0005y1-\u0019;bY><W*\u00198bO\u0016\u0014\b\u0005C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u001b5|G-\u001e7f\u001b\u0006t\u0017mZ3s+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\t\u0003\u0019iw\u000eZ;mK&\u0011QF\u000b\u0002\u000e\u001b>$W\u000f\\3NC:\fw-\u001a:\t\r=\u0002\u0001\u0015!\u0003)\u00039iw\u000eZ;mK6\u000bg.Y4fe\u0002Bq!\r\u0001C\u0002\u0013%!'A\bgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h+\u0005\u0019\u0004C\u0001\u00105\u0013\t)tDA\bGk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h\u0011\u00199\u0004\u0001)A\u0005g\u0005\u0001b-\u001e8di&|gnQ1uC2|w\r\t\u0005\u0006s\u0001!\tAO\u0001\u001ai\u0016\u001cH/\u0012=ue\u0006\u001cGOU3g\u0013:\u0004X\u000f\u001e$jK2$7\u000fF\u0001<!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0011)f.\u001b;)\u0005a\u0012\u0005CA\"G\u001b\u0005!%BA#\u000f\u0003\u0015QWO\\5u\u0013\t9EI\u0001\u0003UKN$\b\"B%\u0001\t\u0003Q\u0014a\b;fgR,\u0005\u0010\u001e:bGR\u0014VM\u001a(fgR,G-\u00138qkR4\u0015.\u001a7eg\"\u0012\u0001J\u0011\u0005\u0006\u0019\u0002!\tAO\u0001-i\u0016\u001cH/\u0012=ue\u0006\u001cGOU3g\u001d\u0016\u001cH/\u001a3J]B,HOR5fY\u0012\u001cx+\u001b;i\u001d>tUm\u001d;j]\u001eD#a\u0013\"\t\u000b=\u0003A\u0011\u0001\u001e\u0002GQ,7\u000f^#yiJ\f7\r\u001e#fKB\u0014VM\u001a(fgR,G-\u00138qkR4\u0015.\u001a7eg\"\u0012aJ\u0011\u0005\u0006%\u0002!\tAO\u0001\u001bi\u0016\u001cH/\u0012=ue\u0006\u001cGoU5na2,7i\u001c8eSRLwN\u001c\u0015\u0003#\nCQ!\u0016\u0001\u0005\u0002i\n!\u0004^3ti\u0016CHO]1diNKgn\u001a7f\u0007>tG-\u001b;j_:D#\u0001\u0016\"\t\u000ba\u0003A\u0011\u0001\u001e\u0002/Q,7\u000f^#yiJ\f7\r^\"oM\u000e{g\u000eZ5uS>t\u0007FA,C\u0011\u0015Y\u0006\u0001\"\u0001;\u0003e!Xm\u001d;FqR\u0014\u0018m\u0019;B\u001d\u0012+\u0005\u0010\u001d:fgNLwN\\:)\u0005i\u0013\u0005\"\u00020\u0001\t\u0003Q\u0014!\b;fgRtU/\\3sS\u000ed\u0015\u000e^3sC2\u001cuN\u001c<feNLwN\\:)\u0005u\u0013\u0005\"B1\u0001\t\u0003Q\u0014A\u0007;fgR$\u0016.\\3MSR,'/\u00197D_:4XM]:j_:\u001c\bF\u00011C\u0011\u0015!\u0007\u0001\"\u0001;\u0003}!Xm\u001d;FqR\u0014\u0018m\u0019;Be&$\b.\\3uS\u000e\u001cuN\u001c3ji&|gn\u001d\u0015\u0003G\nCQa\u001a\u0001\u0005\u0002i\nA\u0004^3ti\u0016CHO]1diB{7\u000f\u001e4jq\u000e{g\u000eZ5uS>t7\u000f\u000b\u0002g\u0005\")!\u000e\u0001C\u0001u\u0005)C/Z:u\u000bb$(/Y2u\u0007>tG-\u001b;j_:<\u0016\u000e\u001e5Gk:\u001cG/[8o\u0007\u0006dGn\u001d\u0015\u0003S\nCQ!\u001c\u0001\u0005\u0002i\n1\u0003^3ti\u0016CHO]1di^KG\u000f[\"bgRD#\u0001\u001c\"\t\u000bA\u0004A\u0011\u0001\u001e\u0002'Q,7\u000f^#yiJ\f7\r^,ji\"$&/[7)\u0005=\u0014\u0005\"B:\u0001\t\u0003Q\u0014A\u0005;fgR,\u0005\u0010\u001e:bGR<\u0016\u000e\u001e5VI\u001aD#A\u001d\"\t\u000bY\u0004A\u0011\u0001\u001e\u0002=Q,7\u000f^#yiJ\f7\r\u001e)beRLG/[8o!J,G-[2bi\u0016\u001c\bFA;C\u0011\u0015I\b\u0001\"\u0001;\u0003\t\"Xm\u001d;FqR\u0014\u0018m\u0019;QCJ$\u0018\u000e^5p]B\u0013X\rZ5dCR,7\u000fR1uK\"\u0012\u0001P\u0011\u0005\u0006y\u0002!\tAO\u0001,i\u0016\u001cH\u000fV5nK2KG/\u001a:bY^KG\u000f\u001b'pG\u0006dG+[7f5>tWmQ8om\u0016\u00148/[8og\"\u00121P\u0011\u0005\u0007\u007f\u0002!I!!\u0001\u0002CQ,7\u000f^#yiJ\f7\r^*j]\u001edW\rU8ti\u001aL\u0007pQ8oI&$\u0018n\u001c8\u0015\u000fm\n\u0019!a\u0006\u0002,!9\u0011Q\u0001@A\u0002\u0005\u001d\u0011A\u00034jK2$\u0017J\u001c3fqB!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001\u00027b]\u001eT!!!\u0005\u0002\t)\fg/Y\u0005\u0005\u0003+\tYAA\u0004J]R,w-\u001a:\t\u000f\u0005ea\u00101\u0001\u0002\u001c\u0005\u0011q\u000e\u001d\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0004\u0003Ka\u0011aB2bY\u000eLG/Z\u0005\u0005\u0003S\tyB\u0001\nTc2\u0004vn\u001d;gSb|\u0005/\u001a:bi>\u0014\bbBA\u0017}\u0002\u0007\u0011qF\u0001\u0005Kb\u0004(\u000f\u0005\u0003\u00022\u0005}b\u0002BA\u001a\u0003w\u00012!!\u000e>\u001b\t\t9DC\u0002\u0002:A\ta\u0001\u0010:p_Rt\u0014bAA\u001f{\u00051\u0001K]3eK\u001aLA!!\u0011\u0002D\t11\u000b\u001e:j]\u001eT1!!\u0010>\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013\n1$Y:tKJ$X\t\u001f9sKN\u001c\u0018n\u001c8BeJ\f\u00170R9vC2\u001cH#B\u001e\u0002L\u0005\u0005\u0004\u0002CA'\u0003\u000b\u0002\r!a\u0014\u0002\u0011\u0015D\b/Z2uK\u0012\u0004R\u0001PA)\u0003+J1!a\u0015>\u0005\u0015\t%O]1z!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\u0011\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\ty&!\u0017\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005\u0002d\u0005\u0015\u0003\u0019AA(\u0003\u0019\t7\r^;bY\"9\u0011q\r\u0001\u0005\n\u0005%\u0014\u0001H3yiJ\f7\r^\"p]*,hn\u0019;jm\u0016\u001cuN\u001c3ji&|gn\u001d\u000b\u000f\u0003W\ny(!!\u0002\f\u0006m\u0015QUAT!\u001da\u0014QNA(\u0003cJ1!a\u001c>\u0005\u0019!V\u000f\u001d7feA)A(!\u0015\u0002tA!\u0011QOA>\u001b\t\t9H\u0003\u0003\u0002z\u0005\r\u0012a\u0001:fq&!\u0011QPA<\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001\"!\f\u0002f\u0001\u0007\u00111\u000f\u0005\t\u0003\u0007\u000b)\u00071\u0001\u0002\u0006\u0006yQ.\u0019=D]\u001atu\u000eZ3D_VtG\u000fE\u0002=\u0003\u000fK1!!#>\u0005\rIe\u000e\u001e\u0005\t\u0003\u001b\u000b)\u00071\u0001\u0002\u0010\u0006y\u0011N\u001c9vi\u001aKW\r\u001c3OC6,7\u000f\u0005\u0004\u0002\u0012\u0006]\u0015qF\u0007\u0003\u0003'SA!!&\u0002\u0010\u0005!Q\u000f^5m\u0013\u0011\tI*a%\u0003\t1K7\u000f\u001e\u0005\t\u0003;\u000b)\u00071\u0001\u0002 \u0006Q!/\u001a=Ck&dG-\u001a:\u0011\t\u0005U\u0014\u0011U\u0005\u0005\u0003G\u000b9H\u0001\u0006SKb\u0014U/\u001b7eKJDa\u0001IA3\u0001\u0004\u0019\u0004BCAU\u0003K\u0002\n\u00111\u0001\u0002,\u0006\u0011AO\u001f\t\u0005\u0003#\u000bi+\u0003\u0003\u00020\u0006M%\u0001\u0003+j[\u0016TvN\\3\t\u0013\u0005M\u0006!%A\u0005\n\u0005U\u0016AJ3yiJ\f7\r^\"p]*,hn\u0019;jm\u0016\u001cuN\u001c3ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011q\u0017\u0016\u0005\u0003W\u000bIl\u000b\u0002\u0002<B!\u0011QXAd\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017!C;oG\",7m[3e\u0015\r\t)-P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAe\u0003\u007f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class RexNodeExtractorTest
extends RexNodeTestBase {
    private final CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
    private final ModuleManager moduleManager = new ModuleManager();
    private final FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)TableConfig.getDefault(), this.catalogManager(), this.moduleManager());

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public ModuleManager moduleManager() {
        return this.moduleManager;
    }

    private FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    @Test
    public void testExtractRefInputFields() {
        java.util.List exprs;
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List list = exprs = (java.util.List)tuple2._1();
        java.util.List exprs2 = list;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(exprs2);
        Assert.assertArrayEquals((int[])usedFields, (int[])new int[]{2, 3, 1});
    }

    @Test
    public void testExtractRefNestedInputFields() {
        java.util.List rexProgram;
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List list = rexProgram = (java.util.List)tuple2._1();
        java.util.List rexProgram2 = list;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(rexProgram2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(rexProgram2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"amount"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})})});
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testExtractRefNestedInputFieldsWithNoNesting() {
        java.util.List exprs;
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List list = exprs = (java.util.List)tuple2._1();
        java.util.List exprs2 = list;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(exprs2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(exprs2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})})});
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testExtractDeepRefNestedInputFields() {
        java.util.List rexProgram;
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithDeepNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List list = rexProgram = (java.util.List)tuple2._1();
        java.util.List rexProgram2 = list;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(rexProgram2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(rexProgram2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"amount"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"with", "deeper", "entry"}), Arrays.asList((Object[])new String[]{"with", "deep", "entry"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"outer"}), Arrays.asList((Object[])new String[]{"inner", "deep_array"})})});
        Assert.assertThat((Object)usedFields, (Matcher)CoreMatchers.is((Object)new int[]{1, 0, 2, 3}));
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testExtractSimpleCondition() {
        FlinkRexBuilder builder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        RexNode expr = this.buildConditionExpr();
        Expression firstExp = ExpressionParser.INSTANCE.parseExpression("id > 6");
        Expression secondExp = ExpressionParser.INSTANCE.parseExpression("amount * price < 100");
        Expression[] expected = (Expression[])((Object[])new Expression[]{firstExp, secondExp});
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(expr, -1, this.allFieldNames(), (RexBuilder)builder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractSingleCondition() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(a, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser.INSTANCE.parseExpression("amount >= id")});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractCnfCondition() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLiteral t4 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(200L));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t3});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode e = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t4});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))).asJava());
        RexNode or = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)and, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)e, (List)Nil$.MODULE$)))).asJava());
        RexNode not = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)d, (List)Nil$.MODULE$)).asJava());
        RexNode complexNode = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)or, (List)new .colon.colon((Object)not, (List)Nil$.MODULE$))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexNode, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser.INSTANCE.parseExpression("amount < 100 || price == 100 || price === 200"), ExpressionParser.INSTANCE.parseExpression("id > 100 || price == 100 || price === 200"), ExpressionParser.INSTANCE.parseExpression("!(amount <= id)")});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractANDExpressions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t3});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser.INSTANCE.parseExpression("amount < 100"), ExpressionParser.INSTANCE.parseExpression("amount <= id"), ExpressionParser.INSTANCE.parseExpression("id > 100"), ExpressionParser.INSTANCE.parseExpression("price === 100")});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testNumericLiteralConversions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLiteral t4 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(200.1));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t4});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t4});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToInteger((int)100))}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount"), ApiExpressionUtils.unresolvedRef((String)"id")}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"id"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToDouble((double)200.1))}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"price"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToDouble((double)200.1))})});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testTimeLiteralConversions() {
        Expression[] converted;
        FlinkRexBuilder relBuilder;
        java.util.List fieldNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"timestamp_col", (List)new .colon.colon((Object)"date_col", (List)new .colon.colon((Object)"time_col", (List)Nil$.MODULE$)))).asJava();
        java.util.List<RelDataType> fieldTypes = this.makeTypes((Seq<SqlTypeName>)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.TIMESTAMP, SqlTypeName.DATE, SqlTypeName.TIME}));
        TimestampString timestampString = new TimestampString("2017-09-10 14:23:01");
        RexLiteral rexTimestamp = this.rexBuilder().makeTimestampLiteral(timestampString, 3);
        RexLiteral rexDate = this.rexBuilder().makeDateLiteral(new DateString("2017-09-12"));
        RexLiteral rexTime = this.rexBuilder().makeTimeLiteral(new TimeString("14:23:01"), 0);
        .colon.colon allRexNodes = new .colon.colon((Object)rexTimestamp, (List)new .colon.colon((Object)rexDate, (List)new .colon.colon((Object)rexTime, (List)Nil$.MODULE$)));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldTypes).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeInputRef((RelDataType)t._1(), t._2$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)allRexNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)t._1(), (RexNode)t._2()}), Buffer$.MODULE$.canBuildFrom())).asJava();
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, fieldNames, (RexBuilder)(relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory())), this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] expressionArray = converted = (Expression[])tuple2._1();
        Expression[] converted2 = expressionArray;
        LocalDateTime datetime = DateTimeTestUtil$.MODULE$.localDateTime("2017-09-10 14:23:01");
        LocalDate date = DateTimeTestUtil$.MODULE$.localDate("2017-09-12");
        LocalTime time = DateTimeTestUtil$.MODULE$.localTime("14:23:01");
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"timestamp_col"), ApiExpressionUtils.valueLiteral((Object)datetime)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"date_col"), ApiExpressionUtils.valueLiteral((Object)date)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"time_col"), ApiExpressionUtils.valueLiteral((Object)time)})});
        this.assertExpressionArrayEquals(expected, converted2);
    }

    @Test
    public void testExtractArithmeticConditions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall(FlinkSqlOperatorTable.DIVIDE, new RexNode[]{t0, t1}), t2})}))).asJava();
        RexNode complexExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexExpr, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ExpressionParser.INSTANCE.parseExpression("amount < id"), ExpressionParser.INSTANCE.parseExpression("amount <= id"), ExpressionParser.INSTANCE.parseExpression("amount <> id"), ExpressionParser.INSTANCE.parseExpression("amount == id"), ExpressionParser.INSTANCE.parseExpression("amount >= id"), ExpressionParser.INSTANCE.parseExpression("amount > id"), ExpressionParser.INSTANCE.parseExpression("amount + id == 100"), ExpressionParser.INSTANCE.parseExpression("amount - id == 100"), ExpressionParser.INSTANCE.parseExpression("amount * id == 100"), ExpressionParser.INSTANCE.parseExpression("amount / id == 100")});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractPostfixConditions() {
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NULL, "isNull(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_TRUE, "isTrue(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NOT_TRUE, "isNotTrue(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_FALSE, "isFalse(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NOT_FALSE, "isNotFalse(flag)");
    }

    @Test
    public void testExtractConditionWithFunctionCalls() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode condition1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SUM, new RexNode[]{t0}), t2});
        RexNode condition2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.FIRST_VALUE, new RexNode[]{t1}), t2});
        RexNode complexExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{condition1, condition2});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexExpr, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)new AggregateFunctionDefinition("sum", (AggregateFunction)new IntSumAggFunction(), Types.INT, Types.INT), (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount")}), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToInteger((int)100))})});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)1L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractWithCast() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode cast = this.rexBuilder().makeCast(this.allFieldTypes().get(1), (RexNode)t0);
        RexNode condition1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{cast, t2});
        RexNode condition2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode condition3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{condition1, condition2});
        RexNode conditionExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{condition1, condition2, condition3});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(conditionExpr, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)3L, (long)convertedExpressions2.length);
        Assert.assertEquals((Object)"greaterThan(cast(amount, BIGINT), 100)", (Object)convertedExpressions2[0].toString());
        Assert.assertEquals((Object)"lessThanOrEqual(amount, id)", (Object)convertedExpressions2[1].toString());
        Assert.assertEquals((Object)"or(greaterThan(cast(amount, BIGINT), 100), lessThanOrEqual(amount, id))", (Object)convertedExpressions2[2].toString());
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
        this.assertExpressionArrayEquals((Expression[])((Object[])new Expression[]{ExpressionParser.INSTANCE.parseExpression("amount <= id")}), (Expression[])((Object[])new Expression[]{convertedExpressions2[1]}));
    }

    @Test
    public void testExtractWithTrim() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(0), 0);
        RexLiteral t1 = this.rexBuilder().makeLiteral("He");
        RexNode trimBoth = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.BOTH), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode trimLeading = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.LEADING), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode trimTrailing = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.TRAILING), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)trimBoth, (List)new .colon.colon((Object)trimLeading, (List)new .colon.colon((Object)trimTrailing, (List)Nil$.MODULE$)))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)0L, (long)convertedExpressions2.length);
        Assert.assertEquals((long)3L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractWithUdf() {
        this.functionCatalog().registerTempSystemScalarFunction("myUdf", (ScalarFunction)Func1$.MODULE$);
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexNode t1 = this.rexBuilder().makeCall((SqlOperator)new ScalarSqlFunction(FunctionIdentifier.of((String)"MyUdf"), "myUdf", (ScalarFunction)Func1$.MODULE$, this.typeFactory(), ScalarSqlFunction$.MODULE$.$lessinit$greater$default$5()), new RexNode[]{t0});
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode condition = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t2});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(condition, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)1L, (long)convertedExpressions2.length);
        Assert.assertEquals((Object)"greaterThan(MyUdf(amount), 100)", (Object)convertedExpressions2[0].toString());
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractPartitionPredicates() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexLiteral t1 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode c1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1});
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(0), 0);
        RexLiteral t3 = this.rexBuilder().makeLiteral("test%");
        RexNode c2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LIKE, new RexNode[]{t2, t3});
        RexNode c3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{c1, c2});
        Tuple2 tuple2 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount", "name"}));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RexNode partitionPredicate1 = (RexNode)tuple2._1();
        RexNode nonPartitionPredicate1 = (RexNode)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicate1, (Object)nonPartitionPredicate1);
        Tuple2 tuple23 = tuple22;
        RexNode partitionPredicate12 = (RexNode)tuple23._1();
        RexNode nonPartitionPredicate12 = (RexNode)tuple23._2();
        Assert.assertEquals((Object)c3, (Object)partitionPredicate12);
        Assert.assertTrue((boolean)nonPartitionPredicate12.isAlwaysTrue());
        Tuple2 tuple24 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount"}));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        RexNode partitionPredicate2 = (RexNode)tuple24._1();
        RexNode nonPartitionPredicate2 = (RexNode)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)partitionPredicate2, (Object)nonPartitionPredicate2);
        Tuple2 tuple26 = tuple25;
        RexNode partitionPredicate22 = (RexNode)tuple26._1();
        RexNode nonPartitionPredicate22 = (RexNode)tuple26._2();
        Assert.assertEquals((Object)c1, (Object)partitionPredicate22);
        Assert.assertEquals((Object)c2, (Object)nonPartitionPredicate22);
        Tuple2 tuple27 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"id"}));
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        RexNode partitionPredicate3 = (RexNode)tuple27._1();
        RexNode nonPartitionPredicate3 = (RexNode)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)partitionPredicate3, (Object)nonPartitionPredicate3);
        Tuple2 tuple29 = tuple28;
        RexNode partitionPredicate32 = (RexNode)tuple29._1();
        RexNode nonPartitionPredicate32 = (RexNode)tuple29._2();
        Assert.assertTrue((boolean)partitionPredicate32.isAlwaysTrue());
        Assert.assertEquals((Object)c3, (Object)nonPartitionPredicate32);
        RexNode c4 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{c1, c2});
        Tuple2 tuple210 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c4, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount", "name"}));
        if (tuple210 == null) {
            throw new MatchError((Object)tuple210);
        }
        RexNode partitionPredicate4 = (RexNode)tuple210._1();
        RexNode nonPartitionPredicate4 = (RexNode)tuple210._2();
        Tuple2 tuple211 = new Tuple2((Object)partitionPredicate4, (Object)nonPartitionPredicate4);
        Tuple2 tuple212 = tuple211;
        RexNode partitionPredicate42 = (RexNode)tuple212._1();
        RexNode nonPartitionPredicate42 = (RexNode)tuple212._2();
        Assert.assertEquals((Object)c4, (Object)partitionPredicate42);
        Assert.assertTrue((boolean)nonPartitionPredicate42.isAlwaysTrue());
        Tuple2 tuple213 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c4, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount"}));
        if (tuple213 == null) {
            throw new MatchError((Object)tuple213);
        }
        RexNode partitionPredicate5 = (RexNode)tuple213._1();
        RexNode nonPartitionPredicate5 = (RexNode)tuple213._2();
        Tuple2 tuple214 = new Tuple2((Object)partitionPredicate5, (Object)nonPartitionPredicate5);
        Tuple2 tuple215 = tuple214;
        RexNode partitionPredicate52 = (RexNode)tuple215._1();
        RexNode nonPartitionPredicate52 = (RexNode)tuple215._2();
        Assert.assertTrue((boolean)partitionPredicate52.isAlwaysTrue());
        Assert.assertEquals((Object)c4, (Object)nonPartitionPredicate52);
    }

    @Test
    public void testExtractPartitionPredicatesDate() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 1);
        RexLiteral t1 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode c1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1});
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.typeFactory().createFieldTypeFromLogicalType(DataTypes.DATE().getLogicalType()), 0);
        RexLiteral t3 = this.rexBuilder().makeDateLiteral(DateString.fromDaysSinceEpoch((int)18000));
        RexNode c2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode c3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{c1, c2});
        Tuple2 tuple2 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"date"}));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RexNode partitionPredicate1 = (RexNode)tuple2._1();
        RexNode nonPartitionPredicate1 = (RexNode)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicate1, (Object)nonPartitionPredicate1);
        Tuple2 tuple23 = tuple22;
        RexNode partitionPredicate12 = (RexNode)tuple23._1();
        RexNode nonPartitionPredicate12 = (RexNode)tuple23._2();
        Assert.assertEquals((Object)c2, (Object)partitionPredicate12);
        Assert.assertEquals((Object)c1, (Object)nonPartitionPredicate12);
        Tuple2 tuple24 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"date", "amount"}));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        RexNode partitionPredicate2 = (RexNode)tuple24._1();
        RexNode nonPartitionPredicate2 = (RexNode)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)partitionPredicate2, (Object)nonPartitionPredicate2);
        Tuple2 tuple26 = tuple25;
        RexNode partitionPredicate22 = (RexNode)tuple26._1();
        RexNode nonPartitionPredicate22 = (RexNode)tuple26._2();
        Assert.assertEquals((Object)c3, (Object)partitionPredicate22);
        Assert.assertTrue((boolean)nonPartitionPredicate22.isAlwaysTrue());
        Tuple2 tuple27 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"id", "amount"}));
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        RexNode partitionPredicate3 = (RexNode)tuple27._1();
        RexNode nonPartitionPredicate3 = (RexNode)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)partitionPredicate3, (Object)nonPartitionPredicate3);
        Tuple2 tuple29 = tuple28;
        RexNode partitionPredicate32 = (RexNode)tuple29._1();
        RexNode nonPartitionPredicate32 = (RexNode)tuple29._2();
        Assert.assertEquals((Object)c1, (Object)partitionPredicate32);
        Assert.assertEquals((Object)c2, (Object)nonPartitionPredicate32);
    }

    @Test
    public void testTimeLiteralWithLocalTimeZoneConversions() {
        Expression[] converted;
        java.util.List fieldNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"timestamp_col", (List)new .colon.colon((Object)"instant_col", (List)Nil$.MODULE$))).asJava();
        java.util.List<RelDataType> fieldTypes = this.makeTypes((Seq<SqlTypeName>)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE}));
        TimestampString timestampString = new TimestampString("2017-09-10 14:23:01.123456");
        RexLiteral rexTimestamp = this.rexBuilder().makeTimestampLiteral(timestampString, 6);
        RexLiteral rexInstant = this.rexBuilder().makeTimestampWithLocalTimeZoneLiteral(timestampString, 6);
        .colon.colon allRexNodes = new .colon.colon((Object)rexTimestamp, (List)new .colon.colon((Object)rexInstant, (List)Nil$.MODULE$));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldTypes).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeInputRef((RelDataType)t._1(), t._2$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)allRexNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)t._1(), (RexNode)t._2()}), Buffer$.MODULE$.canBuildFrom())).asJava();
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        ZoneId shanghai = ZoneId.of("Asia/Shanghai");
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, fieldNames, (RexBuilder)relBuilder, this.functionCatalog(), TimeZone.getTimeZone(shanghai));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] expressionArray = converted = (Expression[])tuple2._1();
        Expression[] converted2 = expressionArray;
        LocalDateTime datetime = DateTimeTestUtil$.MODULE$.localDateTime("2017-09-10 14:23:01.123456");
        Instant instant = datetime.toInstant(shanghai.getRules().getOffset(datetime));
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"timestamp_col"), ApiExpressionUtils.valueLiteral((Object)datetime)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"instant_col"), ApiExpressionUtils.valueLiteral((Object)instant)})});
        this.assertExpressionArrayEquals(expected, converted2);
    }

    private void testExtractSinglePostfixCondition(Integer fieldIndex, SqlPostfixOperator op, String expr) {
        this.rexBuilder_$eq((RexBuilder)new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory()));
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(Predef$.MODULE$.Integer2int(fieldIndex)), Predef$.MODULE$.Integer2int(fieldIndex));
        RexNode conditionExpr = this.rexBuilder().makeCall((SqlOperator)op, new RexNode[]{t0});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(conditionExpr, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)1L, (long)convertedExpressions2.length);
        Assert.assertEquals((Object)expr, (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])convertedExpressions2)).head().toString());
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    private void assertExpressionArrayEquals(Expression[] expected, Expression[] actual) {
        Expression[] sortedExpected = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected)).sortBy((Function1 & Serializable & scala.Serializable)e -> e.toString(), (Ordering)Ordering.String$.MODULE$);
        Expression[] sortedActual = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actual)).sortBy((Function1 & Serializable & scala.Serializable)e -> e.toString(), (Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((long)sortedExpected.length, (long)sortedActual.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedExpected)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sortedActual), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RexNodeExtractorTest.$anonfun$assertExpressionArrayEquals$3(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Expression[], RexNode[]> extractConjunctiveConditions(RexNode expr, int maxCnfNodeCount, java.util.List<String> inputFieldNames, RexBuilder rexBuilder, FunctionCatalog catalog, TimeZone tz) {
        return RexNodeExtractor$.MODULE$.extractConjunctiveConditions(expr, maxCnfNodeCount, inputFieldNames, rexBuilder, catalog, this.catalogManager(), tz);
    }

    private TimeZone extractConjunctiveConditions$default$6() {
        return TimeZone.getDefault();
    }

    public static final /* synthetic */ void $anonfun$assertExpressionArrayEquals$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression l = (Expression)tuple2._1();
        Expression r = (Expression)tuple2._2();
        Assert.assertEquals((Object)l.toString(), (Object)r.toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

