/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParallelismSettingTest
extends TableTestBase {
    private BatchTableTestUtil util;

    @Before
    public void before() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        this.util.getStreamEnv().getConfig().setDynamicGraph(true);
        this.util.tableEnv().executeSql("CREATE TABLE MyTable (\n  a BIGINT,\n  b BIGINT,\n  c VARCHAR\n) WITH (\n  'connector' = 'filesystem',\n  'format' = 'testcsv',\n  'path' = '/tmp')");
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  b bigint\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')");
    }

    @Test
    public void testParallelismSettingAfterSingletonShuffleRemove() {
        List operations = this.util.getPlanner().getParser().parse("INSERT INTO MySink SELECT MAX(b) FROM (SELECT SUM(b) AS b FROM MyTable)");
        List transformations = this.util.getPlanner().translate(Collections.singletonList((ModifyOperation)operations.get(0)));
        Assert.assertEquals((long)1L, (long)transformations.size());
        Transformation sink = (Transformation)transformations.get(0);
        Transformation topAgg = (Transformation)sink.getInputs().get(0);
        Assert.assertEquals((long)1L, (long)topAgg.getParallelism());
        Assert.assertEquals((long)1L, (long)topAgg.getMaxParallelism());
        Transformation bottomAgg = (Transformation)topAgg.getInputs().get(0);
        Assert.assertEquals((long)1L, (long)bottomAgg.getParallelism());
        Assert.assertEquals((long)1L, (long)bottomAgg.getMaxParallelism());
    }
}

