/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.PartitionableSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.utils.TestUserClassLoaderJar;
import org.apache.flink.types.Row;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001M\u0011\u0011\u0004U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u0011m\u0001!Q1A\u0005\u0002q\tQc]8ve\u000e,g)\u001a;dQB\u000b'\u000f^5uS>t7/F\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0017g>,(oY3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8tA!Aa\u0005\u0001BC\u0002\u0013\u0005A$\u0001\tvg\u0016\u001c\u0015\r^1m_\u001e4\u0015\u000e\u001c;fe\"A\u0001\u0006\u0001B\u0001B\u0003%Q$A\tvg\u0016\u001c\u0015\r^1m_\u001e4\u0015\u000e\u001c;fe\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017/_A\u0011Q\u0006A\u0007\u0002\u0005!)1$\u000ba\u0001;!)a%\u000ba\u0001;!)\u0011\u0007\u0001C!e\u00051!-\u001a4pe\u0016$\u0012a\r\t\u0003=QJ!!N\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u0003a]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\t\u0002\u000b),h.\u001b;\n\u0005qJ$A\u0002\"fM>\u0014X\rC\u0003?\u0001\u0011\u0005!'\u0001\u0012uKN$8+[7qY\u0016\u0004\u0016M\u001d;ji&|gNR5fY\u0012\u0004&/\u001a3jG\u0006$X-\r\u0015\u0003{\u0001\u0003\"\u0001O!\n\u0005\tK$\u0001\u0002+fgRDQ\u0001\u0012\u0001\u0005\u0002I\n!\u0006^3tiB\u000b'\u000f^5bYB\u000b'\u000f^5uS>tg)[3mIB\u0013X\rZ5dCR,\u0007+^:i\t><h\u000e\u000b\u0002D\u0001\")q\t\u0001C\u0001e\u0005IB/Z:u+:\u001cwN\u001c<feR,G-\u0012=qe\u0016\u001c8/[8oQ\t1\u0005\tC\u0003K\u0001\u0011\u0005!'A\u001auKN$\b+^:i\t><h\u000eU1si&$\u0018n\u001c8B]\u00124\u0015\u000e\u001c;feN\u001cuN\u001c;bS:\u0004\u0016M\u001d;ji&|gnS3zg\"\u0012\u0011\n\u0011\u0005\u0006\u001b\u0002!\tAM\u0001Hi\u0016\u001cH\u000fU;tQ\u0012{wO\u001c)beRLG/[8o\u0003:$g)\u001b7uKJ\u001c8i\u001c8uC&t\u0007+\u0019:uSRLwN\\&fsN<\u0016\u000e\u001e5TS:<G.\u001a)s_*,7\r^5p]\"\u0012A\n\u0011\u0005\u0006!\u0002!\tAM\u0001&i\u0016\u001cH\u000fU1si&$\u0018n\u001c8QeVtWM]\"p[BLG.Z\"mCN\u001cHj\\1eKJD#a\u0014!)\t\u0001\u0019\u0016L\u0017\t\u0003)^k\u0011!\u0016\u0006\u0003-f\naA];o]\u0016\u0014\u0018B\u0001-V\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=f\nqA];o]\u0016\u00148/\u0003\u0002a;\ni\u0001+\u0019:b[\u0016$XM]5{K\u0012<QA\u0019\u0002\t\u0002\r\f\u0011\u0004U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016LEkQ1tKB\u0011Q\u0006\u001a\u0004\u0006\u0003\tA\t!Z\n\u0003I\u001a\u0004\"AH4\n\u0005!|\"AB!osJ+g\rC\u0003+I\u0012\u0005!\u000eF\u0001d\u0011\u0015aG\r\"\u0001n\u0003)\u0001\u0018M]1nKR,'o\u001d\u000b\u0002]B\u0019q\u000e\u001e<\u000e\u0003AT!!\u001d:\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0006!!.\u0019<b\u0013\t)\bO\u0001\u0006D_2dWm\u0019;j_:\u00042AH<z\u0013\tAxDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001fu&\u00111p\b\u0002\u0004\u0003:L\bFB6~\u0003\u0013\tY\u0001E\u0002\u007f\u0003\u0007q!\u0001X@\n\u0007\u0005\u0005Q,A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0003\u000b\t9A\u0001\u0006QCJ\fW.\u001a;feNT1!!\u0001^\u0003\u0011q\u0017-\\3\"\u0005\u00055\u0011aL:pkJ\u001cWMR3uG\"\u0004\u0016M\u001d;ji&|gn]\u001f|aud\u0003%^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:>wFj\b")
public class PartitionableSourceITCase
extends BatchTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;

    @Parameterized.Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceITCase$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Vivi", "C", BoxesRunTime.boxToInteger((int)1)}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(401).append("\n         |CREATE TABLE PartitionableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s'\n         |)\n         |").toString())).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n         |CREATE TABLE PartitionableAndFilterableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s',\n         |    'filterable-fields' = 'id;part1;part2'\n         |)\n         |").toString())).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.tEnv().executeSql(String.format(partitionableTable, partitions));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.tEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.tEnv().useCatalog("test_catalog");
            this.tEnv().executeSql(String.format(partitionableTable, ""));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
            ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
            ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceITCase.$anonfun$before$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSimplePartitionFieldPredicate1() {
        this.checkResult("SELECT * FROM PartitionableTable WHERE part1 = 'A'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPartialPartitionFieldPredicatePushDown() {
        this.checkResult("SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testUnconvertedExpression() {
        this.checkResult("select * from PartitionableTable where trim(part1) = 'A' and part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        this.checkResult("SELECT * FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        this.checkResult("SELECT name FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"LiSi"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Jack"}))}))), this.checkResult$default$3());
    }

    @Test
    public void testPartitionPrunerCompileClassLoader() {
        String udfJavaCode = new StringOps(Predef$.MODULE$.augmentString("\n         |public class TrimUDF extends org.apache.flink.table.functions.ScalarFunction {\n         |   public String eval(String str) {\n         |     return str.trim();\n         |   }\n         |}\n         |")).stripMargin();
        File tmpDir = BatchAbstractTestBase.TEMPORARY_FOLDER.newFolder();
        File udfJarFile = TestUserClassLoaderJar.createJarFile(tmpDir, "flink-test-udf.jar", "TrimUDF", udfJavaCode);
        List<URL> jars = Collections.singletonList(udfJarFile.toURI().toURL());
        URLClassLoader cl = ClientUtils.buildUserCodeClassLoader(jars, Collections.emptyList(), (ClassLoader)this.getClass().getClassLoader(), (Configuration)new Configuration());
        try (TemporaryClassLoaderContext ctx = TemporaryClassLoaderContext.of((ClassLoader)cl);){
            this.tEnv().executeSql("create temporary function trimUDF as 'TrimUDF'");
            this.checkResult("select * from PartitionableTable where trimUDF(part1) = 'A' and part2 > 1", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}))}))), this.checkResult$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$before$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceITCase(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
    }
}

