/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.join;

import java.util.Collection;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.batch.sql.join.LookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.types.Row;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001U\u0011\u0001\u0003T8pWV\u0004(j\\5o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011\u0001\u00026pS:T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)!-\u0019;dQ*\u0011\u0011BC\u0001\beVtG/[7f\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00033!\tQ!\u001e;jYNL!a\u0007\r\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011!i\u0002A!A!\u0002\u0013q\u0012!\u00057fO\u0006\u001c\u0017\u0010V1cY\u0016\u001cv.\u001e:dKB\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t9!i\\8mK\u0006t\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0017%\u001c\u0018i]=oG6{G-\u001a\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%ZC\u0006\u0005\u0002+\u00015\t!\u0001C\u0003\u001eM\u0001\u0007a\u0004C\u0003&M\u0001\u0007a\u0004C\u0004/\u0001\t\u0007I\u0011A\u0018\u0002\t\u0011\fG/Y\u000b\u0002aA\u0019\u0011G\u000e\u001d\u000e\u0003IR!a\r\u001b\u0002\u0013%lW.\u001e;bE2,'BA\u001b!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003oI\u0012A\u0001T5tiB\u0011\u0011\bP\u0007\u0002u)\u00111HD\u0001\u0006if\u0004Xm]\u0005\u0003{i\u00121AU8x\u0011\u0019y\u0004\u0001)A\u0005a\u0005)A-\u0019;bA!9\u0011\t\u0001b\u0001\n\u0003y\u0013\u0001\u00043bi\u0006<\u0016\u000e\u001e5Ok2d\u0007BB\"\u0001A\u0003%\u0001'A\u0007eCR\fw+\u001b;i\u001dVdG\u000e\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u00010\u0003!)8/\u001a:ECR\f\u0007BB$\u0001A\u0003%\u0001'A\u0005vg\u0016\u0014H)\u0019;bA!9\u0011\n\u0001b\u0001\n\u0003y\u0013\u0001E;tKJ$\u0015\r^1XSRDg*\u001e7m\u0011\u0019Y\u0005\u0001)A\u0005a\u0005\tRo]3s\t\u0006$\u0018mV5uQ:+H\u000e\u001c\u0011\t\u000b5\u0003A\u0011\t(\u0002\r\t,gm\u001c:f)\u0005y\u0005CA\u0010Q\u0013\t\t\u0006E\u0001\u0003V]&$\bF\u0001'T!\t!v+D\u0001V\u0015\t1&#A\u0003kk:LG/\u0003\u0002Y+\n1!)\u001a4pe\u0016DQA\u0017\u0001\u0005B9\u000bQ!\u00194uKJD#!\u0017/\u0011\u0005Qk\u0016B\u00010V\u0005\u0015\te\r^3s\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0003E\u0019'/Z1uK2{wn[;q)\u0006\u0014G.\u001a\u000b\u0004\u001f\n|\u0007\"B2`\u0001\u0004!\u0017!\u0003;bE2,g*Y7f!\t)GN\u0004\u0002gUB\u0011q\rI\u0007\u0002Q*\u0011\u0011\u000eF\u0001\u0007yI|w\u000e\u001e \n\u0005-\u0004\u0013A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a\u001b\u0011\t\u000b9z\u0006\u0019\u00019\u0011\u0007E4\bH\u0004\u0002si:\u0011qm]\u0005\u0002C%\u0011Q\u000fI\u0001\ba\u0006\u001c7.Y4f\u0013\t9tO\u0003\u0002vA!)\u0011\u0010\u0001C\u0005u\u0006\u00193M]3bi\u0016dun\\6vaR\u000b'\r\\3XSRD7i\\7qkR,GmQ8mk6tGcA(|y\")1\r\u001fa\u0001I\")a\u0006\u001fa\u0001a\")a\u0010\u0001C\u0005\u007f\u0006y1M]3bi\u0016\u001c6-\u00198UC\ndW\rF\u0003P\u0003\u0003\t\u0019\u0001C\u0003d{\u0002\u0007A\rC\u0003/{\u0002\u0007\u0001\u000f\u0003\u0004\u0002\b\u0001!\tAT\u0001,i\u0016\u001cH\u000fT3gi*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ2{7-\u00197Qe\u0016$\u0017nY1uK\"\"\u0011QAA\u0006!\r!\u0016QB\u0005\u0004\u0003\u001f)&\u0001\u0002+fgRDa!a\u0005\u0001\t\u0003q\u0015!\u0006;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.\u001a\u0015\u0005\u0003#\tY\u0001\u0003\u0004\u0002\u001a\u0001!\tAT\u0001\"i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eU;tQ\u0012{wO\u001c\u0015\u0005\u0003/\tY\u0001\u0003\u0004\u0002 \u0001!\tAT\u0001(i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\bNT8o\u000bF,\u0018\r\u001c$jYR,'\u000f\u000b\u0003\u0002\u001e\u0005-\u0001BBA\u0013\u0001\u0011\u0005a*\u0001\u0012uKN$(j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3P]6+H\u000e^5GS\u0016dGm\u001d\u0015\u0005\u0003G\tY\u0001\u0003\u0004\u0002,\u0001!\tAT\u0001*i\u0016\u001cHOS8j]R+W\u000e]8sC2$\u0016M\u00197f\u001f:lU\u000f\u001c;j\r&,G\u000eZ:XSRDW\u000b\u001a4)\t\u0005%\u00121\u0002\u0005\u0007\u0003c\u0001A\u0011\u0001(\u0002KQ,7\u000f\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK>sW*\u001e7uS.+\u0017PR5fY\u0012\u001c\b\u0006BA\u0018\u0003\u0017Aa!a\u000e\u0001\t\u0003q\u0015!\u0007;fgRdUM\u001a;K_&tG+Z7q_J\fG\u000eV1cY\u0016DC!!\u000e\u0002\f!1\u0011Q\b\u0001\u0005\u00029\u000b\u0011\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018nS3z\r&,G\u000eZ:XSRDg*\u001e7m\t\u0006$\u0018\r\u000b\u0003\u0002<\u0005-\u0001BBA\"\u0001\u0011\u0005a*A\u001buKN$H*\u001a4u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm],ji\"tU\u000f\u001c7ECR\f\u0007\u0006BA!\u0003\u0017Aa!!\u0013\u0001\t\u0003q\u0015A\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z(o\u001dVdGnQ8ogR\fg\u000e^&fs\"\"\u0011qIA\u0006\u0011\u0019\ty\u0005\u0001C\u0001\u001d\u0006AD/Z:u\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRL7*Z=GS\u0016dGm],ji\"tU\u000f\u001c7D_:\u001cH/\u00198u\u0017\u0016L\b\u0006BA'\u0003\u0017Aa!!\u0016\u0001\t\u0003q\u0015a\n;fgRTu.\u001b8UK6\u0004xN]1m)\u0006\u0014G.Z,ji\"\u001cu.\u001c9vi\u0016$7i\u001c7v[:DC!a\u0015\u0002\f!1\u00111\f\u0001\u0005\u00029\u000b!\u0007^3ti*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ\u000e{W\u000e];uK\u0012\u001cu\u000e\\;n]\u0006sG\rU;tQ\u0012{wO\u001c\u0015\u0005\u00033\nY\u0001K\u0004\u0001\u0003C\ni'a\u001c\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001aV\u0003\u0019\u0011XO\u001c8fe&!\u00111NA3\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001eV\u0003\u001d\u0011XO\u001c8feNLA!a\u001f\u0002v\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012<q!a \u0003\u0011\u0003\t\t)\u0001\tM_>\\W\u000f\u001d&pS:LEkQ1tKB\u0019!&a!\u0007\r\u0005\u0011\u0001\u0012AAC'\u0011\t\u0019)a\"\u0011\u0007}\tI)C\u0002\u0002\f\u0002\u0012a!\u00118z%\u00164\u0007bB\u0014\u0002\u0004\u0012\u0005\u0011q\u0012\u000b\u0003\u0003\u0003C\u0001\"a%\u0002\u0004\u0012\u0005\u0011QS\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAAL!\u0019\tI*a)\u0002(6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*\u0001\u0003vi&d'BAAQ\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00161\u0014\u0002\u000b\u0007>dG.Z2uS>t\u0007#B\u0010\u0002*\u00065\u0016bAAVA\t)\u0011I\u001d:bsB!\u0011qVA[\u001b\t\t\tL\u0003\u0003\u00024\u0006}\u0015\u0001\u00027b]\u001eLA!a.\u00022\n1qJ\u00196fGRD\u0003\"!%\u0002<\u0006%\u00171\u001a\t\u0005\u0003{\u000b\u0019M\u0004\u0003\u0002t\u0005}\u0016\u0002BAa\u0003k\nQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BAc\u0003\u000f\u0014!\u0002U1sC6,G/\u001a:t\u0015\u0011\t\t-!\u001e\u0002\t9\fW.Z\u0011\u0003\u0003\u001b\f\u0001\u0006T3hC\u000eLH+\u00192mKN{WO]2f{m\u0004T\u0010\f\u0011jg\u0006\u001b\u0018P\\2N_\u0012,\u0007%\u0010\u0011|cu\u0004")
public class LookupJoinITCase
extends BatchTestBase {
    private final boolean legacyTableSource;
    private final boolean isAsyncMode;
    private final List<Row> data;
    private final List<Row> dataWithNull;
    private final List<Row> userData;
    private final List<Row> userDataWithNull;

    @Parameterized.Parameters(name="LegacyTableSource={0}, isAsyncMode = {1}")
    public static Collection<Object[]> parameters() {
        return LookupJoinITCase$.MODULE$.parameters();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> dataWithNull() {
        return this.dataWithNull;
    }

    public List<Row> userData() {
        return this.userData;
    }

    public List<Row> userDataWithNull() {
        return this.userDataWithNull;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.createScanTable("T", this.data());
        this.createScanTable("nullableT", this.dataWithNull());
        this.createLookupTable("userTable", this.userData());
        this.createLookupTable("userTableWithNull", this.userDataWithNull());
        this.createLookupTableWithComputedColumn("userTableWithComputedColumn", this.userData());
        this.env().getConfig().disableObjectReuse();
    }

    @Override
    @After
    public void after() {
        if (this.legacyTableSource) {
            Assert.assertEquals((long)0L, (long)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get());
        } else {
            Assert.assertEquals((long)0L, (long)TestValuesTableFactory.RESOURCE_COUNTER.get());
        }
    }

    private void createLookupTable(String tableName, List<Row> data) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable(this.tEnv(), this.isAsyncMode, data, userSchema, tableName, true);
        } else {
            String dataId = TestValuesTableFactory.registerData(data);
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(439).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = '").append(this.isAsyncMode).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createLookupTableWithComputedColumn(String tableName, List<Row> data) {
        block0: {
            if (this.legacyTableSource) break block0;
            String dataId = TestValuesTableFactory.registerData(data);
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(493).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING,\n                         |  `nominal_age` as age + 1\n                         |) WITH (\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = '").append(this.isAsyncMode).append("',\n                         |  'bounded' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(435).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` BIGINT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("',\n                       |  'bounded' = 'true'\n                       |)\n                       |").toString())).stripMargin());
    }

    @Test
    public void testLeftJoinTemporalTableWithLocalPredicate() {
        String sql = new StringBuilder(190).append("SELECT T.id, T.len, T.content, D.name, D.age FROM T LEFT JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id ").append("AND T.len > 1 AND D.age > 20 AND D.name = 'Fabian' ").append("WHERE T.id > 1").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), "Hello world", null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), "Hello world!", null, null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTable() {
        String sql = new StringBuilder(112).append("SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithPushDown() {
        String sql = new StringBuilder(127).append("SELECT T.id, T.len, T.content, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithNonEqualFilter() {
        String sql = new StringBuilder(140).append("SELECT T.id, T.len, T.content, D.name, D.age FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiFields() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiFieldsWithUdf() {
        String sql = new StringBuilder(132).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON mod(T.id, 4) = D.id AND T.content = D.name").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFields() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinTemporalTable() {
        String sql = new StringBuilder(113).append("SELECT T.id, T.len, D.name, D.age FROM T LEFT JOIN userTable ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Jark", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), BoxesRunTime.boxToInteger((int)11), null, null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), BoxesRunTime.boxToInteger((int)12), null, null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder(142).append("SELECT T.id, T.len, D.name FROM nullableT T JOIN userTableWithNull ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testLeftJoinTemporalTableOnMultiKeyFieldsWithNullData() {
        String sql = new StringBuilder(147).append("SELECT D.id, T.len, D.name FROM nullableT T LEFT JOIN userTableWithNull ").append("for system_time as of T.proctime AS D ON T.content = D.name AND T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)15), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)11), null})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)12), null}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnNullConstantKey() {
        String sql = new StringBuilder(104).append("SELECT T.id, T.len, T.content FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON D.id = null").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableOnMultiKeyFieldsWithNullConstantKey() {
        String sql = new StringBuilder(124).append("SELECT T.id, T.len, D.name FROM T JOIN userTable ").append("for system_time as of T.proctime AS D ON T.content = D.name AND null = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithComputedColumn() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringBuilder(152).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12), "Julian", "Julian", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)12)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    @Test
    public void testJoinTemporalTableWithComputedColumnAndPushDown() {
        Assume.assumeFalse((boolean)this.legacyTableSource);
        String sql = new StringBuilder(175).append("SELECT T.id, T.len, T.content, D.name, D.age, D.nominal_age ").append("FROM T JOIN userTableWithComputedColumn ").append("for system_time as of T.proctime AS D ON T.id = D.id and D.nominal_age > 12").toString();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)15), "Hello", "Jark", BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToInteger((int)23)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)15), "Fabian", "Fabian", BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToInteger((int)34)}))}));
        this.checkResult(sql, (Seq<Row>)expected, this.checkResult$default$3());
    }

    public LookupJoinITCase(boolean legacyTableSource, boolean isAsyncMode) {
        this.legacyTableSource = legacyTableSource;
        this.isAsyncMode = isAsyncMode;
        this.data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)12L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)15L), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToLong((long)11L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"})), (List)Nil$.MODULE$)))));
        this.dataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)15L), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToLong((long)15L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToLong((long)11L), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToLong((long)12L), "Hello world!"})), (List)Nil$.MODULE$))));
        this.userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)Nil$.MODULE$)));
        this.userDataWithNull = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), null, "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)44), null, "Hello world"})), (List)Nil$.MODULE$))));
    }
}

