/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinITCaseHelper$;
import org.apache.flink.table.planner.runtime.batch.sql.join.JoinType$;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import scala.Enumeration;
import scala.Predef$;
import scala.Symbol;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001I\u0011!BS8j]&#6)Y:f\u0015\t\u0019A!A\u0003uC\ndWM\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005\rY!B\u0001\u0007\u000e\u0003\u00151G.\u001b8l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\tQ!\u001e;jYNL!\u0001G\u000b\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003 \u0001\u0011\u0005\u0001%\u0001\bvg\u0016\u001cH*Z4bGf\u0014vn^:\u0016\u0003\u0005\u0002\"A\t\u0013\u000e\u0003\rR!A\u0006\u0006\n\u0005\u0015\u001a#!\u0005'fO\u0006\u001c\u0017PU8x%\u0016\u001cx.\u001e:dK\"\u0012ad\n\t\u0003Q-j\u0011!\u000b\u0006\u0003U=\tQA[;oSRL!\u0001L\u0015\u0003\tI+H.\u001a\u0005\b]\u0001\u0011\r\u0011\"\u00010\u0003A)\u0007\u0010]3di\u0016$'j\\5o)f\u0004X-F\u00011!\t\tTJ\u0004\u00023\u0015:\u00111g\u0012\b\u0003i\u0015s!!\u000e#\u000f\u0005Y\u001aeBA\u001cC\u001d\tA\u0014I\u0004\u0002:\u0001:\u0011!h\u0010\b\u0003wyj\u0011\u0001\u0010\u0006\u0003{E\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u00059y\u0011B\u0001\u0007\u000e\u0013\t\u00191\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!A\u0012\u0003\u0002\u0007M\fH.\u0003\u0002I\u0013\u0006!!n\\5o\u0015\t1E!\u0003\u0002L\u0019\u0006A!j\\5o)f\u0004XM\u0003\u0002I\u0013&\u0011aj\u0014\u0002\t\u0015>Lg\u000eV=qK*\u00111\n\u0014\u0005\u0007#\u0002\u0001\u000b\u0011\u0002\u0019\u0002#\u0015D\b/Z2uK\u0012Tu.\u001b8UsB,\u0007\u0005C\u0003T\u0001\u0011\u0005C+\u0001\u0004cK\u001a|'/\u001a\u000b\u0002+B\u0011a+W\u0007\u0002/*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[/\n!QK\\5uQ\t\u0011F\f\u0005\u0002);&\u0011a,\u000b\u0002\u0007\u0005\u00164wN]3\t\u000b\u0001\u0004A\u0011\u0001+\u0002\u0011Q,7\u000f\u001e&pS:D#a\u00182\u0011\u0005!\u001a\u0017B\u00013*\u0005\u0011!Vm\u001d;\t\u000b\u0019\u0004A\u0011\u0001+\u0002\u0013Q,7\u000f\u001e&pS:\f\u0004FA3c\u0011\u0015I\u0007\u0001\"\u0001U\u0003I!Xm\u001d;K_&tw+\u001b;i\r&dG/\u001a:)\u0005!\u0014\u0007\"\u00027\u0001\t\u0003!\u0016A\u0006;fgRTu.\u001b8XSRD'j\\5o\r&dG/\u001a:)\u0005-\u0014\u0007\"B8\u0001\t\u0003!\u0016!\n;fgRLeN\\3s\u0015>LgnV5uQ:{g.R9vS*{\u0017N\u001c)sK\u0012L7-\u0019;fQ\tq'\rC\u0003s\u0001\u0011\u0005A+\u0001\ruKN$(j\\5o/&$\b.T;mi&\u0004H.Z&fsND#!\u001d2\t\u000bU\u0004A\u0011\u0001+\u0002/Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5BO\u001e\u0014XmZ1uS>t\u0007F\u0001;c\u0011\u0015A\b\u0001\"\u0001U\u0003y!Xm\u001d;K_&tw+\u001b;i\u000fJ|W\u000f]3e\u0003\u001e<'/Z4bi&|g\u000e\u000b\u0002xE\")1\u0010\u0001C\u0001)\u00069B/Z:u\u0015>Lg\u000eU;tQRC'o\\;hQ*{\u0017N\u001c\u0015\u0003u\nDQA \u0001\u0005\u0002Q\u000b1\u0004^3ti*{\u0017N\\,ji\"$\u0015n\u001d6v]\u000e$\u0018N^3Qe\u0016$\u0007FA?c\u0011\u0019\t\u0019\u0001\u0001C\u0001)\u0006YB/Z:u\u0015>LgnV5uQ\u0016C\bO]3tg&|g\u000e\u0015:fIND3!!\u0001c\u0011\u0019\tI\u0001\u0001C\u0001)\u0006aB/Z:u\u0019\u00164GOS8j]^KG\u000f['vYRL\u0007\u000f\\3LKf\u001c\bfAA\u0004E\"1\u0011q\u0002\u0001\u0005\u0002Q\u000bq\u0004^3ti2+g\r\u001e&pS:<\u0016\u000e\u001e5O_:,\u0015/^5K_&t\u0007K]3eQ\r\tiA\u0019\u0005\u0007\u0003+\u0001A\u0011\u0001+\u0002;Q,7\u000f\u001e'fMRTu.\u001b8XSRDG*\u001a4u\u0019>\u001c\u0017\r\u001c)sK\u0012D3!a\u0005c\u0011\u0019\tY\u0002\u0001C\u0001)\u0006iB/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0017\u0016L8\u000fK\u0002\u0002\u001a\tDa!!\t\u0001\t\u0003!\u0016\u0001\t;fgR\u0014\u0016n\u001a5u\u0015>LgnV5uQ:{g.R9vS*{\u0017N\u001c)sK\u0012D3!a\bc\u0011\u0019\t9\u0003\u0001C\u0001)\u0006qB/Z:u%&<\u0007\u000e\u001e&pS:<\u0016\u000e\u001e5MK\u001a$Hj\\2bYB\u0013X\r\u001a\u0015\u0004\u0003K\u0011\u0007BBA\u0017\u0001\u0011\u0005A+A\u0011uKN$h)\u001e7m\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0017\u0016L8\u000fK\u0002\u0002,\tDa!a\r\u0001\t\u0003!\u0016a\b;fgR4U\u000f\u001c7K_&tw+\u001b;i\u001d>tW)];j\u0015>Lg\u000e\u0015:fI\"\u001a\u0011\u0011\u00072\t\r\u0005e\u0002\u0001\"\u0001U\u0003u!Xm\u001d;Gk2d'j\\5o/&$\b\u000eT3gi2{7-\u00197Qe\u0016$\u0007fAA\u001cE\"1\u0011q\b\u0001\u0005\u0002Q\u000bA\u0003^3tiV#EK\u0012&pS:|e\u000eV;qY\u0016\u001c\bfAA\u001fE\u0002")
public class JoinITCase
extends BatchTestBase {
    private final Enumeration.Value expectedJoinType = JoinType$.MODULE$.SortMergeJoin();

    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    public Enumeration.Value expectedJoinType() {
        return this.expectedJoinType;
    }

    @Override
    @Before
    public void before() {
        super.before();
        JoinITCaseHelper$.MODULE$.disableOtherJoinOpForJoin(this.tEnv(), this.expectedJoinType());
    }

    @Test
    public void testJoin() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoin1() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        FuncWithOpen testOpenCall = new FuncWithOpen();
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)testOpenCall).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$plus(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithFilter() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet$default$2()).as("a", new String[]{"b", "c"});
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), CollectionBatchExecTable$.MODULE$.get5TupleDataSet$default$2()).as("d", new String[]{"e", "f", "g", "h"});
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithJoinFilter() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(6)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\nHello world, how are you?,Hallo Welt wie\nI am fine.,Hallo Welt wie\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testInnerJoinWithNonEquiJoinPredicate() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(6)))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$less(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq<Row> results = this.executeQuery(joinT);
        String expected = "Hello world, how are you?,Hallo Welt wie\nI am fine.,Hallo Welt wie\n";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nI am fine.,HIJ\nI am fine.,IJK\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithAggregation() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).count()});
        String expected = "6";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithGroupedAggregation() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")).count()});
        String expected = "6,3\n4,2\n1,1";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinPushThroughJoin() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds3 = CollectionBatchExecTable$.MODULE$.getSmall3TupleDataSet(this.tEnv(), "j, k, l");
        Table joinT = ds1.join(ds2).where(package$.MODULE$.boolean2Literal(true)).join(ds3).where(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "k"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))});
        String expected = "2,1,Hello\n2,1,Hello world\n1,0,Hi";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithDisjunctivePred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")))).$bar$bar(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")).$minus(package$.MODULE$.int2Literal(10)))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nI am fine.,IJK";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testJoinWithExpressionPreds() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.join(ds2).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$plus(package$.MODULE$.int2Literal(1)))).$amp$amp(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$minus(package$.MODULE$.int2Literal(1))).$eq$eq$eq(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).$plus(package$.MODULE$.int2Literal(2))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "I am fine.,Hallo Welt\nLuke Skywalker,Hallo Welt wie gehts?\nLuke Skywalker,ABC\nComment#2,HIJ\nComment#2,IJK";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nHello world, how are you?,null\nI am fine.,HIJ\nI am fine.,IJK\nLuke Skywalker,null\nComment#1,null\nComment#2,null\nComment#3,null\nComment#4,null\nComment#5,null\nComment#6,null\nComment#7,null\nComment#8,null\nComment#9,null\nComment#10,null\nComment#11,null\nComment#12,null\nComment#13,null\nComment#14,null\nComment#15,null\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testLeftJoinWithNonEquiJoinPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testLeftJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.leftOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt", "Hello,Hallo Welt wie", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "Hi,null", "Hello world, how are you?,null", "I am fine.,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testRightJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nnull,Hallo Welt wie\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nI am fine.,HIJ\nI am fine.,IJK\nnull,JKL\nnull,KLM\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testRightJoinWithNonEquiJoinPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testRightJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table joinT = ds1.rightOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt", "Hello,Hallo Welt wie", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "Hi,null", "Hello world, how are you?,null", "I am fine.,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testFullOuterJoinWithMultipleKeys() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        String expected = "Hi,Hallo\nHello,Hallo Welt\nnull,Hallo Welt wie\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nnull,BCD\nnull,CDE\nnull,DEF\nnull,EFG\nnull,FGH\nnull,GHI\nI am fine.,HIJ\nI am fine.,IJK\nnull,JKL\nnull,KLM\nLuke Skywalker,null\nComment#1,null\nComment#2,null\nComment#3,null\nComment#4,null\nComment#5,null\nComment#6,null\nComment#7,null\nComment#8,null\nComment#9,null\nComment#10,null\nComment#11,null\nComment#12,null\nComment#13,null\nComment#14,null\nComment#15,null\nHello world, how are you?,null\n";
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testFullJoinWithNonEquiJoinPred() {
        this.tEnv().getConfig().setNullCheck(Predef$.MODULE$.boolean2Boolean(true));
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$less$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h"))))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hi,Hallo", "Hello,Hallo Welt", "Hello world,Hallo Welt wie gehts?", "Hello world,ABC", "Hello world,BCD", "I am fine.,HIJ", "I am fine.,IJK", "Hello world, how are you?,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null", "null,Hallo Welt wie", "null,CDE", "null,DEF", "null,EFG", "null,FGH", "null,GHI", "null,JKL", "null,KLM"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testFullJoinWithLeftLocalPred() {
        Table ds1 = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table ds2 = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "d, e, f, g, h");
        Table joinT = ds1.fullOuterJoin(ds2, package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$greater$eq(package$.MODULE$.int2Literal(2)))).$amp$amp(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")).$eq$eq$eq(package$.MODULE$.int2Literal(1)))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))});
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hello,Hallo Welt wie", "Hello world, how are you?,DEF", "Hello world, how are you?,EFG", "I am fine.,GHI", "Hi,null", "Hello world,null", "Luke Skywalker,null", "Comment#1,null", "Comment#2,null", "Comment#3,null", "Comment#4,null", "Comment#5,null", "Comment#6,null", "Comment#7,null", "Comment#8,null", "Comment#9,null", "Comment#10,null", "Comment#11,null", "Comment#12,null", "Comment#13,null", "Comment#14,null", "Comment#15,null", "null,Hallo", "null,Hallo Welt", "null,Hallo Welt wie gehts?", "null,ABC", "null,BCD", "null,CDE", "null,FGH", "null,HIJ", "null,IJK", "null,JKL", "null,KLM"}));
        Seq<Row> results = this.executeQuery(joinT);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected.mkString("\n"));
    }

    @Test
    public void testUDTFJoinOnTuples() {
        .colon.colon data = new .colon.colon((Object)"hi#world", (List)new .colon.colon((Object)"how#are#you", (List)Nil$.MODULE$));
        Table ds1 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), data, "a", ClassTag$.MODULE$.apply(String.class), BasicTypeInfo.getInfoFor(String.class));
        TableFunc2 func2 = new TableFunc2();
        Table joinDs = ds1.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "name"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "len")})));
        Seq<Row> results = this.executeQuery(joinDs);
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hi#world,hi,2", "hi#world,world,5", "how#are#you,how,3", "how#are#you,are,3", "how#are#you,you,3"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }
}

