/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;

public class TemporalJoinJsonPlanITCase
extends JsonPlanTestBase {
    @Override
    public void setup() throws Exception {
        super.setup();
        List<Row> orders = Arrays.asList(Row.of((Object[])new Object[]{2L, "Euro", 2L}), Row.of((Object[])new Object[]{1L, "US Dollar", 3L}), Row.of((Object[])new Object[]{50L, "Yen", 4L}), Row.of((Object[])new Object[]{3L, "Euro", 5L}));
        this.createTestValuesSourceTable("Orders", orders, "amount bigint", "currency STRING", "order_time bigint", "rowtime as TO_TIMESTAMP(FROM_UNIXTIME(order_time)) ", "proctime as PROCTIME()", "WATERMARK FOR rowtime AS rowtime");
        List<Row> ratesHistory = Arrays.asList(Row.of((Object[])new Object[]{"US Dollar", 102L, 1L}), Row.of((Object[])new Object[]{"Euro", 114L, 1L}), Row.of((Object[])new Object[]{"Yen", 1L, 1L}), Row.of((Object[])new Object[]{"Euro", 116L, 5L}), Row.of((Object[])new Object[]{"Euro", 119L, 7L}));
        this.createTestValuesSourceTable("RatesHistory", ratesHistory, "currency STRING", "rate bigint", "rate_time bigint", "rowtime as TO_TIMESTAMP(FROM_UNIXTIME(rate_time)) ", "proctime as PROCTIME()", "WATERMARK FOR rowtime AS rowtime", "PRIMARY KEY(currency) NOT ENFORCED");
        TemporalTableFunction temporalTableFunction = this.tableEnv.from("RatesHistory").createTemporalTableFunction("rowtime", "currency");
        this.tableEnv.createTemporarySystemFunction("Rates", (UserDefinedFunction)temporalTableFunction);
        this.createTestValuesSinkTable("MySink", "amount bigint");
    }

    @Test
    public void testJoinTemporalFunction() throws Exception {
        this.compileSqlAndExecutePlan("INSERT INTO MySink SELECT amount * r.rate FROM Orders AS o,  LATERAL TABLE (Rates(o.rowtime)) AS r WHERE o.currency = r.currency ").await();
        List<String> expected = Arrays.asList("+I[102]", "+I[228]", "+I[348]", "+I[50]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testTemporalTableJoin() throws Exception {
        this.compileSqlAndExecutePlan("INSERT INTO MySink SELECT amount * r.rate FROM Orders AS o  JOIN RatesHistory  FOR SYSTEM_TIME AS OF o.rowtime AS r ON o.currency = r.currency ").await();
        List<String> expected = Arrays.asList("+I[102]", "+I[228]", "+I[348]", "+I[50]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }
}

