/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.module;

import java.util.Optional;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.junit.Test;

public class ModuleITCase
extends StreamingTestBase {
    @Test
    public void testTableSourceFactory() {
        this.tEnv().createTemporaryTable("T", TableFactoryHarness.newBuilder().schema(Schema.newBuilder().build()).source(new TableFactoryHarness.ScanSourceBase(){

            @Override
            public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
                throw new UnsupportedOperationException("Discovered factory should not be used");
            }
        }).build());
        Table table = this.tEnv().from("T");
        CommonTestUtils.assertThrows((String)"Discovered factory should not be used", UnsupportedOperationException.class, () -> table.explain(new ExplainDetail[0]));
        this.tEnv().loadModule("M", (Module)new SourceSinkFactoryOverwriteModule());
        table.explain(new ExplainDetail[0]);
    }

    @Test
    public void testTableSinkFactory() {
        this.tEnv().createTemporaryTable("T", TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build()).sink(new TableFactoryHarness.SinkBase(){

            @Override
            public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
                throw new UnsupportedOperationException("Discovered factory should not be used");
            }
        }).build());
        CommonTestUtils.assertThrows((String)"Discovered factory should not be used", UnsupportedOperationException.class, () -> this.tEnv().explainSql("INSERT INTO T SELECT 1", new ExplainDetail[0]));
        this.tEnv().loadModule("M", (Module)new SourceSinkFactoryOverwriteModule());
        this.tEnv().explainSql("INSERT INTO T SELECT 1", new ExplainDetail[0]);
    }

    private static class FactoryBase
    implements Factory {
        private FactoryBase() {
        }

        public String factoryIdentifier() {
            throw new UnsupportedOperationException();
        }

        public Set<ConfigOption<?>> requiredOptions() {
            throw new UnsupportedOperationException();
        }

        public Set<ConfigOption<?>> optionalOptions() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SinkFactory
    extends FactoryBase
    implements DynamicTableSinkFactory {
        private SinkFactory() {
        }

        public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
            return new TableFactoryHarness.SinkBase(){};
        }
    }

    private static class SourceFactory
    extends FactoryBase
    implements DynamicTableSourceFactory {
        private SourceFactory() {
        }

        public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
            return new TableFactoryHarness.ScanSourceBase(){};
        }
    }

    private static class SourceSinkFactoryOverwriteModule
    implements Module {
        private SourceSinkFactoryOverwriteModule() {
        }

        public Optional<DynamicTableSourceFactory> getTableSourceFactory() {
            return Optional.of(new SourceFactory());
        }

        public Optional<DynamicTableSinkFactory> getTableSinkFactory() {
            return Optional.of(new SinkFactory());
        }
    }
}

