/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Collection;
import java.util.Optional;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.AsyncLookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestAddWithOpen$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestExceptionThrown$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestMod$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestWrapperUdf$;
import org.apache.flink.types.Row;
import org.apache.flink.util.ExceptionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u0001M\u0011Q#Q:z]\u000edun\\6va*{\u0017N\\%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0012Y\u0016<\u0017mY=UC\ndWmU8ve\u000e,\u0007CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"a\u0002\"p_2,\u0017M\u001c\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u00059!-Y2lK:$\u0007CA\u0013:\u001d\t1sG\u0004\u0002(m9\u0011\u0001&\u000e\b\u0003SQr!AK\u001a\u000f\u0005-\u0012dB\u0001\u00172\u001d\ti\u0003'D\u0001/\u0015\ty##\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t9b!\u0003\u00029-\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK&\u0011!h\u000f\u0002\u0011'R\fG/\u001a\"bG.,g\u000eZ'pI\u0016T!\u0001\u000f\f\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\ry\u0014I\u0011\t\u0003\u0001\u0002i\u0011A\u0001\u0005\u00067q\u0002\r\u0001\b\u0005\u0006Gq\u0002\r\u0001\n\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0003\u0011!\u0017\r^1\u0016\u0003\u0019\u00032a\u0012'O\u001b\u0005A%BA%K\u0003%IW.\\;uC\ndWM\u0003\u0002L=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055C%\u0001\u0002'jgR\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u0007\u0002\u000bQL\b/Z:\n\u0005M\u0003&a\u0001*po\"1Q\u000b\u0001Q\u0001\n\u0019\u000bQ\u0001Z1uC\u0002Bqa\u0016\u0001C\u0002\u0013\u0005Q)\u0001\u0005vg\u0016\u0014H)\u0019;b\u0011\u0019I\u0006\u0001)A\u0005\r\u0006IQo]3s\t\u0006$\u0018\r\t\u0005\u00067\u0002!\t\u0005X\u0001\u0007E\u00164wN]3\u0015\u0003u\u0003\"!\b0\n\u0005}s\"\u0001B+oSRD#AW1\u0011\u0005\t,W\"A2\u000b\u0005\u0011\u0004\u0012!\u00026v]&$\u0018B\u00014d\u0005\u0019\u0011UMZ8sK\")\u0001\u000e\u0001C!9\u0006)\u0011M\u001a;fe\"\u0012qM\u001b\t\u0003E.L!\u0001\\2\u0003\u000b\u00053G/\u001a:\t\u000b9\u0004A\u0011B8\u0002#\r\u0014X-\u0019;f\u0019>|7.\u001e9UC\ndW\rF\u0002^ajDQ!]7A\u0002I\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\u0005M<hB\u0001;v!\tic$\u0003\u0002w=\u00051\u0001K]3eK\u001aL!\u0001_=\u0003\rM#(/\u001b8h\u0015\t1h\u0004C\u0003E[\u0002\u00071\u0010\u0005\u0003}\u0003\u0007qeBA?\u0000\u001d\tic0C\u0001 \u0013\r\t\tAH\u0001\ba\u0006\u001c7.Y4f\u0013\ri\u0015Q\u0001\u0006\u0004\u0003\u0003q\u0002bBA\u0005\u0001\u0011%\u00111B\u0001\u0010GJ,\u0017\r^3TG\u0006tG+\u00192mKR)Q,!\u0004\u0002\u0010!1\u0011/a\u0002A\u0002IDa\u0001RA\u0004\u0001\u0004Y\bBBA\n\u0001\u0011\u0005A,\u0001\u0016uKN$\u0018i]=oG*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018nS3z\r&,G\u000eZ:)\t\u0005E\u0011q\u0003\t\u0004E\u0006e\u0011bAA\u000eG\n!A+Z:u\u0011\u0019\ty\u0002\u0001C\u00019\u0006QB/Z:u\u0003NLhn\u0019&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\"\u0011QDA\f\u0011\u0019\t)\u0003\u0001C\u00019\u00061C/Z:u\u0003NLhn\u0019&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b)vg\"$un\u001e8)\t\u0005\r\u0012q\u0003\u0005\u0007\u0003W\u0001A\u0011\u0001/\u0002YQ,7\u000f^!ts:\u001c'j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDgj\u001c8FcV\fGNR5mi\u0016\u0014\b\u0006BA\u0015\u0003/Aa!!\r\u0001\t\u0003a\u0016\u0001\r;fgR\f5/\u001f8d\u0019\u00164GOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eT8dC2\u0004&/\u001a3jG\u0006$X\r\u000b\u0003\u00020\u0005]\u0001BBA\u001c\u0001\u0011\u0005A,A\u0014uKN$\u0018i]=oG*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018NR5fY\u0012\u001c\b\u0006BA\u001b\u0003/Aa!!\u0010\u0001\t\u0003a\u0016A\f;fgR\f5/\u001f8d\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRLg)[3mIN<\u0016\u000e\u001e5VI\u001aDC!a\u000f\u0002\u0018!1\u00111\t\u0001\u0005\u0002q\u000bq\u0005^3ti\u0006\u001b\u0018P\\2K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5VI\u001a4\u0015\u000e\u001c;fe\"\"\u0011\u0011IA\f\u0011\u0019\tI\u0005\u0001C\u00019\u0006!C/Z:u\u0003\u001e<\u0017I\u001c3Bgft7\rT3gi*{\u0017N\u001c+f[B|'/\u00197UC\ndW\r\u000b\u0003\u0002H\u0005]\u0001BBA(\u0001\u0011\u0005A,\u0001\u0010uKN$\u0018i]=oG2+g\r\u001e&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\"\u0011QJA\f\u0011\u0019\t)\u0006\u0001C\u00019\u0006iC/Z:u\u000bb\u001cW\r\u001d;j_:$\u0006N]8x]\u001a\u0013x.\\!ts:\u001c'j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3)\t\u0005M\u0013q\u0003\u0015\b\u0001\u0005m\u0013qMA5!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1G\u00061!/\u001e8oKJLA!!\u001a\u0002`\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA6!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9G\u00069!/\u001e8oKJ\u001c\u0018\u0002BA;\u0003_\u0012Q\u0002U1sC6,G/\u001a:ju\u0016$waBA=\u0005!\u0005\u00111P\u0001\u0016\u0003NLhn\u0019'p_.,\bOS8j]&#6)Y:f!\r\u0001\u0015Q\u0010\u0004\u0007\u0003\tA\t!a \u0014\t\u0005u\u0014\u0011\u0011\t\u0004;\u0005\r\u0015bAAC=\t1\u0011I\\=SK\u001aDq!PA?\t\u0003\tI\t\u0006\u0002\u0002|!A\u0011QRA?\t\u0003\ty)\u0001\u0006qCJ\fW.\u001a;feN$\"!!%\u0011\r\u0005M\u0015QTAQ\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015\u0001B;uS2T!!a'\u0002\t)\fg/Y\u0005\u0005\u0003?\u000b)J\u0001\u0006D_2dWm\u0019;j_:\u0004R!HAR\u0003OK1!!*\u001f\u0005\u0015\t%O]1z!\u0011\tI+a,\u000e\u0005\u0005-&\u0002BAW\u00033\u000bA\u0001\\1oO&!\u0011\u0011WAV\u0005\u0019y%M[3di\"B\u00111RA[\u0003\u0007\f)\r\u0005\u0003\u00028\u0006uf\u0002BA7\u0003sKA!a/\u0002p\u0005i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a0\u0002B\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005m\u0016qN\u0001\u0005]\u0006lW-\t\u0002\u0002H\u00069C*Z4bGf$\u0016M\u00197f'>,(oY3>wBjH\u0006I*uCR,')Y2lK:$Wh_\u0019~\u0001")
public class AsyncLookupJoinITCase
extends StreamingWithStateTestBase {
    private final boolean legacyTableSource;
    private final List<Row> data;
    private final List<Row> userData;

    @Parameterized.Parameters(name="LegacyTableSource={0}, StateBackend={1}")
    public static Collection<Object[]> parameters() {
        return AsyncLookupJoinITCase$.MODULE$.parameters();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> userData() {
        return this.userData;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.env().getConfig().disableObjectReuse();
        this.createScanTable("src", this.data());
        this.createLookupTable("user_table", this.userData());
    }

    @Override
    @After
    public void after() {
        super.after();
        if (this.legacyTableSource) {
            Assert.assertEquals((long)0L, (long)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get());
        } else {
            Assert.assertEquals((long)0L, (long)TestValuesTableFactory.RESOURCE_COUNTER.get());
        }
    }

    private void createLookupTable(String tableName, List<Row> data) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), true, data, userSchema, tableName, InMemoryLookupableTableSource$.MODULE$.createTemporaryTable$default$6());
        } else {
            String dataId = TestValuesTableFactory.registerData(data);
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(395).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(386).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` INT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @Test
    public void testAsyncJoinTemporalTableOnMultiKeyFields() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.id, t1.len, D.name\n        |FROM (select content, id, len, proctime FROM src AS T) t1\n        |JOIN user_table for system_time as of t1.proctime AS D\n        |ON t1.content = D.name AND t1.id = D.id\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableWithPushDown() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableWithNonEqualFilter() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22", "3,15,Fabian,Fabian,33"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncLeftJoinTemporalTableWithLocalPredicate() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.len > 1 AND D.age > 20 AND D.name = 'Fabian' WHERE T.id > 1";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,null,null", "3,15,Fabian,Fabian,33", "8,11,Hello world,null,null", "9,12,Hello world!,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableOnMultiFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableOnMultiFieldsWithUdf() {
        this.tEnv().registerFunction("mod1", (ScalarFunction)UserDefinedFunctionTestUtils$TestMod$.MODULE$);
        this.tEnv().registerFunction("wrapper1", (ScalarFunction)UserDefinedFunctionTestUtils$TestWrapperUdf$.MODULE$);
        String sql = "SELECT T.id, T.len, wrapper1(D.name) as name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON mod1(T.id, 4) = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableWithUdfFilter() {
        this.tEnv().registerFunction("add", (ScalarFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE add(T.id, D.id) > 3 AND add(T.id, 2) > 3 AND add (D.id, 2) > 3";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        Assert.assertEquals((long)0L, (long)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter().get());
    }

    @Test
    public void testAggAndAsyncLeftJoinTemporalTable() {
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().registerTable("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON t1.id = D.id";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,null,null", "9,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncLeftJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,Jark,22", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testExceptionThrownFromAsyncJoinTemporalTable() {
        this.tEnv().registerFunction("errorFunc", (ScalarFunction)UserDefinedFunctionTestUtils$TestExceptionThrown$.MODULE$);
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id where errorFunc(D.name) > cast(1000 as decimal(10,4))";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        try {
            this.env().execute();
        }
        catch (Throwable t) {
            Optional exception = ExceptionUtils.findThrowable((Throwable)t, NumberFormatException.class);
            Assert.assertTrue((boolean)exception.isPresent());
            Assert.assertTrue((boolean)((Throwable)exception.get()).getMessage().contains("Cannot parse"));
            return;
        }
        Assert.fail((String)"NumberFormatException is expected here!");
    }

    public AsyncLookupJoinITCase(boolean legacyTableSource, StreamingWithStateTestBase.StateBackendMode backend) {
        this.legacyTableSource = legacyTableSource;
        super(backend);
        this.data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$)))));
        this.userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)Nil$.MODULE$)));
    }
}

