/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.TestDataTypeTableSourceWithTime$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001'\tyA+[7fgR\fW\u000e]%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011\u0011c\u0015;sK\u0006l\u0017N\\4UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003!\u0001\u0011\u0005\u0013%\u0001\u0004cK\u001a|'/\u001a\u000b\u0002EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t!QK\\5u\u0011\u0015I\u0003\u0001\"\u0001\"\u0003Q!Xm\u001d;He>,\bOQ=US6,7\u000f^1na\"\u0012\u0001f\u000b\t\u0003Y=j\u0011!\f\u0006\u0003]A\tQA[;oSRL!\u0001M\u0017\u0003\tQ+7\u000f\u001e\u0005\u0006e\u0001!\t!I\u0001\u001fi\u0016\u001cHo\u0012:pkB\u0014\u0015\u0010T8dC2TvN\\3e)&lWm\u001d;b[BD#!M\u0016\t\u000bU\u0002A\u0011A\u0011\u00029Q,7\u000f^\"pk:$H)[:uS:\u001cGo\u00148US6,7\u000f^1na\"\u0012Ag\u000b\u0005\u0006q\u0001!\t!I\u0001'i\u0016\u001cHoQ8v]R$\u0015n\u001d;j]\u000e$xJ\u001c'pG\u0006d'l\u001c8fIRKW.Z:uC6\u0004\bFA\u001c,\u0011\u0015Y\u0004\u0001\"\u0001\"\u0003U!Xm\u001d;NCbl\u0015N\\(o)&lWm\u001d;b[BD#AO\u0016\t\u000by\u0002A\u0011A\u0011\u0002AQ,7\u000f^'bq6KgnV5uQJ+GO]1di>sG+[7fgR\fW\u000e\u001d\u0015\u0003{-\u0002")
public class TimestampITCase
extends StreamingTestBase {
    @Override
    public void before() {
        super.before();
        TableSchema tableSchema = TableSchema.builder().fields((String[])((Object[])new String[]{"a", "b", "c", "d", "e"}), (DataType[])((Object[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.TIMESTAMP((int)9), DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)})).build();
        List ints = List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)4), null}));
        List longs = List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToLong((long)4L), null}));
        .colon.colon datetimes = new .colon.colon((Object)DateTimeTestUtil$.MODULE$.localDateTime("1969-01-01 00:00:00.123456789"), (List)new .colon.colon((Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456"), (List)new .colon.colon((Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123456"), (List)new .colon.colon((Object)DateTimeTestUtil$.MODULE$.localDateTime("1970-01-01 00:00:00.123"), (List)new .colon.colon(null, (List)Nil$.MODULE$)))));
        .colon.colon timestamps = new .colon.colon((Object)Timestamp.valueOf("1969-01-01 00:00:00.123456789").toLocalDateTime(), (List)new .colon.colon((Object)Timestamp.valueOf("1970-01-01 00:00:00.123456").toLocalDateTime(), (List)new .colon.colon((Object)Timestamp.valueOf("1970-01-01 00:00:00.123").toLocalDateTime(), (List)new .colon.colon((Object)Timestamp.valueOf("1972-01-01 00:00:00").toLocalDateTime(), (List)new .colon.colon((Object)Timestamp.valueOf("1973-01-01 00:00:00").toLocalDateTime(), (List)Nil$.MODULE$)))));
        MutableList instants = new MutableList();
        datetimes.indices().foreach(arg_0 -> TimestampITCase.$anonfun$before$1$adapted((List)datetimes, instants, arg_0));
        MutableList data = new MutableList();
        ints.indices().foreach(arg_0 -> TimestampITCase.$anonfun$before$2$adapted(ints, longs, (List)datetimes, (List)timestamps, instants, data, arg_0));
        TestDataTypeTableSourceWithTime$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), tableSchema, "T", (Seq<Row>)data.seq(), "d");
    }

    @Test
    public void testGroupByTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT COUNT(a), c FROM T GROUP BY c")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,null", "1,1969-01-01T00:00:00.123456789", "1,1970-01-01T00:00:00.123", "2,1970-01-01T00:00:00.123456"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGroupByLocalZonedTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT COUNT(a), e FROM T GROUP BY e")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,null", "1,1969-01-01T00:00:00.123456789Z", "1,1970-01-01T00:00:00.123Z", "2,1970-01-01T00:00:00.123456Z"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCountDistinctOnTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT COUNT(DISTINCT c), b FROM T GROUP BY b")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,null", "1,1", "1,2", "1,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCountDistinctOnLocalZonedTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT COUNT(DISTINCT e), b FROM T GROUP BY b")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0,null", "1,1", "1,2", "1,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMaxMinOnTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT MAX(c), MIN(c), b FROM T GROUP BY b")).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1969-01-01T00:00:00.123456789,1969-01-01T00:00:00.123456789,1", "null,null,null", "1970-01-01T00:00:00.123456,1970-01-01T00:00:00.123456,2", "1970-01-01T00:00:00.123,1970-01-01T00:00:00.123,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMaxMinWithRetractOnTimestamp() {
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                   |SELECT MAX(y), MIN(x)\n                   |FROM\n                   |  (SELECT b, MAX(c) AS x, MIN(c) AS y FROM T GROUP BY b, c)\n                   |GROUP BY b\n       ")).stripMargin())).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1969-01-01T00:00:00.123456789,1969-01-01T00:00:00.123456789", "1970-01-01T00:00:00.123,1970-01-01T00:00:00.123", "1970-01-01T00:00:00.123456,1970-01-01T00:00:00.123456", "null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ MutableList $anonfun$before$1(List datetimes$1, MutableList instants$1, int i) {
        return datetimes$1.apply(i) == null ? instants$1.$plus$eq(null) : instants$1.$plus$eq((Object)((ChronoLocalDateTime)datetimes$1.apply(i)).toInstant(ZoneId.of("UTC").getRules().getOffset((LocalDateTime)datetimes$1.apply(i))));
    }

    public static final /* synthetic */ MutableList $anonfun$before$1$adapted(List datetimes$1, MutableList instants$1, Object i) {
        return TimestampITCase.$anonfun$before$1(datetimes$1, instants$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ MutableList $anonfun$before$2$adapted(List ints$1, List longs$1, List datetimes$1, List timestamps$1, MutableList instants$1, MutableList data$1, Object i) {
        return data$1.$plus$eq((Object)BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ints$1.apply(BoxesRunTime.unboxToInt((Object)i)), longs$1.apply(BoxesRunTime.unboxToInt((Object)i)), datetimes$1.apply(BoxesRunTime.unboxToInt((Object)i)), timestamps$1.apply(BoxesRunTime.unboxToInt((Object)i)), instants$1.apply(BoxesRunTime.unboxToInt((Object)i))})));
    }
}

