/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.RangeInputFormat;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.planner.utils.TestingTableEnvironment$;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011=d\u0001B\u0001\u0003\u0001E\u0011QBQ1uG\"$Vm\u001d;CCN,'BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t)\")\u0019;dQ\u0006\u00137\u000f\u001e:bGR$Vm\u001d;CCN,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0004\u001c\u0001\t\u0007I\u0011\u0002\u000f\u0002\u0011M,G\u000f^5oON,\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A!\t1!\u00199j\u0013\t\u0011sDA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000f\u0003\u0004%\u0001\u0001\u0006I!H\u0001\ng\u0016$H/\u001b8hg\u0002BqA\n\u0001C\u0002\u0013%q%A\buKN$\u0018N\\4UC\ndW-\u00128w+\u0005A\u0003CA\u0015,\u001b\u0005Q#BA\u0002\u0007\u0013\ta#FA\fUKN$\u0018N\\4UC\ndW-\u00128wSJ|g.\\3oi\"1a\u0006\u0001Q\u0001\n!\n\u0001\u0003^3ti&tw\rV1cY\u0016,eN\u001e\u0011\t\u000fA\u0002!\u0019!C\u0001c\u0005!A/\u00128w+\u0005\u0011\u0004C\u0001\u00104\u0013\t!tD\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"1a\u0007\u0001Q\u0001\nI\nQ\u0001^#om\u0002Bqa\u0002\u0001C\u0002\u0013%\u0001(F\u0001:!\tQT(D\u0001<\u0015\tad!\u0001\u0006eK2,w-\u0019;j_:L!AP\u001e\u0003\u0017Ac\u0017M\u001c8fe\n\u000b7/\u001a\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u001d\u0002\u0011Ad\u0017M\u001c8fe\u0002BqA\u0011\u0001C\u0002\u0013\u00051)A\u0002f]Z,\u0012\u0001\u0012\t\u0003\u000b.k\u0011A\u0012\u0006\u0003\u000f\"\u000b1\"\u001a8wSJ|g.\\3oi*\u0011\u0001%\u0013\u0006\u0003\u0015*\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u000513%AG*ue\u0016\fW.\u0012=fGV$\u0018n\u001c8F]ZL'o\u001c8nK:$\bB\u0002(\u0001A\u0003%A)\u0001\u0003f]Z\u0004\u0003b\u0002)\u0001\u0005\u0004%\t!U\u0001\fi\u0006\u0014G.Z\"p]\u001aLw-F\u0001S!\tq2+\u0003\u0002U?\tYA+\u00192mK\u000e{gNZ5h\u0011\u00191\u0006\u0001)A\u0005%\u0006aA/\u00192mK\u000e{gNZ5hA!9\u0001\f\u0001b\u0001\n\u0003I\u0016\u0001\u0005'J\u001d\u0016{6i\u0014'`!\u0006#F+\u0012*O+\u0005Q\u0006CA.c\u001b\u0005a&BA/_\u0003\u0015\u0011XmZ3y\u0015\ty\u0006-\u0001\u0003vi&d'\"A1\u0002\t)\fg/Y\u0005\u0003Gr\u0013q\u0001U1ui\u0016\u0014h\u000e\u0003\u0004f\u0001\u0001\u0006IAW\u0001\u0012\u0019&sUiX\"P\u0019~\u0003\u0016\t\u0016+F%:\u0003\u0003bB4\u0001\u0005\u0004%\t!W\u0001\u0017\u0019&sUiX\"P\u0019~#v+S\"F?B\u000bE\u000bV#S\u001d\"1\u0011\u000e\u0001Q\u0001\ni\u000bq\u0003T%O\u000b~\u001bu\nT0U/&\u001bUi\u0018)B)R+%K\u0014\u0011\t\u000b-\u0004A\u0011\u00017\u0002\r\t,gm\u001c:f)\u0005i\u0007C\u00018r\u001b\u0005y'\"\u00019\u0002\u000bM\u001c\u0017\r\\1\n\u0005I|'\u0001B+oSRD#A\u001b;\u0011\u0005UDX\"\u0001<\u000b\u0005]t\u0011!\u00026v]&$\u0018BA=w\u0005\u0019\u0011UMZ8sK\")1\u0010\u0001C\u0001Y\u0006)\u0011M\u001a;fe\"\u0012!0 \t\u0003kzL!a <\u0003\u000b\u00053G/\u001a:\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005qQ\r\u001f9mC&tGj\\4jG\u0006dG\u0003BA\u0004\u0003;\u0001B!!\u0003\u0002\u00189!\u00111BA\n!\r\tia\\\u0007\u0003\u0003\u001fQ1!!\u0005\u0011\u0003\u0019a$o\\8u}%\u0019\u0011QC8\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)b\u001c\u0005\b\u0013\u0005\u0005\u0001\u0019AA\u0010!\rq\u0012\u0011E\u0005\u0004\u0003Gy\"!\u0002+bE2,\u0007bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\fG\",7m\u001b*fgVdG\u000fF\u0004n\u0003W\ty#a\u0013\t\u0011\u00055\u0012Q\u0005a\u0001\u0003\u000f\t\u0001b]9m#V,'/\u001f\u0005\t\u0003c\t)\u00031\u0001\u00024\u0005qQ\r\u001f9fGR,GMU3tk2$\bCBA\u001b\u0003w\ty$\u0004\u0002\u00028)\u0019\u0011\u0011H8\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002>\u0005]\"aA*fcB!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002F)\tQ\u0001^=qKNLA!!\u0013\u0002D\t\u0019!k\\<\t\u0015\u00055\u0013Q\u0005I\u0001\u0002\u0004\ty%\u0001\u0005jgN{'\u000f^3e!\rq\u0017\u0011K\u0005\u0004\u0003'z'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003/\u0002A\u0011AA-\u0003A\u0019\u0007.Z2l)\u0006\u0014G.\u001a*fgVdG\u000fF\u0004n\u00037\ni&a\u0018\t\u000f%\t)\u00061\u0001\u0002 !A\u0011\u0011GA+\u0001\u0004\t\u0019\u0004\u0003\u0006\u0002N\u0005U\u0003\u0013!a\u0001\u0003\u001fBq!a\u0019\u0001\t\u0003\t)'A\u0005dQ\u0016\u001c7nU5{KR)Q.a\u001a\u0002j!A\u0011QFA1\u0001\u0004\t9\u0001\u0003\u0005\u0002l\u0005\u0005\u0004\u0019AA7\u00031)\u0007\u0010]3di\u0016$7+\u001b>f!\rq\u0017qN\u0005\u0004\u0003cz'aA%oi\"9\u0011Q\u000f\u0001\u0005\n\u0005]\u0014aB4fiBc\u0017M\u001c\u000b\u0005\u0003\u000f\tI\b\u0003\u0005\u0002|\u0005M\u0004\u0019AA?\u0003\u001d\u0011X\r\u001c(pI\u0016\u0004B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))A\u0002sK2T1!a\"\r\u0003\u001d\u0019\u0017\r\\2ji\u0016LA!a#\u0002\u0002\n9!+\u001a7O_\u0012,\u0007bBAH\u0001\u0011\u0005\u0011\u0011S\u0001\u0006G\",7m\u001b\u000b\u0006[\u0006M\u0015Q\u0013\u0005\t\u0003[\ti\t1\u0001\u0002\b!A\u0011qSAG\u0001\u0004\tI*A\u0005dQ\u0016\u001c7NR;oGB9a.a'\u00024\u0005}\u0015bAAO_\nIa)\u001e8di&|g.\r\t\u0006]\u0006\u0005\u0016qA\u0005\u0004\u0003G{'AB(qi&|g\u000eC\u0004\u0002(\u0002!\t!!+\u0002\u0015\rDWmY6UC\ndW\rF\u0003n\u0003W\u000bi\u000bC\u0004\n\u0003K\u0003\r!a\b\t\u0011\u0005]\u0015Q\u0015a\u0001\u00033Cq!!-\u0001\t\u0003\t\u0019,A\u0006dQ\u0016\u001c7NR1jY\u0016$G#B7\u00026\u0006]\u0006\u0002CA\u0017\u0003_\u0003\r!a\u0002\t\u0011\u0005e\u0016q\u0016a\u0001\u0003\u000f\t!#\u001a=qK\u000e$X\rZ'tOB\u000bG\u000f^3s]\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0016\u0001E2iK\u000e\\W)\u001c9usJ+7/\u001e7u)\ri\u0017\u0011\u0019\u0005\t\u0003[\tY\f1\u0001\u0002\b!9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0017A\u00039beN,\u0017+^3ssR!\u0011qDAe\u0011!\ti#a1A\u0002\u0005\u001d\u0001bBAg\u0001\u0011\u0005\u0011qZ\u0001\rKb,7-\u001e;f#V,'/\u001f\u000b\u0005\u0003g\t\t\u000eC\u0004\n\u0003\u0017\u0004\r!a\b\t\u000f\u00055\u0007\u0001\"\u0001\u0002VR!\u00111GAl\u0011!\ti#a5A\u0002\u0005\u001d\u0001bBAn\u0001\u0011%\u0011Q\\\u0001\u000eaJ,\u0007/\u0019:f%\u0016\u001cX\u000f\u001c;\u0015\r\u0005}\u0017\u0011]As!\u0019\t)$a\u000f\u0002\b!A\u00111]Am\u0001\u0004\t\u0019$A\u0002tKFD\u0001\"!\u0014\u0002Z\u0002\u0007\u0011q\n\u0005\b\u0003S\u0004A\u0011AAv\u0003%\u0019\u0007.Z2l'\u0006lW\r\u0006\u0005\u0002 \u00065\u0018q^Az\u0011!\t\t$a:A\u0002\u0005M\u0002\u0002CAy\u0003O\u0004\r!a\r\u0002\rI,7/\u001e7u\u0011)\ti%a:\u0011\u0002\u0003\u0007\u0011q\n\u0005\b\u0003o\u0004A\u0011BA}\u0003)\u0019\u0007.Z2l\u000b6\u0004H/\u001f\u000b\u0005\u0003?\u000bY\u0010\u0003\u0005\u0002r\u0006U\b\u0019AA\u001a\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003\t!b]5eK\nK8+\u001b3f)\u0019\u0011\u0019Aa\u0004\u0003\u0014A1\u0011QGA\u001e\u0005\u000b\u0001BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0004\u0005\u0017\u0001\u0017\u0001\u00027b]\u001eLA!!\u0007\u0003\n!A!\u0011CA\u007f\u0001\u0004\ty.\u0001\u0003mK\u001a$\b\u0002\u0003B\u000b\u0003{\u0004\r!a8\u0002\u000bILw\r\u001b;\t\u000f\te\u0001\u0001b\u0001\u0003\u001c\u0005\u0011\"/Z4jgR,'oQ8mY\u0016\u001cG/[8o)%i'Q\u0004B\u0011\u0005o\u0011i\u0005\u0003\u0005\u0003 \t]\u0001\u0019AA\u0004\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0003\u0005\u0003$\t]\u0001\u0019\u0001B\u0013\u0003\u0011!\u0017\r^1\u0011\r\t\u001d\"\u0011GA \u001d\u0011\u0011IC!\f\u000f\t\u00055!1F\u0005\u0002a&\u0019!qF8\u0002\u000fA\f7m[1hK&!!1\u0007B\u001b\u0005!IE/\u001a:bE2,'b\u0001B\u0018_\"A!\u0011\bB\f\u0001\u0004\u0011Y$\u0001\u0005usB,\u0017J\u001c4p!\u0019\u0011iD!\u0013\u0002@5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%\u0001\u0005usB,\u0017N\u001c4p\u0015\u0011\u0011)Ea\u0012\u0002\r\r|W.\\8o\u0015\t\u0001#\"\u0003\u0003\u0003L\t}\"a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\t\u0011\t=#q\u0003a\u0001\u0003\u000f\taAZ5fY\u0012\u001c\bb\u0002B*\u0001\u0011\u0005!QK\u0001\u0017e\u0016<\u0017n\u001d;fe*\u000bg/Y\"pY2,7\r^5p]V!!q\u000bB3)%i'\u0011\fB.\u0005o\u0012Y\b\u0003\u0005\u0003 \tE\u0003\u0019AA\u0004\u0011!\u0011\u0019C!\u0015A\u0002\tu\u0003C\u0002B\u0004\u0005?\u0012\t'\u0003\u0003\u00034\t%\u0001\u0003\u0002B2\u0005Kb\u0001\u0001\u0002\u0005\u0003h\tE#\u0019\u0001B5\u0005\u0005!\u0016\u0003\u0002B6\u0005c\u00022A\u001cB7\u0013\r\u0011yg\u001c\u0002\b\u001d>$\b.\u001b8h!\rq'1O\u0005\u0004\u0005kz'aA!os\"A!\u0011\bB)\u0001\u0004\u0011I\b\u0005\u0004\u0003>\t%#\u0011\r\u0005\t\u0005\u001f\u0012\t\u00061\u0001\u0002\b!9!\u0011\u0004\u0001\u0005\u0002\t}T\u0003\u0002BA\u0005\u0017#2\"\u001cBB\u0005\u000b\u0013iI!%\u0003\u0014\"A!q\u0004B?\u0001\u0004\t9\u0001\u0003\u0005\u0003$\tu\u0004\u0019\u0001BD!\u0019\u00119C!\r\u0003\nB!!1\rBF\t!\u00119G! C\u0002\t%\u0004\u0002\u0003B\u001d\u0005{\u0002\rAa$\u0011\r\tu\"\u0011\nBE\u0011!\u0011yE! A\u0002\u0005\u001d\u0001\u0002\u0003BK\u0005{\u0002\rAa&\u0002\u001d\u0019LW\r\u001c3Ok2d\u0017M\u00197fgB)aN!'\u0002P%\u0019!1T8\u0003\u000b\u0005\u0013(/Y=\t\u000f\te\u0001\u0001\"\u0001\u0003 V!!\u0011\u0015BV)5i'1\u0015BS\u0005[\u0013\tLa-\u00036\"A!q\u0004BO\u0001\u0004\t9\u0001\u0003\u0005\u0003$\tu\u0005\u0019\u0001BT!\u0019\u00119C!\r\u0003*B!!1\rBV\t!\u00119G!(C\u0002\t%\u0004\u0002\u0003B\u001d\u0005;\u0003\rAa,\u0011\r\tu\"\u0011\nBU\u0011!\u0011yE!(A\u0002\u0005\u001d\u0001\u0002\u0003BK\u0005;\u0003\rAa&\t\u0011\t]&Q\u0014a\u0001\u0005s\u000b\u0011b\u001d;bi&\u001cH/[2\u0011\t\tm&QY\u0007\u0003\u0005{SAAa0\u0003B\u0006)1\u000f^1ug*\u0019!1\u0019\u0004\u0002\tAd\u0017M\\\u0005\u0005\u0005\u000f\u0014iL\u0001\bGY&t7n\u0015;bi&\u001cH/[2\t\u000f\t-\u0007\u0001\"\u0001\u0003N\u0006y\"/Z4jgR,'\u000fV3na>\u0014\u0018M]=TsN$X-\u001c$v]\u000e$\u0018n\u001c8\u0015\u000b5\u0014yMa5\t\u0011\tE'\u0011\u001aa\u0001\u0003\u000f\tAA\\1nK\"A!Q\u001bBe\u0001\u0004\u00119.A\u0007gk:\u001cG/[8o\u00072\f7o\u001d\u0019\u0005\u00053\u0014\t\u000f\u0005\u0004\u0002\n\tm'q\\\u0005\u0005\u0005;\fYBA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0003d\t\u0005H\u0001\u0004Br\u0005'\f\t\u0011!A\u0003\u0002\t\u0015(aA0%cE!!1\u000eBt!\u0011\u0011IOa<\u000e\u0005\t-(b\u0001Bw\u0011\u0005Ia-\u001e8di&|gn]\u0005\u0005\u0005c\u0014YOA\nVg\u0016\u0014H)\u001a4j]\u0016$g)\u001e8di&|g\u000eC\u0004\u0003v\u0002!\tAa>\u0002!I,w-[:uKJ4UO\\2uS>tG#B7\u0003z\nm\b\u0002\u0003Bi\u0005g\u0004\r!a\u0002\t\u0011\tu(1\u001fa\u0001\u0005\u007f\f\u0001BZ;oGRLwN\u001c\t\u0005\u0005S\u001c\t!\u0003\u0003\u0004\u0004\t-(AD*dC2\f'OR;oGRLwN\u001c\u0015\t\u0005g\u001c9a!\u0004\u0004\"A\u0019an!\u0003\n\u0007\r-qN\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0014bIA\u0004\u0007\u001f\u00199b!\u0005\n\t\rE11C\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\rUq.\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0014bIB\r\u00077\u0019ib!\u0006\u000f\u00079\u001cY\"C\u0002\u0004\u0016=\fTA\t8p\u0007?\u0011Qa]2bY\u0006\f\u0014bIA\u0004\u0007G\u00199c!\n\n\t\r\u001521C\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a2\u0013\r\u001aIba\u0007\u0004*\rU\u0011'\u0002\u0012o_\u000e}\u0001b\u0002B{\u0001\u0011\u00051QF\u000b\u0007\u0007_\u0019Yd!\u0012\u0015\r\rE2\u0011JB&)\u0015i71GB\u001f\u0011)\u0019)da\u000b\u0002\u0002\u0003\u000f1qG\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004C\u0002B\u001f\u0005\u0013\u001aI\u0004\u0005\u0003\u0003d\rmB\u0001\u0003B4\u0007W\u0011\rA!\u001b\t\u0015\r}21FA\u0001\u0002\b\u0019\t%\u0001\u0006fm&$WM\\2fII\u0002bA!\u0010\u0003J\r\r\u0003\u0003\u0002B2\u0007\u000b\"\u0001ba\u0012\u0004,\t\u0007!\u0011\u000e\u0002\u0004\u0003\u000e\u001b\u0005\u0002\u0003Bi\u0007W\u0001\r!a\u0002\t\u0011\r531\u0006a\u0001\u0007\u001f\n\u0011A\u001a\t\t\u0005S\u001c\tf!\u000f\u0004D%!11\u000bBv\u0005E\tum\u001a:fO\u0006$XMR;oGRLwN\u001c\u0015\t\u0007W\u00199aa\u0016\u0004^EJ1%a\u0002\u0004\u0010\re3\u0011C\u0019\nG\re11DB.\u0007+\tTA\t8p\u0007?\t\u0014bIA\u0004\u0007G\u0019yf!\n2\u0013\r\u001aIba\u0007\u0004b\rU\u0011'\u0002\u0012o_\u000e}\u0001b\u0002B{\u0001\u0011\u00051QM\u000b\u0005\u0007O\u001a\u0019\b\u0006\u0004\u0004j\rU4q\u000f\u000b\u0004[\u000e-\u0004BCB7\u0007G\n\t\u0011q\u0001\u0004p\u0005QQM^5eK:\u001cW\rJ\u001a\u0011\r\tu\"\u0011JB9!\u0011\u0011\u0019ga\u001d\u0005\u0011\t\u001d41\rb\u0001\u0005SB\u0001B!5\u0004d\u0001\u0007\u0011q\u0001\u0005\t\u0007s\u001a\u0019\u00071\u0001\u0004|\u0005\u0011AO\u001a\t\u0007\u0005S\u001cih!\u001d\n\t\r}$1\u001e\u0002\u000e)\u0006\u0014G.\u001a$v]\u000e$\u0018n\u001c8)\u0011\r\r4qABB\u0007\u0013\u000b\u0014bIA\u0004\u0007\u001f\u0019)i!\u00052\u0013\r\u001aIba\u0007\u0004\b\u000eU\u0011'\u0002\u0012o_\u000e}\u0011'C\u0012\u0002\b\r\r21RB\u0013c%\u00193\u0011DB\u000e\u0007\u001b\u001b)\"M\u0003#]>\u001cy\u0002C\u0004\u0004\u0012\u0002!\taa%\u0002\u001bI,w-[:uKJ\u0014\u0016M\\4f)\u0015i7QSBL\u0011!\u0011\tna$A\u0002\u0005\u001d\u0001\u0002CBM\u0007\u001f\u0003\raa'\u0002\u0007\u0015tG\rE\u0002o\u0007;K1aa(p\u0005\u0011auN\\4\t\u000f\rE\u0005\u0001\"\u0001\u0004$R9Qn!*\u0004(\u000e-\u0006\u0002\u0003Bi\u0007C\u0003\r!a\u0002\t\u0011\r%6\u0011\u0015a\u0001\u00077\u000bQa\u001d;beRD\u0001b!'\u0004\"\u0002\u000711\u0014\u0005\b\u0007_\u0003A\u0011ABY\u00039qWm\u001e*b]\u001e,7k\\;sG\u0016$baa-\u0004J\u000e-\u0007CBB[\u0007w\u001by,\u0004\u0002\u00048*\u00191\u0011\u0018%\u0002\u0015\u0011\fG/Y:ue\u0016\fW.\u0003\u0003\u0004>\u000e]&A\u0003#bi\u0006\u001cFO]3b[B!1\u0011YBc\u001b\t\u0019\u0019MC\u0002\u0003$!IAaa2\u0004D\n9!k\\<ECR\f\u0007\u0002CBU\u0007[\u0003\raa'\t\u0011\re5Q\u0016a\u0001\u00077Cqaa4\u0001\t#\u0019\t.A\u0003s_^|e\r\u0006\u0003\u0002@\rM\u0007\u0002CBk\u0007\u001b\u0004\raa6\u0002\t\u0005\u0014xm\u001d\t\u0006]\u000ee'\u0011O\u0005\u0004\u00077|'A\u0003\u001fsKB,\u0017\r^3e}!I1q\u001c\u0001\u0012\u0002\u0013\u00051\u0011]\u0001\u0016G\",7m\u001b*fgVdG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\u0019O\u000b\u0003\u0002P\r\u00158FABt!\u0011\u0019Ioa=\u000e\u0005\r-(\u0002BBw\u0007_\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rEx.\u0001\u0006b]:|G/\u0019;j_:LAa!>\u0004l\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\re\b!%A\u0005\u0002\r\u0005\u0018AG2iK\u000e\\G+\u00192mKJ+7/\u001e7uI\u0011,g-Y;mi\u0012\u001a\u0004\"CB\u007f\u0001E\u0005I\u0011ABq\u0003M\u0019\u0007.Z2l'\u0006lW\r\n3fM\u0006,H\u000e\u001e\u00134\u000f\u001d!\tA\u0001E\u0001\t\u0007\tQBQ1uG\"$Vm\u001d;CCN,\u0007cA\n\u0005\u0006\u00191\u0011A\u0001E\u0001\t\u000f\u0019B\u0001\"\u0002\u0005\nA\u0019a\u000eb\u0003\n\u0007\u00115qN\u0001\u0004B]f\u0014VM\u001a\u0005\b/\u0011\u0015A\u0011\u0001C\t)\t!\u0019\u0001\u0003\u0005\u0005\u0016\u0011\u0015A\u0011\u0001C\f\u0003\r\u0011xn\u001e\u000b\u0005\u0003\u007f!I\u0002\u0003\u0005\u0004V\u0012M\u0001\u0019ABl\u0011!!i\u0002\"\u0002\u0005\u0002\u0011}\u0011!\u00032j]\u0006\u0014\u0018PU8x)\u0019!\t\u0003\"\f\u0005@A!A1\u0005C\u0015\u001b\t!)C\u0003\u0003\u0005(\r\r\u0017A\u00022j]\u0006\u0014\u00180\u0003\u0003\u0005,\u0011\u0015\"!\u0004\"j]\u0006\u0014\u0018PU8x\t\u0006$\u0018\r\u0003\u0005\u0002F\u0011m\u0001\u0019\u0001C\u0018!\u0015q'\u0011\u0014C\u0019!\u0011!\u0019\u0004b\u000f\u000e\u0005\u0011U\"\u0002\u0002C\u001c\ts\tq\u0001\\8hS\u000e\fGNC\u0002\u0002F!IA\u0001\"\u0010\u00056\tYAj\\4jG\u0006dG+\u001f9f\u0011!\u0011y\u0005b\u0007A\u0002\r]\u0007\u0002\u0003C\"\t\u000b!\t\u0001\"\u0012\u0002\u001b\r|W\u000e]1sKJ+7/\u001e7u+\u0011!9\u0005\"\u0016\u0015\u00135$I\u0005b\u0014\u0005X\u0011m\u0003\u0002\u0003C&\t\u0003\u0002\r\u0001\"\u0014\u0002\u001f\u0015D\b/Z2uK\u0012\u001cFO]5oON\u0004RA\u001cBM\u0003\u000fA\u0001\"!=\u0005B\u0001\u0007A\u0011\u000b\t\u0006]\neE1\u000b\t\u0005\u0005G\")\u0006\u0002\u0005\u0003h\u0011\u0005#\u0019\u0001B5\u0011!!I\u0006\"\u0011A\u0002\u0005=\u0013\u0001B:peRD!\u0002\"\u0018\u0005BA\u0005\t\u0019AA(\u0003!\t7\u000fV;qY\u0016\u001c\b\u0002\u0003C1\t\u000b!\t\u0001b\u0019\u0002)\r|gNZ5h\r>\u0014X*\u001b8j\u00072,8\u000f^3s)\riGQ\r\u0005\u0007!\u0012}\u0003\u0019\u0001*\t\u0015\u0011%DQAI\u0001\n\u0003!Y'A\fd_6\u0004\u0018M]3SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU!1\u0011\u001dC7\t!\u00119\u0007b\u001aC\u0002\t%\u0004")
public class BatchTestBase
extends BatchAbstractTestBase {
    private final EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
    private final TestingTableEnvironment testingTableEnv = TestingTableEnvironment$.MODULE$.create(this.settings(), (Option<CatalogManager>)None$.MODULE$, new TableConfig());
    private final TableEnvironment tEnv = this.testingTableEnv();
    private final PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner();
    private final StreamExecutionEnvironment env = this.planner().getExecEnv();
    private final TableConfig tableConfig;
    private final Pattern LINE_COL_PATTERN;
    private final Pattern LINE_COL_TWICE_PATTERN;

    public static <T> boolean compareResult$default$4() {
        return BatchTestBase$.MODULE$.compareResult$default$4();
    }

    public static void configForMiniCluster(TableConfig tableConfig) {
        BatchTestBase$.MODULE$.configForMiniCluster(tableConfig);
    }

    public static <T> void compareResult(String[] stringArray, Object object, boolean bl, boolean bl2) {
        BatchTestBase$.MODULE$.compareResult(stringArray, object, bl, bl2);
    }

    public static BinaryRowData binaryRow(LogicalType[] logicalTypeArray, Seq<Object> seq) {
        return BatchTestBase$.MODULE$.binaryRow(logicalTypeArray, seq);
    }

    public static Row row(Seq<Object> seq) {
        return BatchTestBase$.MODULE$.row(seq);
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    private TestingTableEnvironment testingTableEnv() {
        return this.testingTableEnv;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    private PlannerBase planner() {
        return this.planner;
    }

    public StreamExecutionEnvironment env() {
        return this.env;
    }

    public TableConfig tableConfig() {
        return this.tableConfig;
    }

    public Pattern LINE_COL_PATTERN() {
        return this.LINE_COL_PATTERN;
    }

    public Pattern LINE_COL_TWICE_PATTERN() {
        return this.LINE_COL_TWICE_PATTERN;
    }

    @Before
    public void before() {
        BatchTestBase$.MODULE$.configForMiniCluster(this.tableConfig());
    }

    @After
    public void after() {
        TestValuesTableFactory.clearAllData();
    }

    public String explainLogical(Table table) {
        RelNode ast = TableTestUtil$.MODULE$.toRelNode(table);
        String logicalPlan = this.getPlan(ast);
        return new StringBuilder(54).append("== Abstract Syntax Tree ==").append(System.lineSeparator()).append(String.valueOf(FlinkRelOptUtil$.MODULE$.toString(ast, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()))).append(System.lineSeparator()).append("== Optimized Logical Plan ==").append(System.lineSeparator()).append(String.valueOf(logicalPlan)).toString();
    }

    public void checkResult(String sqlQuery, Seq<Row> expectedResult, boolean isSorted) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> this.checkSame(expectedResult, (Seq<Row>)result, isSorted));
    }

    public void checkTableResult(Table table, Seq<Row> expectedResult, boolean isSorted) {
        this.checkTable(table, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> this.checkSame(expectedResult, (Seq<Row>)result, isSorted));
    }

    public void checkSize(String sqlQuery, int expectedSize) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> {
            None$ none$;
            if (result.size() != expectedSize) {
                String string = new StringBuilder(23).append("== Correct Result - ").append(expectedSize).append(" ==").toString();
                String string2 = new StringBuilder(22).append("== Actual Result - ").append(result.size()).append(" ==").toString();
                String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n               |Results\n               |").append(this.sideBySide((Seq<String>)((Seq)this.prepareResult((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), false).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.prepareResult((Seq<Row>)result, false).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n")).append("\n        ").toString())).stripMargin();
                none$ = new Some((Object)errorMessage);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    private String getPlan(RelNode relNode) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner();
        RelNode optimized = planner.optimize(relNode);
        return FlinkRelOptUtil$.MODULE$.toString(optimized, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5());
    }

    public void check(String sqlQuery, Function1<Seq<Row>, Option<String>> checkFunc) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1 & Serializable & scala.Serializable)results -> {
            BatchTestBase.$anonfun$check$1(this, sqlQuery, table, results);
            return BoxedUnit.UNIT;
        });
    }

    public boolean checkResult$default$3() {
        return false;
    }

    public void checkTable(Table table, Function1<Seq<Row>, Option<String>> checkFunc) {
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1 & Serializable & scala.Serializable)results -> {
            BatchTestBase.$anonfun$checkTable$1(this, table, results);
            return BoxedUnit.UNIT;
        });
    }

    public boolean checkTableResult$default$3() {
        return false;
    }

    public void checkFailed(String sqlQuery, String expectedMsgPattern) {
        block25: {
            try {
                Table table = this.parseQuery(sqlQuery);
                Seq<Row> _ = this.executeQuery(table);
                if (expectedMsgPattern != null) {
                    throw new AssertionError((Object)new StringBuilder(50).append("Expected query to throw exception, but it did not;").append(new StringBuilder(11).append(" query [").append(sqlQuery).append(" ];").toString()).append(new StringBuilder(12).append(" expected [").append(expectedMsgPattern).append("]").toString()).toString());
                }
            }
            catch (SqlParserException spe) {
                String errMsg = spe.getMessage();
                if (expectedMsgPattern == null) {
                    throw new RuntimeException(new StringBuilder(27).append("Error while parsing query: ").append(sqlQuery).toString(), spe);
                }
                if (errMsg == null || !errMsg.matches(expectedMsgPattern)) {
                    throw new RuntimeException(new StringBuilder(38).append("Error did not match expected [").append(expectedMsgPattern).append("] while ").append(new StringBuilder(16).append("parsing query [").append(sqlQuery).append("]").toString()).toString(), spe);
                }
            }
            catch (Throwable thrown) {
                Throwable actualExp = thrown;
                String actualMsg = actualExp.getMessage();
                int actualLine = -1;
                int actualColumn = -1;
                int actualEndLine = 100;
                int actualEndColumn = 99;
                CalciteContextException ece = null;
                SqlParseException spe = null;
                Throwable ex = actualExp;
                boolean found = false;
                while (ex != null && !found) {
                    BoxedUnit boxedUnit;
                    Throwable throwable = ex;
                    if (throwable instanceof CalciteContextException) {
                        CalciteContextException calciteContextException;
                        ece = calciteContextException = (CalciteContextException)throwable;
                        found = true;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        Throwable throwable3 = throwable2.getCause();
                        Throwable throwable4 = ex;
                        if (!(throwable3 != null ? !throwable3.equals(throwable4) : throwable4 != null)) {
                            found = true;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                    boxedUnit = BoxedUnit.UNIT;
                }
                ex = actualExp;
                found = false;
                while (ex != null && !found) {
                    BoxedUnit boxedUnit;
                    SqlParseException sqlParseException;
                    Throwable throwable = ex;
                    if (throwable instanceof SqlParseException && (sqlParseException = (SqlParseException)throwable).getPos() != null) {
                        spe = sqlParseException;
                        found = true;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable != null) {
                        Throwable throwable5 = throwable;
                        Throwable throwable6 = throwable5.getCause();
                        Throwable throwable7 = ex;
                        if (!(throwable6 != null ? !throwable6.equals(throwable7) : throwable7 != null)) {
                            found = true;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (ece != null) {
                    actualLine = ece.getPosLine();
                    actualColumn = ece.getPosColumn();
                    actualEndLine = ece.getEndPosLine();
                    actualEndColumn = ece.getEndPosColumn();
                    if (ece.getCause() != null) {
                        actualExp = ece.getCause();
                        actualMsg = actualExp.getMessage();
                    }
                } else if (spe != null) {
                    actualLine = spe.getPos().getLineNum();
                    actualColumn = spe.getPos().getColumnNum();
                    actualEndLine = spe.getPos().getEndLineNum();
                    actualEndColumn = spe.getPos().getEndColumnNum();
                    if (spe.getCause() != null) {
                        actualExp = spe.getCause();
                        actualMsg = actualExp.getMessage();
                    }
                } else {
                    String message = actualMsg;
                    if (message != null) {
                        Matcher matcher = this.LINE_COL_TWICE_PATTERN().matcher(message);
                        if (matcher.matches()) {
                            actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                            actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                            actualEndLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).toInt();
                            actualEndColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(4))).toInt();
                            actualMsg = matcher.group(5);
                        } else {
                            matcher = this.LINE_COL_PATTERN().matcher(message);
                            if (matcher.matches()) {
                                actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                                actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                            }
                        }
                    }
                }
                if (expectedMsgPattern == null) {
                    actualExp.printStackTrace();
                    Assert.fail((String)new StringBuilder(47).append("Validator threw unexpected exception; query [").append(sqlQuery).append("];").append(new StringBuilder(33).append(" exception [").append(actualMsg).append("]; class [").append(actualExp).append(".getClass];").toString()).append(new StringBuilder(33).append(" pos [line ").append(actualLine).append(" col ").append(actualColumn).append(" thru line ").append(actualLine).append(" col ").append(actualColumn).append("]").toString()).toString());
                }
                if (actualMsg != null && actualMsg.matches(expectedMsgPattern)) break block25;
                actualExp.printStackTrace();
                Assert.fail((String)new StringBuilder(26).append("Validator threw different ").append(new StringBuilder(35).append("exception than expected; query [").append(sqlQuery).append("];\n").toString()).append(new StringBuilder(22).append(" expected pattern [").append(expectedMsgPattern).append("];\n").toString()).append(new StringBuilder(12).append(" actual [").append(actualMsg).append("];\n").toString()).append(new StringBuilder(6).append(" pos [").append(actualLine).toString()).append(new StringBuilder(5).append(" col ").append(actualColumn).toString()).append(new StringBuilder(11).append(" thru line ").append(actualEndLine).toString()).append(new StringBuilder(7).append(" col ").append(actualEndColumn).append("].").toString()).toString());
            }
        }
    }

    public void checkEmptyResult(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        this.checkEmpty(result).foreach((Function1 & Serializable & scala.Serializable)results -> {
            BatchTestBase.$anonfun$checkEmptyResult$1(results);
            return BoxedUnit.UNIT;
        });
    }

    public Table parseQuery(String sqlQuery) {
        return this.tEnv().sqlQuery(sqlQuery);
    }

    public Seq<Row> executeQuery(Table table) {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(CollectionUtil.iteratorToList((Iterator)table.execute().collect())).asScala();
    }

    public Seq<Row> executeQuery(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        return this.executeQuery(table);
    }

    private Seq<String> prepareResult(Seq<Row> seq, boolean isSorted) {
        return !isSorted ? (Seq)((SeqLike)seq.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)s -> s, (Ordering)Ordering.String$.MODULE$) : (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> checkSame(Seq<Row> expectedResult, Seq<Row> result, boolean isSorted) {
        None$ none$;
        if (expectedResult.size() != result.size() || !this.prepareResult(expectedResult, isSorted).equals(this.prepareResult(result, isSorted))) {
            String string = new StringBuilder(23).append("== Correct Result - ").append(expectedResult.size()).append(" ==").toString();
            String string2 = new StringBuilder(22).append("== Actual Result - ").append(result.size()).append(" ==").toString();
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(42).append("\n           |Results\n           |").append(this.sideBySide((Seq<String>)((Seq)this.prepareResult(expectedResult, isSorted).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.prepareResult(result, isSorted).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n")).append("\n        ").toString())).stripMargin();
            none$ = new Some((Object)errorMessage);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean checkSame$default$3() {
        return false;
    }

    private Option<String> checkEmpty(Seq<Row> result) {
        Nil$ expectedResult = Nil$.MODULE$;
        return this.checkSame((Seq<Row>)expectedResult, result, true);
    }

    private Seq<String> sideBySide(Seq<String> left, Seq<String> right) {
        int maxLeftSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)left.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.length()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Seq leftPadded = (Seq)left.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(package$.MODULE$.max(right.size() - left.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        Seq rightPadded = (Seq)right.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(package$.MODULE$.max(left.size() - right.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)leftPadded.zip((GenIterable)rightPadded, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String l = (String)tuple2._1();
            String r = (String)tuple2._2();
            String string = l;
            String string2 = r;
            String string3 = new StringBuilder(0).append(!(string == null ? string2 != null : !string.equals(string2)) || l.startsWith("== Correct") ? " " : "!").append(l).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxLeftSize - l.length() + 3)).append(r).toString();
            return string3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void registerCollection(String tableName, Iterable<Row> data, TypeInformation<Row> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields);
    }

    public <T> void registerJavaCollection(String tableName, java.lang.Iterable<T> data, TypeInformation<T> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala(), typeInfo, fields);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables, FlinkStatistic statistic) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)new Some((Object)statistic));
    }

    public void registerTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> functionClass) {
        this.testingTableEnv().createTemporarySystemFunction(name, functionClass);
    }

    public void registerFunction(String name, ScalarFunction function) {
        this.testingTableEnv().registerFunction(name, function);
    }

    public <T, ACC> void registerFunction(String name, AggregateFunction<T, ACC> f, TypeInformation<T> evidence$1, TypeInformation<ACC> evidence$2) {
        this.testingTableEnv().registerFunction(name, f, evidence$1, evidence$2);
    }

    public <T> void registerFunction(String name, TableFunction<T> tf, TypeInformation<T> evidence$3) {
        this.testingTableEnv().registerFunction(name, tf, evidence$3);
    }

    public void registerRange(String name, long end) {
        this.registerRange(name, 0L, end);
    }

    public void registerRange(String name, long start, long end) {
        BatchTableEnvUtil$.MODULE$.registerBoundedStreamInternal(this.tEnv(), name, this.newRangeSource(start, end), (Option<String[]>)new Some((Object)new String[]{"id"}), (Option<boolean[]>)None$.MODULE$, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public DataStream<RowData> newRangeSource(long start, long end) {
        InternalTypeInfo typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new BigIntType()});
        DataStreamSource boundedStream = this.env().createInput((InputFormat)new RangeInputFormat(start, end), (TypeInformation)typeInfo);
        boundedStream.setParallelism(1);
        return boundedStream;
    }

    /*
     * WARNING - void declaration
     */
    public Row rowOf(Seq<Object> args) {
        void var2_2;
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$check$1(BatchTestBase $this, String sqlQuery$1, Table table$2, String results) {
        String plan = $this.explainLogical(table$2);
        Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(173).append("\n                       |Results do not match for query:\n                       |  ").append(sqlQuery$1).append("\n                       |").append(results).append("\n                       |Plan:\n                       |  ").append(plan).append("\n       ").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$checkTable$1(BatchTestBase $this, Table table$1, String results) {
        String plan = $this.explainLogical(table$1);
        Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n                       |Results do not match:\n                       |").append(results).append("\n                       |Plan:\n                       |  ").append(plan).append("\n       ").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$checkEmptyResult$1(String results) {
        Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n                       |Results do not match for query:\n                       |").append(results).append("\n       ").toString())).stripMargin());
    }

    public BatchTestBase() {
        this.env().getConfig().enableObjectReuse();
        this.tableConfig = this.tEnv().getConfig();
        this.LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
        this.LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");
    }
}

