/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.typeutils;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.typeutils.LogicalRelDataTypeConverter;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class LogicalRelDataTypeConverterTest {
    @ParameterizedTest
    @MethodSource(value={"testConversion"})
    public void testConversion(LogicalType logicalType) throws IOException {
        FlinkTypeFactory typeFactory = FlinkTypeFactory.INSTANCE();
        DataTypeFactoryMock dataTypeFactory = new DataTypeFactoryMock();
        RelDataType relDataType = LogicalRelDataTypeConverter.toRelDataType((LogicalType)logicalType, (RelDataTypeFactory)typeFactory);
        TableAssertions.assertThat((LogicalType)LogicalRelDataTypeConverter.toLogicalType((RelDataType)relDataType, (DataTypeFactory)dataTypeFactory)).isEqualTo((Object)logicalType);
    }

    private static Stream<LogicalType> testConversion() {
        return Stream.of(new BooleanType(), new TinyIntType(), new SmallIntType(), new IntType(), new BigIntType(), new FloatType(), new DoubleType(), new DecimalType(10), new DecimalType(15, 5), CharType.ofEmptyLiteral(), new CharType(), new CharType(5), VarCharType.ofEmptyLiteral(), new VarCharType(), new VarCharType(5), BinaryType.ofEmptyLiteral(), new BinaryType(), new BinaryType(100), VarBinaryType.ofEmptyLiteral(), new VarBinaryType(), new VarBinaryType(100), new DateType(), new TimeType(), new TimeType(3), new TimestampType(), new TimestampType(3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new TimestampType(false, TimestampKind.ROWTIME, 3), new LocalZonedTimestampType(), new LocalZonedTimestampType(3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR), new DayTimeIntervalType(false, DayTimeIntervalType.DayTimeResolution.DAY_TO_HOUR, 3, 6), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH), new YearMonthIntervalType(false, YearMonthIntervalType.YearMonthResolution.MONTH, 2), new LocalZonedTimestampType(), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new SymbolType(), new ArrayType((LogicalType)new IntType(false)), new ArrayType((LogicalType)new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3)), new ArrayType((LogicalType)new TimestampType()), new ArrayType((LogicalType)CharType.ofEmptyLiteral()), new ArrayType((LogicalType)VarCharType.ofEmptyLiteral()), new ArrayType((LogicalType)BinaryType.ofEmptyLiteral()), new ArrayType((LogicalType)VarBinaryType.ofEmptyLiteral()), new MapType((LogicalType)new BigIntType(), (LogicalType)new IntType(false)), new MapType((LogicalType)new TimestampType(false, TimestampKind.ROWTIME, 3), (LogicalType)new LocalZonedTimestampType()), new MapType((LogicalType)CharType.ofEmptyLiteral(), (LogicalType)CharType.ofEmptyLiteral()), new MapType((LogicalType)VarCharType.ofEmptyLiteral(), (LogicalType)VarCharType.ofEmptyLiteral()), new MapType((LogicalType)BinaryType.ofEmptyLiteral(), (LogicalType)BinaryType.ofEmptyLiteral()), new MapType((LogicalType)VarBinaryType.ofEmptyLiteral(), (LogicalType)VarBinaryType.ofEmptyLiteral()), new MultisetType((LogicalType)new IntType(false)), new MultisetType((LogicalType)new TimestampType()), new MultisetType((LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 3)), new MultisetType((LogicalType)CharType.ofEmptyLiteral()), new MultisetType((LogicalType)VarCharType.ofEmptyLiteral()), new MultisetType((LogicalType)BinaryType.ofEmptyLiteral()), new MultisetType((LogicalType)VarBinaryType.ofEmptyLiteral()), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(false), new VarCharType(200)}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new IntType(false), new VarCharType(200)}, (String[])new String[]{"f1", "f2", "f3"}), RowType.of((LogicalType[])new LogicalType[]{new TimestampType(false, TimestampKind.ROWTIME, 3), new TimestampType(false, TimestampKind.REGULAR, 3), new LocalZonedTimestampType(false, TimestampKind.ROWTIME, 3), new LocalZonedTimestampType(false, TimestampKind.PROCTIME, 3), new LocalZonedTimestampType(false, TimestampKind.REGULAR, 3)}), RowType.of((LogicalType[])new LogicalType[]{CharType.ofEmptyLiteral(), VarCharType.ofEmptyLiteral(), BinaryType.ofEmptyLiteral(), VarBinaryType.ofEmptyLiteral()}), PojoClass.TYPE_WITH_IDENTIFIER, StructuredType.newBuilder(PojoClass.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new IntType(true)), new StructuredType.StructuredAttribute("f1", (LogicalType)new BigIntType(true)), new StructuredType.StructuredAttribute("f2", (LogicalType)new VarCharType(200), "desc"))).build(), new RawType(LocalDateTime.class, (TypeSerializer)LocalDateTimeSerializer.INSTANCE));
    }

    public static class PojoClass {
        public static final LogicalType TYPE_WITH_IDENTIFIER = StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"structuredType"), PojoClass.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new IntType(true)), new StructuredType.StructuredAttribute("f1", (LogicalType)new BigIntType(true)), new StructuredType.StructuredAttribute("f2", (LogicalType)new VarCharType(200), "desc"))).comparison(StructuredType.StructuredComparison.FULL).setFinal(false).setInstantiable(false).superType(StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"structuredType2")).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("f0", (LogicalType)new BigIntType(false)))).build()).description("description for StructuredType").build();
        public int f0;
        public long f1;
        public String f2;
    }
}

